/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration updates for an Amazon FSx for OpenZFS file system.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFileSystemOpenZFSConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateFileSystemOpenZFSConfiguration.Builder, UpdateFileSystemOpenZFSConfiguration> {
    private static final SdkField<Integer> AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("AutomaticBackupRetentionDays")
            .getter(getter(UpdateFileSystemOpenZFSConfiguration::automaticBackupRetentionDays))
            .setter(setter(Builder::automaticBackupRetentionDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticBackupRetentionDays")
                    .build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_BACKUPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToBackups").getter(getter(UpdateFileSystemOpenZFSConfiguration::copyTagsToBackups))
            .setter(setter(Builder::copyTagsToBackups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToBackups").build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_VOLUMES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToVolumes").getter(getter(UpdateFileSystemOpenZFSConfiguration::copyTagsToVolumes))
            .setter(setter(Builder::copyTagsToVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToVolumes").build()).build();

    private static final SdkField<String> DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DailyAutomaticBackupStartTime")
            .getter(getter(UpdateFileSystemOpenZFSConfiguration::dailyAutomaticBackupStartTime))
            .setter(setter(Builder::dailyAutomaticBackupStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DailyAutomaticBackupStartTime")
                    .build()).build();

    private static final SdkField<Integer> THROUGHPUT_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThroughputCapacity").getter(getter(UpdateFileSystemOpenZFSConfiguration::throughputCapacity))
            .setter(setter(Builder::throughputCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThroughputCapacity").build())
            .build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_START_TIME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceStartTime")
            .getter(getter(UpdateFileSystemOpenZFSConfiguration::weeklyMaintenanceStartTime))
            .setter(setter(Builder::weeklyMaintenanceStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceStartTime").build())
            .build();

    private static final SdkField<DiskIopsConfiguration> DISK_IOPS_CONFIGURATION_FIELD = SdkField
            .<DiskIopsConfiguration> builder(MarshallingType.SDK_POJO).memberName("DiskIopsConfiguration")
            .getter(getter(UpdateFileSystemOpenZFSConfiguration::diskIopsConfiguration))
            .setter(setter(Builder::diskIopsConfiguration)).constructor(DiskIopsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskIopsConfiguration").build())
            .build();

    private static final SdkField<List<String>> ADD_ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AddRouteTableIds")
            .getter(getter(UpdateFileSystemOpenZFSConfiguration::addRouteTableIds))
            .setter(setter(Builder::addRouteTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddRouteTableIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> REMOVE_ROUTE_TABLE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RemoveRouteTableIds")
            .getter(getter(UpdateFileSystemOpenZFSConfiguration::removeRouteTableIds))
            .setter(setter(Builder::removeRouteTableIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveRouteTableIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            AUTOMATIC_BACKUP_RETENTION_DAYS_FIELD, COPY_TAGS_TO_BACKUPS_FIELD, COPY_TAGS_TO_VOLUMES_FIELD,
            DAILY_AUTOMATIC_BACKUP_START_TIME_FIELD, THROUGHPUT_CAPACITY_FIELD, WEEKLY_MAINTENANCE_START_TIME_FIELD,
            DISK_IOPS_CONFIGURATION_FIELD, ADD_ROUTE_TABLE_IDS_FIELD, REMOVE_ROUTE_TABLE_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer automaticBackupRetentionDays;

    private final Boolean copyTagsToBackups;

    private final Boolean copyTagsToVolumes;

    private final String dailyAutomaticBackupStartTime;

    private final Integer throughputCapacity;

    private final String weeklyMaintenanceStartTime;

    private final DiskIopsConfiguration diskIopsConfiguration;

    private final List<String> addRouteTableIds;

    private final List<String> removeRouteTableIds;

    private UpdateFileSystemOpenZFSConfiguration(BuilderImpl builder) {
        this.automaticBackupRetentionDays = builder.automaticBackupRetentionDays;
        this.copyTagsToBackups = builder.copyTagsToBackups;
        this.copyTagsToVolumes = builder.copyTagsToVolumes;
        this.dailyAutomaticBackupStartTime = builder.dailyAutomaticBackupStartTime;
        this.throughputCapacity = builder.throughputCapacity;
        this.weeklyMaintenanceStartTime = builder.weeklyMaintenanceStartTime;
        this.diskIopsConfiguration = builder.diskIopsConfiguration;
        this.addRouteTableIds = builder.addRouteTableIds;
        this.removeRouteTableIds = builder.removeRouteTableIds;
    }

    /**
     * Returns the value of the AutomaticBackupRetentionDays property for this object.
     * 
     * @return The value of the AutomaticBackupRetentionDays property for this object.
     */
    public final Integer automaticBackupRetentionDays() {
        return automaticBackupRetentionDays;
    }

    /**
     * <p>
     * A Boolean value indicating whether tags for the file system should be copied to backups. This value defaults to
     * <code>false</code>. If it's set to <code>true</code>, all tags for the file system are copied to all automatic
     * and user-initiated backups where the user doesn't specify tags. If this value is <code>true</code> and you
     * specify one or more tags, only the specified tags are copied to backups. If you specify one or more tags when
     * creating a user-initiated backup, no tags are copied from the file system, regardless of this value.
     * </p>
     * 
     * @return A Boolean value indicating whether tags for the file system should be copied to backups. This value
     *         defaults to <code>false</code>. If it's set to <code>true</code>, all tags for the file system are copied
     *         to all automatic and user-initiated backups where the user doesn't specify tags. If this value is
     *         <code>true</code> and you specify one or more tags, only the specified tags are copied to backups. If you
     *         specify one or more tags when creating a user-initiated backup, no tags are copied from the file system,
     *         regardless of this value.
     */
    public final Boolean copyTagsToBackups() {
        return copyTagsToBackups;
    }

    /**
     * <p>
     * A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to
     * <code>false</code>. If it's set to <code>true</code>, all tags for the volume are copied to snapshots where the
     * user doesn't specify tags. If this value is <code>true</code> and you specify one or more tags, only the
     * specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags are
     * copied from the volume, regardless of this value.
     * </p>
     * 
     * @return A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults
     *         to <code>false</code>. If it's set to <code>true</code>, all tags for the volume are copied to snapshots
     *         where the user doesn't specify tags. If this value is <code>true</code> and you specify one or more tags,
     *         only the specified tags are copied to snapshots. If you specify one or more tags when creating the
     *         snapshot, no tags are copied from the volume, regardless of this value.
     */
    public final Boolean copyTagsToVolumes() {
        return copyTagsToVolumes;
    }

    /**
     * Returns the value of the DailyAutomaticBackupStartTime property for this object.
     * 
     * @return The value of the DailyAutomaticBackupStartTime property for this object.
     */
    public final String dailyAutomaticBackupStartTime() {
        return dailyAutomaticBackupStartTime;
    }

    /**
     * <p>
     * The throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second&#x2028; (MB/s). Valid
     * values depend on the DeploymentType you choose, as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * For <code>MULTI_AZ_1</code> and <code>SINGLE_AZ_2</code>, valid values are 160, 320, 640, 1280, 2560, 3840, 5120,
     * 7680, or 10240 MBps.
     * </p>
     * </li>
     * <li>
     * <p>
     * For <code>SINGLE_AZ_1</code>, valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second&#x2028; (MB/s).
     *         Valid values depend on the DeploymentType you choose, as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         For <code>MULTI_AZ_1</code> and <code>SINGLE_AZ_2</code>, valid values are 160, 320, 640, 1280, 2560,
     *         3840, 5120, 7680, or 10240 MBps.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For <code>SINGLE_AZ_1</code>, valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.
     *         </p>
     *         </li>
     */
    public final Integer throughputCapacity() {
        return throughputCapacity;
    }

    /**
     * Returns the value of the WeeklyMaintenanceStartTime property for this object.
     * 
     * @return The value of the WeeklyMaintenanceStartTime property for this object.
     */
    public final String weeklyMaintenanceStartTime() {
        return weeklyMaintenanceStartTime;
    }

    /**
     * Returns the value of the DiskIopsConfiguration property for this object.
     * 
     * @return The value of the DiskIopsConfiguration property for this object.
     */
    public final DiskIopsConfiguration diskIopsConfiguration() {
        return diskIopsConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the AddRouteTableIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAddRouteTableIds() {
        return addRouteTableIds != null && !(addRouteTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with your Amazon
     * FSx for OpenZFS file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAddRouteTableIds} method.
     * </p>
     * 
     * @return (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with
     *         your Amazon FSx for OpenZFS file system.
     */
    public final List<String> addRouteTableIds() {
        return addRouteTableIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the RemoveRouteTableIds property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRemoveRouteTableIds() {
        return removeRouteTableIds != null && !(removeRouteTableIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate (remove) from
     * your Amazon FSx for OpenZFS file system. You can use the API operation to retrieve the list of VPC route table
     * IDs for a file system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemoveRouteTableIds} method.
     * </p>
     * 
     * @return (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate
     *         (remove) from your Amazon FSx for OpenZFS file system. You can use the API operation to retrieve the list
     *         of VPC route table IDs for a file system.
     */
    public final List<String> removeRouteTableIds() {
        return removeRouteTableIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(automaticBackupRetentionDays());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToBackups());
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToVolumes());
        hashCode = 31 * hashCode + Objects.hashCode(dailyAutomaticBackupStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(throughputCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(diskIopsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasAddRouteTableIds() ? addRouteTableIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemoveRouteTableIds() ? removeRouteTableIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFileSystemOpenZFSConfiguration)) {
            return false;
        }
        UpdateFileSystemOpenZFSConfiguration other = (UpdateFileSystemOpenZFSConfiguration) obj;
        return Objects.equals(automaticBackupRetentionDays(), other.automaticBackupRetentionDays())
                && Objects.equals(copyTagsToBackups(), other.copyTagsToBackups())
                && Objects.equals(copyTagsToVolumes(), other.copyTagsToVolumes())
                && Objects.equals(dailyAutomaticBackupStartTime(), other.dailyAutomaticBackupStartTime())
                && Objects.equals(throughputCapacity(), other.throughputCapacity())
                && Objects.equals(weeklyMaintenanceStartTime(), other.weeklyMaintenanceStartTime())
                && Objects.equals(diskIopsConfiguration(), other.diskIopsConfiguration())
                && hasAddRouteTableIds() == other.hasAddRouteTableIds()
                && Objects.equals(addRouteTableIds(), other.addRouteTableIds())
                && hasRemoveRouteTableIds() == other.hasRemoveRouteTableIds()
                && Objects.equals(removeRouteTableIds(), other.removeRouteTableIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFileSystemOpenZFSConfiguration")
                .add("AutomaticBackupRetentionDays", automaticBackupRetentionDays())
                .add("CopyTagsToBackups", copyTagsToBackups()).add("CopyTagsToVolumes", copyTagsToVolumes())
                .add("DailyAutomaticBackupStartTime", dailyAutomaticBackupStartTime())
                .add("ThroughputCapacity", throughputCapacity()).add("WeeklyMaintenanceStartTime", weeklyMaintenanceStartTime())
                .add("DiskIopsConfiguration", diskIopsConfiguration())
                .add("AddRouteTableIds", hasAddRouteTableIds() ? addRouteTableIds() : null)
                .add("RemoveRouteTableIds", hasRemoveRouteTableIds() ? removeRouteTableIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomaticBackupRetentionDays":
            return Optional.ofNullable(clazz.cast(automaticBackupRetentionDays()));
        case "CopyTagsToBackups":
            return Optional.ofNullable(clazz.cast(copyTagsToBackups()));
        case "CopyTagsToVolumes":
            return Optional.ofNullable(clazz.cast(copyTagsToVolumes()));
        case "DailyAutomaticBackupStartTime":
            return Optional.ofNullable(clazz.cast(dailyAutomaticBackupStartTime()));
        case "ThroughputCapacity":
            return Optional.ofNullable(clazz.cast(throughputCapacity()));
        case "WeeklyMaintenanceStartTime":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceStartTime()));
        case "DiskIopsConfiguration":
            return Optional.ofNullable(clazz.cast(diskIopsConfiguration()));
        case "AddRouteTableIds":
            return Optional.ofNullable(clazz.cast(addRouteTableIds()));
        case "RemoveRouteTableIds":
            return Optional.ofNullable(clazz.cast(removeRouteTableIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFileSystemOpenZFSConfiguration, T> g) {
        return obj -> g.apply((UpdateFileSystemOpenZFSConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateFileSystemOpenZFSConfiguration> {
        /**
         * Sets the value of the AutomaticBackupRetentionDays property for this object.
         *
         * @param automaticBackupRetentionDays
         *        The new value for the AutomaticBackupRetentionDays property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays);

        /**
         * <p>
         * A Boolean value indicating whether tags for the file system should be copied to backups. This value defaults
         * to <code>false</code>. If it's set to <code>true</code>, all tags for the file system are copied to all
         * automatic and user-initiated backups where the user doesn't specify tags. If this value is <code>true</code>
         * and you specify one or more tags, only the specified tags are copied to backups. If you specify one or more
         * tags when creating a user-initiated backup, no tags are copied from the file system, regardless of this
         * value.
         * </p>
         * 
         * @param copyTagsToBackups
         *        A Boolean value indicating whether tags for the file system should be copied to backups. This value
         *        defaults to <code>false</code>. If it's set to <code>true</code>, all tags for the file system are
         *        copied to all automatic and user-initiated backups where the user doesn't specify tags. If this value
         *        is <code>true</code> and you specify one or more tags, only the specified tags are copied to backups.
         *        If you specify one or more tags when creating a user-initiated backup, no tags are copied from the
         *        file system, regardless of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToBackups(Boolean copyTagsToBackups);

        /**
         * <p>
         * A Boolean value indicating whether tags for the volume should be copied to snapshots. This value defaults to
         * <code>false</code>. If it's set to <code>true</code>, all tags for the volume are copied to snapshots where
         * the user doesn't specify tags. If this value is <code>true</code> and you specify one or more tags, only the
         * specified tags are copied to snapshots. If you specify one or more tags when creating the snapshot, no tags
         * are copied from the volume, regardless of this value.
         * </p>
         * 
         * @param copyTagsToVolumes
         *        A Boolean value indicating whether tags for the volume should be copied to snapshots. This value
         *        defaults to <code>false</code>. If it's set to <code>true</code>, all tags for the volume are copied
         *        to snapshots where the user doesn't specify tags. If this value is <code>true</code> and you specify
         *        one or more tags, only the specified tags are copied to snapshots. If you specify one or more tags
         *        when creating the snapshot, no tags are copied from the volume, regardless of this value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToVolumes(Boolean copyTagsToVolumes);

        /**
         * Sets the value of the DailyAutomaticBackupStartTime property for this object.
         *
         * @param dailyAutomaticBackupStartTime
         *        The new value for the DailyAutomaticBackupStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime);

        /**
         * <p>
         * The throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second&#x2028; (MB/s).
         * Valid values depend on the DeploymentType you choose, as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * For <code>MULTI_AZ_1</code> and <code>SINGLE_AZ_2</code>, valid values are 160, 320, 640, 1280, 2560, 3840,
         * 5120, 7680, or 10240 MBps.
         * </p>
         * </li>
         * <li>
         * <p>
         * For <code>SINGLE_AZ_1</code>, valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.
         * </p>
         * </li>
         * </ul>
         * 
         * @param throughputCapacity
         *        The throughput of an Amazon FSx for OpenZFS file system, measured in megabytes per second&#x2028;
         *        (MB/s). Valid values depend on the DeploymentType you choose, as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        For <code>MULTI_AZ_1</code> and <code>SINGLE_AZ_2</code>, valid values are 160, 320, 640, 1280, 2560,
         *        3840, 5120, 7680, or 10240 MBps.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For <code>SINGLE_AZ_1</code>, valid values are 64, 128, 256, 512, 1024, 2048, 3072, or 4096 MB/s.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throughputCapacity(Integer throughputCapacity);

        /**
         * Sets the value of the WeeklyMaintenanceStartTime property for this object.
         *
         * @param weeklyMaintenanceStartTime
         *        The new value for the WeeklyMaintenanceStartTime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime);

        /**
         * Sets the value of the DiskIopsConfiguration property for this object.
         *
         * @param diskIopsConfiguration
         *        The new value for the DiskIopsConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration);

        /**
         * Sets the value of the DiskIopsConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DiskIopsConfiguration.Builder} avoiding
         * the need to create one manually via {@link DiskIopsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DiskIopsConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #diskIopsConfiguration(DiskIopsConfiguration)}.
         * 
         * @param diskIopsConfiguration
         *        a consumer that will call methods on {@link DiskIopsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #diskIopsConfiguration(DiskIopsConfiguration)
         */
        default Builder diskIopsConfiguration(Consumer<DiskIopsConfiguration.Builder> diskIopsConfiguration) {
            return diskIopsConfiguration(DiskIopsConfiguration.builder().applyMutation(diskIopsConfiguration).build());
        }

        /**
         * <p>
         * (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with your
         * Amazon FSx for OpenZFS file system.
         * </p>
         * 
         * @param addRouteTableIds
         *        (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with
         *        your Amazon FSx for OpenZFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(Collection<String> addRouteTableIds);

        /**
         * <p>
         * (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with your
         * Amazon FSx for OpenZFS file system.
         * </p>
         * 
         * @param addRouteTableIds
         *        (Multi-AZ only) A list of IDs of new virtual private cloud (VPC) route tables to associate (add) with
         *        your Amazon FSx for OpenZFS file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addRouteTableIds(String... addRouteTableIds);

        /**
         * <p>
         * (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate (remove)
         * from your Amazon FSx for OpenZFS file system. You can use the API operation to retrieve the list of VPC route
         * table IDs for a file system.
         * </p>
         * 
         * @param removeRouteTableIds
         *        (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate
         *        (remove) from your Amazon FSx for OpenZFS file system. You can use the API operation to retrieve the
         *        list of VPC route table IDs for a file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(Collection<String> removeRouteTableIds);

        /**
         * <p>
         * (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate (remove)
         * from your Amazon FSx for OpenZFS file system. You can use the API operation to retrieve the list of VPC route
         * table IDs for a file system.
         * </p>
         * 
         * @param removeRouteTableIds
         *        (Multi-AZ only) A list of IDs of existing virtual private cloud (VPC) route tables to disassociate
         *        (remove) from your Amazon FSx for OpenZFS file system. You can use the API operation to retrieve the
         *        list of VPC route table IDs for a file system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeRouteTableIds(String... removeRouteTableIds);
    }

    static final class BuilderImpl implements Builder {
        private Integer automaticBackupRetentionDays;

        private Boolean copyTagsToBackups;

        private Boolean copyTagsToVolumes;

        private String dailyAutomaticBackupStartTime;

        private Integer throughputCapacity;

        private String weeklyMaintenanceStartTime;

        private DiskIopsConfiguration diskIopsConfiguration;

        private List<String> addRouteTableIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> removeRouteTableIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFileSystemOpenZFSConfiguration model) {
            automaticBackupRetentionDays(model.automaticBackupRetentionDays);
            copyTagsToBackups(model.copyTagsToBackups);
            copyTagsToVolumes(model.copyTagsToVolumes);
            dailyAutomaticBackupStartTime(model.dailyAutomaticBackupStartTime);
            throughputCapacity(model.throughputCapacity);
            weeklyMaintenanceStartTime(model.weeklyMaintenanceStartTime);
            diskIopsConfiguration(model.diskIopsConfiguration);
            addRouteTableIds(model.addRouteTableIds);
            removeRouteTableIds(model.removeRouteTableIds);
        }

        public final Integer getAutomaticBackupRetentionDays() {
            return automaticBackupRetentionDays;
        }

        public final void setAutomaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
        }

        @Override
        public final Builder automaticBackupRetentionDays(Integer automaticBackupRetentionDays) {
            this.automaticBackupRetentionDays = automaticBackupRetentionDays;
            return this;
        }

        public final Boolean getCopyTagsToBackups() {
            return copyTagsToBackups;
        }

        public final void setCopyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
        }

        @Override
        public final Builder copyTagsToBackups(Boolean copyTagsToBackups) {
            this.copyTagsToBackups = copyTagsToBackups;
            return this;
        }

        public final Boolean getCopyTagsToVolumes() {
            return copyTagsToVolumes;
        }

        public final void setCopyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
        }

        @Override
        public final Builder copyTagsToVolumes(Boolean copyTagsToVolumes) {
            this.copyTagsToVolumes = copyTagsToVolumes;
            return this;
        }

        public final String getDailyAutomaticBackupStartTime() {
            return dailyAutomaticBackupStartTime;
        }

        public final void setDailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
        }

        @Override
        public final Builder dailyAutomaticBackupStartTime(String dailyAutomaticBackupStartTime) {
            this.dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime;
            return this;
        }

        public final Integer getThroughputCapacity() {
            return throughputCapacity;
        }

        public final void setThroughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
        }

        @Override
        public final Builder throughputCapacity(Integer throughputCapacity) {
            this.throughputCapacity = throughputCapacity;
            return this;
        }

        public final String getWeeklyMaintenanceStartTime() {
            return weeklyMaintenanceStartTime;
        }

        public final void setWeeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
        }

        @Override
        public final Builder weeklyMaintenanceStartTime(String weeklyMaintenanceStartTime) {
            this.weeklyMaintenanceStartTime = weeklyMaintenanceStartTime;
            return this;
        }

        public final DiskIopsConfiguration.Builder getDiskIopsConfiguration() {
            return diskIopsConfiguration != null ? diskIopsConfiguration.toBuilder() : null;
        }

        public final void setDiskIopsConfiguration(DiskIopsConfiguration.BuilderImpl diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration != null ? diskIopsConfiguration.build() : null;
        }

        @Override
        public final Builder diskIopsConfiguration(DiskIopsConfiguration diskIopsConfiguration) {
            this.diskIopsConfiguration = diskIopsConfiguration;
            return this;
        }

        public final Collection<String> getAddRouteTableIds() {
            if (addRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return addRouteTableIds;
        }

        public final void setAddRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = RouteTableIdsCopier.copy(addRouteTableIds);
        }

        @Override
        public final Builder addRouteTableIds(Collection<String> addRouteTableIds) {
            this.addRouteTableIds = RouteTableIdsCopier.copy(addRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addRouteTableIds(String... addRouteTableIds) {
            addRouteTableIds(Arrays.asList(addRouteTableIds));
            return this;
        }

        public final Collection<String> getRemoveRouteTableIds() {
            if (removeRouteTableIds instanceof SdkAutoConstructList) {
                return null;
            }
            return removeRouteTableIds;
        }

        public final void setRemoveRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = RouteTableIdsCopier.copy(removeRouteTableIds);
        }

        @Override
        public final Builder removeRouteTableIds(Collection<String> removeRouteTableIds) {
            this.removeRouteTableIds = RouteTableIdsCopier.copy(removeRouteTableIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeRouteTableIds(String... removeRouteTableIds) {
            removeRouteTableIds(Arrays.asList(removeRouteTableIds));
            return this;
        }

        @Override
        public UpdateFileSystemOpenZFSConfiguration build() {
            return new UpdateFileSystemOpenZFSConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
