/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.fsx.model.DataRepositoryAssociationIdsCopier;
import software.amazon.awssdk.services.fsx.model.FileCacheFailureDetails;
import software.amazon.awssdk.services.fsx.model.FileCacheLifecycle;
import software.amazon.awssdk.services.fsx.model.FileCacheLustreConfiguration;
import software.amazon.awssdk.services.fsx.model.FileCacheType;
import software.amazon.awssdk.services.fsx.model.NetworkInterfaceIdsCopier;
import software.amazon.awssdk.services.fsx.model.SubnetIdsCopier;
import software.amazon.awssdk.services.fsx.model.Tag;
import software.amazon.awssdk.services.fsx.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileCacheCreating
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileCacheCreating> {
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(FileCacheCreating.getter(FileCacheCreating::ownerId)).setter(FileCacheCreating.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(FileCacheCreating.getter(FileCacheCreating::creationTime)).setter(FileCacheCreating.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FILE_CACHE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCacheId").getter(FileCacheCreating.getter(FileCacheCreating::fileCacheId)).setter(FileCacheCreating.setter(Builder::fileCacheId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheId").build()}).build();
    private static final SdkField<String> FILE_CACHE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCacheType").getter(FileCacheCreating.getter(FileCacheCreating::fileCacheTypeAsString)).setter(FileCacheCreating.setter(Builder::fileCacheType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheType").build()}).build();
    private static final SdkField<String> FILE_CACHE_TYPE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FileCacheTypeVersion").getter(FileCacheCreating.getter(FileCacheCreating::fileCacheTypeVersion)).setter(FileCacheCreating.setter(Builder::fileCacheTypeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCacheTypeVersion").build()}).build();
    private static final SdkField<String> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Lifecycle").getter(FileCacheCreating.getter(FileCacheCreating::lifecycleAsString)).setter(FileCacheCreating.setter(Builder::lifecycle)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<FileCacheFailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDetails").getter(FileCacheCreating.getter(FileCacheCreating::failureDetails)).setter(FileCacheCreating.setter(Builder::failureDetails)).constructor(FileCacheFailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageCapacity").getter(FileCacheCreating.getter(FileCacheCreating::storageCapacity)).setter(FileCacheCreating.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageCapacity").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(FileCacheCreating.getter(FileCacheCreating::vpcId)).setter(FileCacheCreating.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(FileCacheCreating.getter(FileCacheCreating::subnetIds)).setter(FileCacheCreating.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NETWORK_INTERFACE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NetworkInterfaceIds").getter(FileCacheCreating.getter(FileCacheCreating::networkInterfaceIds)).setter(FileCacheCreating.setter(Builder::networkInterfaceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DNSName").getter(FileCacheCreating.getter(FileCacheCreating::dnsName)).setter(FileCacheCreating.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DNSName").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(FileCacheCreating.getter(FileCacheCreating::kmsKeyId)).setter(FileCacheCreating.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceARN").getter(FileCacheCreating.getter(FileCacheCreating::resourceARN)).setter(FileCacheCreating.setter(Builder::resourceARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceARN").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(FileCacheCreating.getter(FileCacheCreating::tags)).setter(FileCacheCreating.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_DATA_REPOSITORY_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToDataRepositoryAssociations").getter(FileCacheCreating.getter(FileCacheCreating::copyTagsToDataRepositoryAssociations)).setter(FileCacheCreating.setter(Builder::copyTagsToDataRepositoryAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToDataRepositoryAssociations").build()}).build();
    private static final SdkField<FileCacheLustreConfiguration> LUSTRE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LustreConfiguration").getter(FileCacheCreating.getter(FileCacheCreating::lustreConfiguration)).setter(FileCacheCreating.setter(Builder::lustreConfiguration)).constructor(FileCacheLustreConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LustreConfiguration").build()}).build();
    private static final SdkField<List<String>> DATA_REPOSITORY_ASSOCIATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataRepositoryAssociationIds").getter(FileCacheCreating.getter(FileCacheCreating::dataRepositoryAssociationIds)).setter(FileCacheCreating.setter(Builder::dataRepositoryAssociationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRepositoryAssociationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ID_FIELD, CREATION_TIME_FIELD, FILE_CACHE_ID_FIELD, FILE_CACHE_TYPE_FIELD, FILE_CACHE_TYPE_VERSION_FIELD, LIFECYCLE_FIELD, FAILURE_DETAILS_FIELD, STORAGE_CAPACITY_FIELD, VPC_ID_FIELD, SUBNET_IDS_FIELD, NETWORK_INTERFACE_IDS_FIELD, DNS_NAME_FIELD, KMS_KEY_ID_FIELD, RESOURCE_ARN_FIELD, TAGS_FIELD, COPY_TAGS_TO_DATA_REPOSITORY_ASSOCIATIONS_FIELD, LUSTRE_CONFIGURATION_FIELD, DATA_REPOSITORY_ASSOCIATION_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ownerId;
    private final Instant creationTime;
    private final String fileCacheId;
    private final String fileCacheType;
    private final String fileCacheTypeVersion;
    private final String lifecycle;
    private final FileCacheFailureDetails failureDetails;
    private final Integer storageCapacity;
    private final String vpcId;
    private final List<String> subnetIds;
    private final List<String> networkInterfaceIds;
    private final String dnsName;
    private final String kmsKeyId;
    private final String resourceARN;
    private final List<Tag> tags;
    private final Boolean copyTagsToDataRepositoryAssociations;
    private final FileCacheLustreConfiguration lustreConfiguration;
    private final List<String> dataRepositoryAssociationIds;

    private FileCacheCreating(BuilderImpl builder) {
        this.ownerId = builder.ownerId;
        this.creationTime = builder.creationTime;
        this.fileCacheId = builder.fileCacheId;
        this.fileCacheType = builder.fileCacheType;
        this.fileCacheTypeVersion = builder.fileCacheTypeVersion;
        this.lifecycle = builder.lifecycle;
        this.failureDetails = builder.failureDetails;
        this.storageCapacity = builder.storageCapacity;
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.networkInterfaceIds = builder.networkInterfaceIds;
        this.dnsName = builder.dnsName;
        this.kmsKeyId = builder.kmsKeyId;
        this.resourceARN = builder.resourceARN;
        this.tags = builder.tags;
        this.copyTagsToDataRepositoryAssociations = builder.copyTagsToDataRepositoryAssociations;
        this.lustreConfiguration = builder.lustreConfiguration;
        this.dataRepositoryAssociationIds = builder.dataRepositoryAssociationIds;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String fileCacheId() {
        return this.fileCacheId;
    }

    public final FileCacheType fileCacheType() {
        return FileCacheType.fromValue(this.fileCacheType);
    }

    public final String fileCacheTypeAsString() {
        return this.fileCacheType;
    }

    public final String fileCacheTypeVersion() {
        return this.fileCacheTypeVersion;
    }

    public final FileCacheLifecycle lifecycle() {
        return FileCacheLifecycle.fromValue(this.lifecycle);
    }

    public final String lifecycleAsString() {
        return this.lifecycle;
    }

    public final FileCacheFailureDetails failureDetails() {
        return this.failureDetails;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasNetworkInterfaceIds() {
        return this.networkInterfaceIds != null && !(this.networkInterfaceIds instanceof SdkAutoConstructList);
    }

    public final List<String> networkInterfaceIds() {
        return this.networkInterfaceIds;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String resourceARN() {
        return this.resourceARN;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean copyTagsToDataRepositoryAssociations() {
        return this.copyTagsToDataRepositoryAssociations;
    }

    public final FileCacheLustreConfiguration lustreConfiguration() {
        return this.lustreConfiguration;
    }

    public final boolean hasDataRepositoryAssociationIds() {
        return this.dataRepositoryAssociationIds != null && !(this.dataRepositoryAssociationIds instanceof SdkAutoConstructList);
    }

    public final List<String> dataRepositoryAssociationIds() {
        return this.dataRepositoryAssociationIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCacheId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCacheTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileCacheTypeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNetworkInterfaceIds() ? this.networkInterfaceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToDataRepositoryAssociations());
        hashCode = 31 * hashCode + Objects.hashCode(this.lustreConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataRepositoryAssociationIds() ? this.dataRepositoryAssociationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileCacheCreating)) {
            return false;
        }
        FileCacheCreating other = (FileCacheCreating)obj;
        return Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.fileCacheId(), other.fileCacheId()) && Objects.equals(this.fileCacheTypeAsString(), other.fileCacheTypeAsString()) && Objects.equals(this.fileCacheTypeVersion(), other.fileCacheTypeVersion()) && Objects.equals(this.lifecycleAsString(), other.lifecycleAsString()) && Objects.equals(this.failureDetails(), other.failureDetails()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasNetworkInterfaceIds() == other.hasNetworkInterfaceIds() && Objects.equals(this.networkInterfaceIds(), other.networkInterfaceIds()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.resourceARN(), other.resourceARN()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.copyTagsToDataRepositoryAssociations(), other.copyTagsToDataRepositoryAssociations()) && Objects.equals(this.lustreConfiguration(), other.lustreConfiguration()) && this.hasDataRepositoryAssociationIds() == other.hasDataRepositoryAssociationIds() && Objects.equals(this.dataRepositoryAssociationIds(), other.dataRepositoryAssociationIds());
    }

    public final String toString() {
        return ToString.builder((String)"FileCacheCreating").add("OwnerId", (Object)this.ownerId()).add("CreationTime", (Object)this.creationTime()).add("FileCacheId", (Object)this.fileCacheId()).add("FileCacheType", (Object)this.fileCacheTypeAsString()).add("FileCacheTypeVersion", (Object)this.fileCacheTypeVersion()).add("Lifecycle", (Object)this.lifecycleAsString()).add("FailureDetails", (Object)this.failureDetails()).add("StorageCapacity", (Object)this.storageCapacity()).add("VpcId", (Object)this.vpcId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("NetworkInterfaceIds", this.hasNetworkInterfaceIds() ? this.networkInterfaceIds() : null).add("DNSName", (Object)this.dnsName()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ResourceARN", (Object)this.resourceARN()).add("Tags", this.hasTags() ? this.tags() : null).add("CopyTagsToDataRepositoryAssociations", (Object)this.copyTagsToDataRepositoryAssociations()).add("LustreConfiguration", (Object)this.lustreConfiguration()).add("DataRepositoryAssociationIds", this.hasDataRepositoryAssociationIds() ? this.dataRepositoryAssociationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FileCacheId": {
                return Optional.ofNullable(clazz.cast(this.fileCacheId()));
            }
            case "FileCacheType": {
                return Optional.ofNullable(clazz.cast(this.fileCacheTypeAsString()));
            }
            case "FileCacheTypeVersion": {
                return Optional.ofNullable(clazz.cast(this.fileCacheTypeVersion()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycleAsString()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
            case "StorageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "NetworkInterfaceIds": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceIds()));
            }
            case "DNSName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ResourceARN": {
                return Optional.ofNullable(clazz.cast(this.resourceARN()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "CopyTagsToDataRepositoryAssociations": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToDataRepositoryAssociations()));
            }
            case "LustreConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lustreConfiguration()));
            }
            case "DataRepositoryAssociationIds": {
                return Optional.ofNullable(clazz.cast(this.dataRepositoryAssociationIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FileCacheCreating, T> g) {
        return obj -> g.apply((FileCacheCreating)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ownerId;
        private Instant creationTime;
        private String fileCacheId;
        private String fileCacheType;
        private String fileCacheTypeVersion;
        private String lifecycle;
        private FileCacheFailureDetails failureDetails;
        private Integer storageCapacity;
        private String vpcId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> networkInterfaceIds = DefaultSdkAutoConstructList.getInstance();
        private String dnsName;
        private String kmsKeyId;
        private String resourceARN;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean copyTagsToDataRepositoryAssociations;
        private FileCacheLustreConfiguration lustreConfiguration;
        private List<String> dataRepositoryAssociationIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FileCacheCreating model) {
            this.ownerId(model.ownerId);
            this.creationTime(model.creationTime);
            this.fileCacheId(model.fileCacheId);
            this.fileCacheType(model.fileCacheType);
            this.fileCacheTypeVersion(model.fileCacheTypeVersion);
            this.lifecycle(model.lifecycle);
            this.failureDetails(model.failureDetails);
            this.storageCapacity(model.storageCapacity);
            this.vpcId(model.vpcId);
            this.subnetIds(model.subnetIds);
            this.networkInterfaceIds(model.networkInterfaceIds);
            this.dnsName(model.dnsName);
            this.kmsKeyId(model.kmsKeyId);
            this.resourceARN(model.resourceARN);
            this.tags(model.tags);
            this.copyTagsToDataRepositoryAssociations(model.copyTagsToDataRepositoryAssociations);
            this.lustreConfiguration(model.lustreConfiguration);
            this.dataRepositoryAssociationIds(model.dataRepositoryAssociationIds);
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFileCacheId() {
            return this.fileCacheId;
        }

        public final void setFileCacheId(String fileCacheId) {
            this.fileCacheId = fileCacheId;
        }

        @Override
        public final Builder fileCacheId(String fileCacheId) {
            this.fileCacheId = fileCacheId;
            return this;
        }

        public final String getFileCacheType() {
            return this.fileCacheType;
        }

        public final void setFileCacheType(String fileCacheType) {
            this.fileCacheType = fileCacheType;
        }

        @Override
        public final Builder fileCacheType(String fileCacheType) {
            this.fileCacheType = fileCacheType;
            return this;
        }

        @Override
        public final Builder fileCacheType(FileCacheType fileCacheType) {
            this.fileCacheType(fileCacheType == null ? null : fileCacheType.toString());
            return this;
        }

        public final String getFileCacheTypeVersion() {
            return this.fileCacheTypeVersion;
        }

        public final void setFileCacheTypeVersion(String fileCacheTypeVersion) {
            this.fileCacheTypeVersion = fileCacheTypeVersion;
        }

        @Override
        public final Builder fileCacheTypeVersion(String fileCacheTypeVersion) {
            this.fileCacheTypeVersion = fileCacheTypeVersion;
            return this;
        }

        public final String getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
        }

        @Override
        public final Builder lifecycle(String lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        @Override
        public final Builder lifecycle(FileCacheLifecycle lifecycle) {
            this.lifecycle(lifecycle == null ? null : lifecycle.toString());
            return this;
        }

        public final FileCacheFailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(FileCacheFailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        public final Builder failureDetails(FileCacheFailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getNetworkInterfaceIds() {
            if (this.networkInterfaceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.networkInterfaceIds;
        }

        public final void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdsCopier.copy(networkInterfaceIds);
        }

        @Override
        public final Builder networkInterfaceIds(Collection<String> networkInterfaceIds) {
            this.networkInterfaceIds = NetworkInterfaceIdsCopier.copy(networkInterfaceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder networkInterfaceIds(String ... networkInterfaceIds) {
            this.networkInterfaceIds(Arrays.asList(networkInterfaceIds));
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getResourceARN() {
            return this.resourceARN;
        }

        public final void setResourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
        }

        @Override
        public final Builder resourceARN(String resourceARN) {
            this.resourceARN = resourceARN;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCopyTagsToDataRepositoryAssociations() {
            return this.copyTagsToDataRepositoryAssociations;
        }

        public final void setCopyTagsToDataRepositoryAssociations(Boolean copyTagsToDataRepositoryAssociations) {
            this.copyTagsToDataRepositoryAssociations = copyTagsToDataRepositoryAssociations;
        }

        @Override
        public final Builder copyTagsToDataRepositoryAssociations(Boolean copyTagsToDataRepositoryAssociations) {
            this.copyTagsToDataRepositoryAssociations = copyTagsToDataRepositoryAssociations;
            return this;
        }

        public final FileCacheLustreConfiguration.Builder getLustreConfiguration() {
            return this.lustreConfiguration != null ? this.lustreConfiguration.toBuilder() : null;
        }

        public final void setLustreConfiguration(FileCacheLustreConfiguration.BuilderImpl lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration != null ? lustreConfiguration.build() : null;
        }

        @Override
        public final Builder lustreConfiguration(FileCacheLustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public final Collection<String> getDataRepositoryAssociationIds() {
            if (this.dataRepositoryAssociationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataRepositoryAssociationIds;
        }

        public final void setDataRepositoryAssociationIds(Collection<String> dataRepositoryAssociationIds) {
            this.dataRepositoryAssociationIds = DataRepositoryAssociationIdsCopier.copy(dataRepositoryAssociationIds);
        }

        @Override
        public final Builder dataRepositoryAssociationIds(Collection<String> dataRepositoryAssociationIds) {
            this.dataRepositoryAssociationIds = DataRepositoryAssociationIdsCopier.copy(dataRepositoryAssociationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataRepositoryAssociationIds(String ... dataRepositoryAssociationIds) {
            this.dataRepositoryAssociationIds(Arrays.asList(dataRepositoryAssociationIds));
            return this;
        }

        public FileCacheCreating build() {
            return new FileCacheCreating(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileCacheCreating> {
        public Builder ownerId(String var1);

        public Builder creationTime(Instant var1);

        public Builder fileCacheId(String var1);

        public Builder fileCacheType(String var1);

        public Builder fileCacheType(FileCacheType var1);

        public Builder fileCacheTypeVersion(String var1);

        public Builder lifecycle(String var1);

        public Builder lifecycle(FileCacheLifecycle var1);

        public Builder failureDetails(FileCacheFailureDetails var1);

        default public Builder failureDetails(Consumer<FileCacheFailureDetails.Builder> failureDetails) {
            return this.failureDetails((FileCacheFailureDetails)((FileCacheFailureDetails.Builder)FileCacheFailureDetails.builder().applyMutation(failureDetails)).build());
        }

        public Builder storageCapacity(Integer var1);

        public Builder vpcId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder networkInterfaceIds(Collection<String> var1);

        public Builder networkInterfaceIds(String ... var1);

        public Builder dnsName(String var1);

        public Builder kmsKeyId(String var1);

        public Builder resourceARN(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder copyTagsToDataRepositoryAssociations(Boolean var1);

        public Builder lustreConfiguration(FileCacheLustreConfiguration var1);

        default public Builder lustreConfiguration(Consumer<FileCacheLustreConfiguration.Builder> lustreConfiguration) {
            return this.lustreConfiguration((FileCacheLustreConfiguration)((FileCacheLustreConfiguration.Builder)FileCacheLustreConfiguration.builder().applyMutation(lustreConfiguration)).build());
        }

        public Builder dataRepositoryAssociationIds(Collection<String> var1);

        public Builder dataRepositoryAssociationIds(String ... var1);
    }
}

