/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.fsx.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.fsx.model.OntapFileSystemUserType;
import software.amazon.awssdk.services.fsx.model.OntapUnixFileSystemUser;
import software.amazon.awssdk.services.fsx.model.OntapWindowsFileSystemUser;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OntapFileSystemIdentity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OntapFileSystemIdentity> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(OntapFileSystemIdentity.getter(OntapFileSystemIdentity::typeAsString)).setter(OntapFileSystemIdentity.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<OntapUnixFileSystemUser> UNIX_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UnixUser").getter(OntapFileSystemIdentity.getter(OntapFileSystemIdentity::unixUser)).setter(OntapFileSystemIdentity.setter(Builder::unixUser)).constructor(OntapUnixFileSystemUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnixUser").build()}).build();
    private static final SdkField<OntapWindowsFileSystemUser> WINDOWS_USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WindowsUser").getter(OntapFileSystemIdentity.getter(OntapFileSystemIdentity::windowsUser)).setter(OntapFileSystemIdentity.setter(Builder::windowsUser)).constructor(OntapWindowsFileSystemUser::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowsUser").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, UNIX_USER_FIELD, WINDOWS_USER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OntapFileSystemIdentity.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final OntapUnixFileSystemUser unixUser;
    private final OntapWindowsFileSystemUser windowsUser;

    private OntapFileSystemIdentity(BuilderImpl builder) {
        this.type = builder.type;
        this.unixUser = builder.unixUser;
        this.windowsUser = builder.windowsUser;
    }

    public final OntapFileSystemUserType type() {
        return OntapFileSystemUserType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final OntapUnixFileSystemUser unixUser() {
        return this.unixUser;
    }

    public final OntapWindowsFileSystemUser windowsUser() {
        return this.windowsUser;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unixUser());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowsUser());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OntapFileSystemIdentity)) {
            return false;
        }
        OntapFileSystemIdentity other = (OntapFileSystemIdentity)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.unixUser(), other.unixUser()) && Objects.equals(this.windowsUser(), other.windowsUser());
    }

    public final String toString() {
        return ToString.builder((String)"OntapFileSystemIdentity").add("Type", (Object)this.typeAsString()).add("UnixUser", (Object)this.unixUser()).add("WindowsUser", (Object)this.windowsUser()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "UnixUser": {
                return Optional.ofNullable(clazz.cast(this.unixUser()));
            }
            case "WindowsUser": {
                return Optional.ofNullable(clazz.cast(this.windowsUser()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("UnixUser", UNIX_USER_FIELD);
        map.put("WindowsUser", WINDOWS_USER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OntapFileSystemIdentity, T> g) {
        return obj -> g.apply((OntapFileSystemIdentity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private OntapUnixFileSystemUser unixUser;
        private OntapWindowsFileSystemUser windowsUser;

        private BuilderImpl() {
        }

        private BuilderImpl(OntapFileSystemIdentity model) {
            this.type(model.type);
            this.unixUser(model.unixUser);
            this.windowsUser(model.windowsUser);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(OntapFileSystemUserType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final OntapUnixFileSystemUser.Builder getUnixUser() {
            return this.unixUser != null ? this.unixUser.toBuilder() : null;
        }

        public final void setUnixUser(OntapUnixFileSystemUser.BuilderImpl unixUser) {
            this.unixUser = unixUser != null ? unixUser.build() : null;
        }

        @Override
        public final Builder unixUser(OntapUnixFileSystemUser unixUser) {
            this.unixUser = unixUser;
            return this;
        }

        public final OntapWindowsFileSystemUser.Builder getWindowsUser() {
            return this.windowsUser != null ? this.windowsUser.toBuilder() : null;
        }

        public final void setWindowsUser(OntapWindowsFileSystemUser.BuilderImpl windowsUser) {
            this.windowsUser = windowsUser != null ? windowsUser.build() : null;
        }

        @Override
        public final Builder windowsUser(OntapWindowsFileSystemUser windowsUser) {
            this.windowsUser = windowsUser;
            return this;
        }

        public OntapFileSystemIdentity build() {
            return new OntapFileSystemIdentity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OntapFileSystemIdentity> {
        public Builder type(String var1);

        public Builder type(OntapFileSystemUserType var1);

        public Builder unixUser(OntapUnixFileSystemUser var1);

        default public Builder unixUser(Consumer<OntapUnixFileSystemUser.Builder> unixUser) {
            return this.unixUser((OntapUnixFileSystemUser)((OntapUnixFileSystemUser.Builder)OntapUnixFileSystemUser.builder().applyMutation(unixUser)).build());
        }

        public Builder windowsUser(OntapWindowsFileSystemUser var1);

        default public Builder windowsUser(Consumer<OntapWindowsFileSystemUser.Builder> windowsUser) {
            return this.windowsUser((OntapWindowsFileSystemUser)((OntapWindowsFileSystemUser.Builder)OntapWindowsFileSystemUser.builder().applyMutation(windowsUser)).build());
        }
    }
}

