/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamelift.GameLiftClient;
import software.amazon.awssdk.services.gamelift.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsRequest;
import software.amazon.awssdk.services.gamelift.model.DescribeFleetEventsResponse;
import software.amazon.awssdk.services.gamelift.model.Event;

public class DescribeFleetEventsIterable
implements SdkIterable<DescribeFleetEventsResponse> {
    private final GameLiftClient client;
    private final DescribeFleetEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFleetEventsIterable(GameLiftClient client, DescribeFleetEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeFleetEventsResponseFetcher();
    }

    public Iterator<DescribeFleetEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Event> events() {
        Function<DescribeFleetEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFleetEventsResponseFetcher
    implements SyncPageFetcher<DescribeFleetEventsResponse> {
        private DescribeFleetEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFleetEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFleetEventsResponse nextPage(DescribeFleetEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeFleetEventsIterable.this.client.describeFleetEvents(DescribeFleetEventsIterable.this.firstRequest);
            }
            return DescribeFleetEventsIterable.this.client.describeFleetEvents((DescribeFleetEventsRequest)((Object)DescribeFleetEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

