/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerIdentifier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerIdentifier> {
    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerName").getter(ContainerIdentifier.getter(ContainerIdentifier::containerName)).setter(ContainerIdentifier.setter(Builder::containerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()}).build();
    private static final SdkField<String> CONTAINER_RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerRuntimeId").getter(ContainerIdentifier.getter(ContainerIdentifier::containerRuntimeId)).setter(ContainerIdentifier.setter(Builder::containerRuntimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerRuntimeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_NAME_FIELD, CONTAINER_RUNTIME_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContainerIdentifier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String containerName;
    private final String containerRuntimeId;

    private ContainerIdentifier(BuilderImpl builder) {
        this.containerName = builder.containerName;
        this.containerRuntimeId = builder.containerRuntimeId;
    }

    public final String containerName() {
        return this.containerName;
    }

    public final String containerRuntimeId() {
        return this.containerRuntimeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRuntimeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerIdentifier)) {
            return false;
        }
        ContainerIdentifier other = (ContainerIdentifier)obj;
        return Objects.equals(this.containerName(), other.containerName()) && Objects.equals(this.containerRuntimeId(), other.containerRuntimeId());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerIdentifier").add("ContainerName", (Object)this.containerName()).add("ContainerRuntimeId", (Object)this.containerRuntimeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerName": {
                return Optional.ofNullable(clazz.cast(this.containerName()));
            }
            case "ContainerRuntimeId": {
                return Optional.ofNullable(clazz.cast(this.containerRuntimeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ContainerName", CONTAINER_NAME_FIELD);
        map.put("ContainerRuntimeId", CONTAINER_RUNTIME_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerIdentifier, T> g) {
        return obj -> g.apply((ContainerIdentifier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String containerName;
        private String containerRuntimeId;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerIdentifier model) {
            this.containerName(model.containerName);
            this.containerRuntimeId(model.containerRuntimeId);
        }

        public final String getContainerName() {
            return this.containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        public final String getContainerRuntimeId() {
            return this.containerRuntimeId;
        }

        public final void setContainerRuntimeId(String containerRuntimeId) {
            this.containerRuntimeId = containerRuntimeId;
        }

        @Override
        public final Builder containerRuntimeId(String containerRuntimeId) {
            this.containerRuntimeId = containerRuntimeId;
            return this;
        }

        public ContainerIdentifier build() {
            return new ContainerIdentifier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerIdentifier> {
        public Builder containerName(String var1);

        public Builder containerRuntimeId(String var1);
    }
}

