/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.gamelift.model.AnywhereConfiguration;
import software.amazon.awssdk.services.gamelift.model.CertificateConfiguration;
import software.amazon.awssdk.services.gamelift.model.ComputeType;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.services.gamelift.model.FleetType;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.services.gamelift.model.InstanceRoleCredentialsProvider;
import software.amazon.awssdk.services.gamelift.model.IpPermission;
import software.amazon.awssdk.services.gamelift.model.IpPermissionsListCopier;
import software.amazon.awssdk.services.gamelift.model.LocationConfiguration;
import software.amazon.awssdk.services.gamelift.model.LocationConfigurationListCopier;
import software.amazon.awssdk.services.gamelift.model.MetricGroupListCopier;
import software.amazon.awssdk.services.gamelift.model.ProtectionPolicy;
import software.amazon.awssdk.services.gamelift.model.ResourceCreationLimitPolicy;
import software.amazon.awssdk.services.gamelift.model.RuntimeConfiguration;
import software.amazon.awssdk.services.gamelift.model.StringListCopier;
import software.amazon.awssdk.services.gamelift.model.Tag;
import software.amazon.awssdk.services.gamelift.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFleetRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, CreateFleetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateFleetRequest.getter(CreateFleetRequest::name)).setter(CreateFleetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateFleetRequest.getter(CreateFleetRequest::description)).setter(CreateFleetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> BUILD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BuildId").getter(CreateFleetRequest.getter(CreateFleetRequest::buildId)).setter(CreateFleetRequest.setter(Builder::buildId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BuildId").build()}).build();
    private static final SdkField<String> SCRIPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScriptId").getter(CreateFleetRequest.getter(CreateFleetRequest::scriptId)).setter(CreateFleetRequest.setter(Builder::scriptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScriptId").build()}).build();
    private static final SdkField<String> SERVER_LAUNCH_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerLaunchPath").getter(CreateFleetRequest.getter(CreateFleetRequest::serverLaunchPath)).setter(CreateFleetRequest.setter(Builder::serverLaunchPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchPath").build()}).build();
    private static final SdkField<String> SERVER_LAUNCH_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerLaunchParameters").getter(CreateFleetRequest.getter(CreateFleetRequest::serverLaunchParameters)).setter(CreateFleetRequest.setter(Builder::serverLaunchParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerLaunchParameters").build()}).build();
    private static final SdkField<List<String>> LOG_PATHS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogPaths").getter(CreateFleetRequest.getter(CreateFleetRequest::logPaths)).setter(CreateFleetRequest.setter(Builder::logPaths)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPaths").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EC2InstanceType").getter(CreateFleetRequest.getter(CreateFleetRequest::ec2InstanceTypeAsString)).setter(CreateFleetRequest.setter(Builder::ec2InstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceType").build()}).build();
    private static final SdkField<List<IpPermission>> EC2_INBOUND_PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EC2InboundPermissions").getter(CreateFleetRequest.getter(CreateFleetRequest::ec2InboundPermissions)).setter(CreateFleetRequest.setter(Builder::ec2InboundPermissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InboundPermissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpPermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEW_GAME_SESSION_PROTECTION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NewGameSessionProtectionPolicy").getter(CreateFleetRequest.getter(CreateFleetRequest::newGameSessionProtectionPolicyAsString)).setter(CreateFleetRequest.setter(Builder::newGameSessionProtectionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewGameSessionProtectionPolicy").build()}).build();
    private static final SdkField<RuntimeConfiguration> RUNTIME_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RuntimeConfiguration").getter(CreateFleetRequest.getter(CreateFleetRequest::runtimeConfiguration)).setter(CreateFleetRequest.setter(Builder::runtimeConfiguration)).constructor(RuntimeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuntimeConfiguration").build()}).build();
    private static final SdkField<ResourceCreationLimitPolicy> RESOURCE_CREATION_LIMIT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceCreationLimitPolicy").getter(CreateFleetRequest.getter(CreateFleetRequest::resourceCreationLimitPolicy)).setter(CreateFleetRequest.setter(Builder::resourceCreationLimitPolicy)).constructor(ResourceCreationLimitPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceCreationLimitPolicy").build()}).build();
    private static final SdkField<List<String>> METRIC_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricGroups").getter(CreateFleetRequest.getter(CreateFleetRequest::metricGroups)).setter(CreateFleetRequest.setter(Builder::metricGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PEER_VPC_AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerVpcAwsAccountId").getter(CreateFleetRequest.getter(CreateFleetRequest::peerVpcAwsAccountId)).setter(CreateFleetRequest.setter(Builder::peerVpcAwsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcAwsAccountId").build()}).build();
    private static final SdkField<String> PEER_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeerVpcId").getter(CreateFleetRequest.getter(CreateFleetRequest::peerVpcId)).setter(CreateFleetRequest.setter(Builder::peerVpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerVpcId").build()}).build();
    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetType").getter(CreateFleetRequest.getter(CreateFleetRequest::fleetTypeAsString)).setter(CreateFleetRequest.setter(Builder::fleetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceRoleArn").getter(CreateFleetRequest.getter(CreateFleetRequest::instanceRoleArn)).setter(CreateFleetRequest.setter(Builder::instanceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRoleArn").build()}).build();
    private static final SdkField<CertificateConfiguration> CERTIFICATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CertificateConfiguration").getter(CreateFleetRequest.getter(CreateFleetRequest::certificateConfiguration)).setter(CreateFleetRequest.setter(Builder::certificateConfiguration)).constructor(CertificateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateConfiguration").build()}).build();
    private static final SdkField<List<LocationConfiguration>> LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Locations").getter(CreateFleetRequest.getter(CreateFleetRequest::locations)).setter(CreateFleetRequest.setter(Builder::locations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LocationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateFleetRequest.getter(CreateFleetRequest::tags)).setter(CreateFleetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMPUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeType").getter(CreateFleetRequest.getter(CreateFleetRequest::computeTypeAsString)).setter(CreateFleetRequest.setter(Builder::computeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeType").build()}).build();
    private static final SdkField<AnywhereConfiguration> ANYWHERE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AnywhereConfiguration").getter(CreateFleetRequest.getter(CreateFleetRequest::anywhereConfiguration)).setter(CreateFleetRequest.setter(Builder::anywhereConfiguration)).constructor(AnywhereConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnywhereConfiguration").build()}).build();
    private static final SdkField<String> INSTANCE_ROLE_CREDENTIALS_PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceRoleCredentialsProvider").getter(CreateFleetRequest.getter(CreateFleetRequest::instanceRoleCredentialsProviderAsString)).setter(CreateFleetRequest.setter(Builder::instanceRoleCredentialsProvider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRoleCredentialsProvider").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, BUILD_ID_FIELD, SCRIPT_ID_FIELD, SERVER_LAUNCH_PATH_FIELD, SERVER_LAUNCH_PARAMETERS_FIELD, LOG_PATHS_FIELD, EC2_INSTANCE_TYPE_FIELD, EC2_INBOUND_PERMISSIONS_FIELD, NEW_GAME_SESSION_PROTECTION_POLICY_FIELD, RUNTIME_CONFIGURATION_FIELD, RESOURCE_CREATION_LIMIT_POLICY_FIELD, METRIC_GROUPS_FIELD, PEER_VPC_AWS_ACCOUNT_ID_FIELD, PEER_VPC_ID_FIELD, FLEET_TYPE_FIELD, INSTANCE_ROLE_ARN_FIELD, CERTIFICATE_CONFIGURATION_FIELD, LOCATIONS_FIELD, TAGS_FIELD, COMPUTE_TYPE_FIELD, ANYWHERE_CONFIGURATION_FIELD, INSTANCE_ROLE_CREDENTIALS_PROVIDER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFleetRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String buildId;
    private final String scriptId;
    private final String serverLaunchPath;
    private final String serverLaunchParameters;
    private final List<String> logPaths;
    private final String ec2InstanceType;
    private final List<IpPermission> ec2InboundPermissions;
    private final String newGameSessionProtectionPolicy;
    private final RuntimeConfiguration runtimeConfiguration;
    private final ResourceCreationLimitPolicy resourceCreationLimitPolicy;
    private final List<String> metricGroups;
    private final String peerVpcAwsAccountId;
    private final String peerVpcId;
    private final String fleetType;
    private final String instanceRoleArn;
    private final CertificateConfiguration certificateConfiguration;
    private final List<LocationConfiguration> locations;
    private final List<Tag> tags;
    private final String computeType;
    private final AnywhereConfiguration anywhereConfiguration;
    private final String instanceRoleCredentialsProvider;

    private CreateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.buildId = builder.buildId;
        this.scriptId = builder.scriptId;
        this.serverLaunchPath = builder.serverLaunchPath;
        this.serverLaunchParameters = builder.serverLaunchParameters;
        this.logPaths = builder.logPaths;
        this.ec2InstanceType = builder.ec2InstanceType;
        this.ec2InboundPermissions = builder.ec2InboundPermissions;
        this.newGameSessionProtectionPolicy = builder.newGameSessionProtectionPolicy;
        this.runtimeConfiguration = builder.runtimeConfiguration;
        this.resourceCreationLimitPolicy = builder.resourceCreationLimitPolicy;
        this.metricGroups = builder.metricGroups;
        this.peerVpcAwsAccountId = builder.peerVpcAwsAccountId;
        this.peerVpcId = builder.peerVpcId;
        this.fleetType = builder.fleetType;
        this.instanceRoleArn = builder.instanceRoleArn;
        this.certificateConfiguration = builder.certificateConfiguration;
        this.locations = builder.locations;
        this.tags = builder.tags;
        this.computeType = builder.computeType;
        this.anywhereConfiguration = builder.anywhereConfiguration;
        this.instanceRoleCredentialsProvider = builder.instanceRoleCredentialsProvider;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String buildId() {
        return this.buildId;
    }

    public final String scriptId() {
        return this.scriptId;
    }

    public final String serverLaunchPath() {
        return this.serverLaunchPath;
    }

    public final String serverLaunchParameters() {
        return this.serverLaunchParameters;
    }

    public final boolean hasLogPaths() {
        return this.logPaths != null && !(this.logPaths instanceof SdkAutoConstructList);
    }

    public final List<String> logPaths() {
        return this.logPaths;
    }

    public final EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(this.ec2InstanceType);
    }

    public final String ec2InstanceTypeAsString() {
        return this.ec2InstanceType;
    }

    public final boolean hasEc2InboundPermissions() {
        return this.ec2InboundPermissions != null && !(this.ec2InboundPermissions instanceof SdkAutoConstructList);
    }

    public final List<IpPermission> ec2InboundPermissions() {
        return this.ec2InboundPermissions;
    }

    public final ProtectionPolicy newGameSessionProtectionPolicy() {
        return ProtectionPolicy.fromValue(this.newGameSessionProtectionPolicy);
    }

    public final String newGameSessionProtectionPolicyAsString() {
        return this.newGameSessionProtectionPolicy;
    }

    public final RuntimeConfiguration runtimeConfiguration() {
        return this.runtimeConfiguration;
    }

    public final ResourceCreationLimitPolicy resourceCreationLimitPolicy() {
        return this.resourceCreationLimitPolicy;
    }

    public final boolean hasMetricGroups() {
        return this.metricGroups != null && !(this.metricGroups instanceof SdkAutoConstructList);
    }

    public final List<String> metricGroups() {
        return this.metricGroups;
    }

    public final String peerVpcAwsAccountId() {
        return this.peerVpcAwsAccountId;
    }

    public final String peerVpcId() {
        return this.peerVpcId;
    }

    public final FleetType fleetType() {
        return FleetType.fromValue(this.fleetType);
    }

    public final String fleetTypeAsString() {
        return this.fleetType;
    }

    public final String instanceRoleArn() {
        return this.instanceRoleArn;
    }

    public final CertificateConfiguration certificateConfiguration() {
        return this.certificateConfiguration;
    }

    public final boolean hasLocations() {
        return this.locations != null && !(this.locations instanceof SdkAutoConstructList);
    }

    public final List<LocationConfiguration> locations() {
        return this.locations;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final ComputeType computeType() {
        return ComputeType.fromValue(this.computeType);
    }

    public final String computeTypeAsString() {
        return this.computeType;
    }

    public final AnywhereConfiguration anywhereConfiguration() {
        return this.anywhereConfiguration;
    }

    public final InstanceRoleCredentialsProvider instanceRoleCredentialsProvider() {
        return InstanceRoleCredentialsProvider.fromValue(this.instanceRoleCredentialsProvider);
    }

    public final String instanceRoleCredentialsProviderAsString() {
        return this.instanceRoleCredentialsProvider;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scriptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverLaunchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogPaths() ? this.logPaths() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2InboundPermissions() ? this.ec2InboundPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.newGameSessionProtectionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceCreationLimitPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricGroups() ? this.metricGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcAwsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerVpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocations() ? this.locations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.computeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.anywhereConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRoleCredentialsProviderAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.buildId(), other.buildId()) && Objects.equals(this.scriptId(), other.scriptId()) && Objects.equals(this.serverLaunchPath(), other.serverLaunchPath()) && Objects.equals(this.serverLaunchParameters(), other.serverLaunchParameters()) && this.hasLogPaths() == other.hasLogPaths() && Objects.equals(this.logPaths(), other.logPaths()) && Objects.equals(this.ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString()) && this.hasEc2InboundPermissions() == other.hasEc2InboundPermissions() && Objects.equals(this.ec2InboundPermissions(), other.ec2InboundPermissions()) && Objects.equals(this.newGameSessionProtectionPolicyAsString(), other.newGameSessionProtectionPolicyAsString()) && Objects.equals(this.runtimeConfiguration(), other.runtimeConfiguration()) && Objects.equals(this.resourceCreationLimitPolicy(), other.resourceCreationLimitPolicy()) && this.hasMetricGroups() == other.hasMetricGroups() && Objects.equals(this.metricGroups(), other.metricGroups()) && Objects.equals(this.peerVpcAwsAccountId(), other.peerVpcAwsAccountId()) && Objects.equals(this.peerVpcId(), other.peerVpcId()) && Objects.equals(this.fleetTypeAsString(), other.fleetTypeAsString()) && Objects.equals(this.instanceRoleArn(), other.instanceRoleArn()) && Objects.equals(this.certificateConfiguration(), other.certificateConfiguration()) && this.hasLocations() == other.hasLocations() && Objects.equals(this.locations(), other.locations()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.computeTypeAsString(), other.computeTypeAsString()) && Objects.equals(this.anywhereConfiguration(), other.anywhereConfiguration()) && Objects.equals(this.instanceRoleCredentialsProviderAsString(), other.instanceRoleCredentialsProviderAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFleetRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("BuildId", (Object)this.buildId()).add("ScriptId", (Object)this.scriptId()).add("ServerLaunchPath", (Object)this.serverLaunchPath()).add("ServerLaunchParameters", (Object)this.serverLaunchParameters()).add("LogPaths", this.hasLogPaths() ? this.logPaths() : null).add("EC2InstanceType", (Object)this.ec2InstanceTypeAsString()).add("EC2InboundPermissions", this.hasEc2InboundPermissions() ? this.ec2InboundPermissions() : null).add("NewGameSessionProtectionPolicy", (Object)this.newGameSessionProtectionPolicyAsString()).add("RuntimeConfiguration", (Object)this.runtimeConfiguration()).add("ResourceCreationLimitPolicy", (Object)this.resourceCreationLimitPolicy()).add("MetricGroups", this.hasMetricGroups() ? this.metricGroups() : null).add("PeerVpcAwsAccountId", (Object)this.peerVpcAwsAccountId()).add("PeerVpcId", (Object)this.peerVpcId()).add("FleetType", (Object)this.fleetTypeAsString()).add("InstanceRoleArn", (Object)this.instanceRoleArn()).add("CertificateConfiguration", (Object)this.certificateConfiguration()).add("Locations", this.hasLocations() ? this.locations() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ComputeType", (Object)this.computeTypeAsString()).add("AnywhereConfiguration", (Object)this.anywhereConfiguration()).add("InstanceRoleCredentialsProvider", (Object)this.instanceRoleCredentialsProviderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "BuildId": {
                return Optional.ofNullable(clazz.cast(this.buildId()));
            }
            case "ScriptId": {
                return Optional.ofNullable(clazz.cast(this.scriptId()));
            }
            case "ServerLaunchPath": {
                return Optional.ofNullable(clazz.cast(this.serverLaunchPath()));
            }
            case "ServerLaunchParameters": {
                return Optional.ofNullable(clazz.cast(this.serverLaunchParameters()));
            }
            case "LogPaths": {
                return Optional.ofNullable(clazz.cast(this.logPaths()));
            }
            case "EC2InstanceType": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceTypeAsString()));
            }
            case "EC2InboundPermissions": {
                return Optional.ofNullable(clazz.cast(this.ec2InboundPermissions()));
            }
            case "NewGameSessionProtectionPolicy": {
                return Optional.ofNullable(clazz.cast(this.newGameSessionProtectionPolicyAsString()));
            }
            case "RuntimeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.runtimeConfiguration()));
            }
            case "ResourceCreationLimitPolicy": {
                return Optional.ofNullable(clazz.cast(this.resourceCreationLimitPolicy()));
            }
            case "MetricGroups": {
                return Optional.ofNullable(clazz.cast(this.metricGroups()));
            }
            case "PeerVpcAwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.peerVpcAwsAccountId()));
            }
            case "PeerVpcId": {
                return Optional.ofNullable(clazz.cast(this.peerVpcId()));
            }
            case "FleetType": {
                return Optional.ofNullable(clazz.cast(this.fleetTypeAsString()));
            }
            case "InstanceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.instanceRoleArn()));
            }
            case "CertificateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.certificateConfiguration()));
            }
            case "Locations": {
                return Optional.ofNullable(clazz.cast(this.locations()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ComputeType": {
                return Optional.ofNullable(clazz.cast(this.computeTypeAsString()));
            }
            case "AnywhereConfiguration": {
                return Optional.ofNullable(clazz.cast(this.anywhereConfiguration()));
            }
            case "InstanceRoleCredentialsProvider": {
                return Optional.ofNullable(clazz.cast(this.instanceRoleCredentialsProviderAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("BuildId", BUILD_ID_FIELD);
        map.put("ScriptId", SCRIPT_ID_FIELD);
        map.put("ServerLaunchPath", SERVER_LAUNCH_PATH_FIELD);
        map.put("ServerLaunchParameters", SERVER_LAUNCH_PARAMETERS_FIELD);
        map.put("LogPaths", LOG_PATHS_FIELD);
        map.put("EC2InstanceType", EC2_INSTANCE_TYPE_FIELD);
        map.put("EC2InboundPermissions", EC2_INBOUND_PERMISSIONS_FIELD);
        map.put("NewGameSessionProtectionPolicy", NEW_GAME_SESSION_PROTECTION_POLICY_FIELD);
        map.put("RuntimeConfiguration", RUNTIME_CONFIGURATION_FIELD);
        map.put("ResourceCreationLimitPolicy", RESOURCE_CREATION_LIMIT_POLICY_FIELD);
        map.put("MetricGroups", METRIC_GROUPS_FIELD);
        map.put("PeerVpcAwsAccountId", PEER_VPC_AWS_ACCOUNT_ID_FIELD);
        map.put("PeerVpcId", PEER_VPC_ID_FIELD);
        map.put("FleetType", FLEET_TYPE_FIELD);
        map.put("InstanceRoleArn", INSTANCE_ROLE_ARN_FIELD);
        map.put("CertificateConfiguration", CERTIFICATE_CONFIGURATION_FIELD);
        map.put("Locations", LOCATIONS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ComputeType", COMPUTE_TYPE_FIELD);
        map.put("AnywhereConfiguration", ANYWHERE_CONFIGURATION_FIELD);
        map.put("InstanceRoleCredentialsProvider", INSTANCE_ROLE_CREDENTIALS_PROVIDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetRequest, T> g) {
        return obj -> g.apply((CreateFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String buildId;
        private String scriptId;
        private String serverLaunchPath;
        private String serverLaunchParameters;
        private List<String> logPaths = DefaultSdkAutoConstructList.getInstance();
        private String ec2InstanceType;
        private List<IpPermission> ec2InboundPermissions = DefaultSdkAutoConstructList.getInstance();
        private String newGameSessionProtectionPolicy;
        private RuntimeConfiguration runtimeConfiguration;
        private ResourceCreationLimitPolicy resourceCreationLimitPolicy;
        private List<String> metricGroups = DefaultSdkAutoConstructList.getInstance();
        private String peerVpcAwsAccountId;
        private String peerVpcId;
        private String fleetType;
        private String instanceRoleArn;
        private CertificateConfiguration certificateConfiguration;
        private List<LocationConfiguration> locations = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String computeType;
        private AnywhereConfiguration anywhereConfiguration;
        private String instanceRoleCredentialsProvider;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.buildId(model.buildId);
            this.scriptId(model.scriptId);
            this.serverLaunchPath(model.serverLaunchPath);
            this.serverLaunchParameters(model.serverLaunchParameters);
            this.logPaths(model.logPaths);
            this.ec2InstanceType(model.ec2InstanceType);
            this.ec2InboundPermissions(model.ec2InboundPermissions);
            this.newGameSessionProtectionPolicy(model.newGameSessionProtectionPolicy);
            this.runtimeConfiguration(model.runtimeConfiguration);
            this.resourceCreationLimitPolicy(model.resourceCreationLimitPolicy);
            this.metricGroups(model.metricGroups);
            this.peerVpcAwsAccountId(model.peerVpcAwsAccountId);
            this.peerVpcId(model.peerVpcId);
            this.fleetType(model.fleetType);
            this.instanceRoleArn(model.instanceRoleArn);
            this.certificateConfiguration(model.certificateConfiguration);
            this.locations(model.locations);
            this.tags(model.tags);
            this.computeType(model.computeType);
            this.anywhereConfiguration(model.anywhereConfiguration);
            this.instanceRoleCredentialsProvider(model.instanceRoleCredentialsProvider);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBuildId() {
            return this.buildId;
        }

        public final void setBuildId(String buildId) {
            this.buildId = buildId;
        }

        @Override
        public final Builder buildId(String buildId) {
            this.buildId = buildId;
            return this;
        }

        public final String getScriptId() {
            return this.scriptId;
        }

        public final void setScriptId(String scriptId) {
            this.scriptId = scriptId;
        }

        @Override
        public final Builder scriptId(String scriptId) {
            this.scriptId = scriptId;
            return this;
        }

        public final String getServerLaunchPath() {
            return this.serverLaunchPath;
        }

        public final void setServerLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
        }

        @Override
        public final Builder serverLaunchPath(String serverLaunchPath) {
            this.serverLaunchPath = serverLaunchPath;
            return this;
        }

        public final String getServerLaunchParameters() {
            return this.serverLaunchParameters;
        }

        public final void setServerLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
        }

        @Override
        public final Builder serverLaunchParameters(String serverLaunchParameters) {
            this.serverLaunchParameters = serverLaunchParameters;
            return this;
        }

        public final Collection<String> getLogPaths() {
            if (this.logPaths instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logPaths;
        }

        public final void setLogPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
        }

        @Override
        public final Builder logPaths(Collection<String> logPaths) {
            this.logPaths = StringListCopier.copy(logPaths);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logPaths(String ... logPaths) {
            this.logPaths(Arrays.asList(logPaths));
            return this;
        }

        public final String getEc2InstanceType() {
            return this.ec2InstanceType;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType == null ? null : ec2InstanceType.toString());
            return this;
        }

        public final List<IpPermission.Builder> getEc2InboundPermissions() {
            List<IpPermission.Builder> result = IpPermissionsListCopier.copyToBuilder(this.ec2InboundPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2InboundPermissions(Collection<IpPermission.BuilderImpl> ec2InboundPermissions) {
            this.ec2InboundPermissions = IpPermissionsListCopier.copyFromBuilder(ec2InboundPermissions);
        }

        @Override
        public final Builder ec2InboundPermissions(Collection<IpPermission> ec2InboundPermissions) {
            this.ec2InboundPermissions = IpPermissionsListCopier.copy(ec2InboundPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InboundPermissions(IpPermission ... ec2InboundPermissions) {
            this.ec2InboundPermissions(Arrays.asList(ec2InboundPermissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InboundPermissions(Consumer<IpPermission.Builder> ... ec2InboundPermissions) {
            this.ec2InboundPermissions(Stream.of(ec2InboundPermissions).map(c -> (IpPermission)((IpPermission.Builder)IpPermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNewGameSessionProtectionPolicy() {
            return this.newGameSessionProtectionPolicy;
        }

        public final void setNewGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(String newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy = newGameSessionProtectionPolicy;
            return this;
        }

        @Override
        public final Builder newGameSessionProtectionPolicy(ProtectionPolicy newGameSessionProtectionPolicy) {
            this.newGameSessionProtectionPolicy(newGameSessionProtectionPolicy == null ? null : newGameSessionProtectionPolicy.toString());
            return this;
        }

        public final RuntimeConfiguration.Builder getRuntimeConfiguration() {
            return this.runtimeConfiguration != null ? this.runtimeConfiguration.toBuilder() : null;
        }

        public final void setRuntimeConfiguration(RuntimeConfiguration.BuilderImpl runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration != null ? runtimeConfiguration.build() : null;
        }

        @Override
        public final Builder runtimeConfiguration(RuntimeConfiguration runtimeConfiguration) {
            this.runtimeConfiguration = runtimeConfiguration;
            return this;
        }

        public final ResourceCreationLimitPolicy.Builder getResourceCreationLimitPolicy() {
            return this.resourceCreationLimitPolicy != null ? this.resourceCreationLimitPolicy.toBuilder() : null;
        }

        public final void setResourceCreationLimitPolicy(ResourceCreationLimitPolicy.BuilderImpl resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy != null ? resourceCreationLimitPolicy.build() : null;
        }

        @Override
        public final Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy resourceCreationLimitPolicy) {
            this.resourceCreationLimitPolicy = resourceCreationLimitPolicy;
            return this;
        }

        public final Collection<String> getMetricGroups() {
            if (this.metricGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metricGroups;
        }

        public final void setMetricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
        }

        @Override
        public final Builder metricGroups(Collection<String> metricGroups) {
            this.metricGroups = MetricGroupListCopier.copy(metricGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricGroups(String ... metricGroups) {
            this.metricGroups(Arrays.asList(metricGroups));
            return this;
        }

        public final String getPeerVpcAwsAccountId() {
            return this.peerVpcAwsAccountId;
        }

        public final void setPeerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
        }

        @Override
        public final Builder peerVpcAwsAccountId(String peerVpcAwsAccountId) {
            this.peerVpcAwsAccountId = peerVpcAwsAccountId;
            return this;
        }

        public final String getPeerVpcId() {
            return this.peerVpcId;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final String getFleetType() {
            return this.fleetType;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType == null ? null : fleetType.toString());
            return this;
        }

        public final String getInstanceRoleArn() {
            return this.instanceRoleArn;
        }

        public final void setInstanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
        }

        @Override
        public final Builder instanceRoleArn(String instanceRoleArn) {
            this.instanceRoleArn = instanceRoleArn;
            return this;
        }

        public final CertificateConfiguration.Builder getCertificateConfiguration() {
            return this.certificateConfiguration != null ? this.certificateConfiguration.toBuilder() : null;
        }

        public final void setCertificateConfiguration(CertificateConfiguration.BuilderImpl certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration != null ? certificateConfiguration.build() : null;
        }

        @Override
        public final Builder certificateConfiguration(CertificateConfiguration certificateConfiguration) {
            this.certificateConfiguration = certificateConfiguration;
            return this;
        }

        public final List<LocationConfiguration.Builder> getLocations() {
            List<LocationConfiguration.Builder> result = LocationConfigurationListCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<LocationConfiguration.BuilderImpl> locations) {
            this.locations = LocationConfigurationListCopier.copyFromBuilder(locations);
        }

        @Override
        public final Builder locations(Collection<LocationConfiguration> locations) {
            this.locations = LocationConfigurationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(LocationConfiguration ... locations) {
            this.locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<LocationConfiguration.Builder> ... locations) {
            this.locations(Stream.of(locations).map(c -> (LocationConfiguration)((LocationConfiguration.Builder)LocationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getComputeType() {
            return this.computeType;
        }

        public final void setComputeType(String computeType) {
            this.computeType = computeType;
        }

        @Override
        public final Builder computeType(String computeType) {
            this.computeType = computeType;
            return this;
        }

        @Override
        public final Builder computeType(ComputeType computeType) {
            this.computeType(computeType == null ? null : computeType.toString());
            return this;
        }

        public final AnywhereConfiguration.Builder getAnywhereConfiguration() {
            return this.anywhereConfiguration != null ? this.anywhereConfiguration.toBuilder() : null;
        }

        public final void setAnywhereConfiguration(AnywhereConfiguration.BuilderImpl anywhereConfiguration) {
            this.anywhereConfiguration = anywhereConfiguration != null ? anywhereConfiguration.build() : null;
        }

        @Override
        public final Builder anywhereConfiguration(AnywhereConfiguration anywhereConfiguration) {
            this.anywhereConfiguration = anywhereConfiguration;
            return this;
        }

        public final String getInstanceRoleCredentialsProvider() {
            return this.instanceRoleCredentialsProvider;
        }

        public final void setInstanceRoleCredentialsProvider(String instanceRoleCredentialsProvider) {
            this.instanceRoleCredentialsProvider = instanceRoleCredentialsProvider;
        }

        @Override
        public final Builder instanceRoleCredentialsProvider(String instanceRoleCredentialsProvider) {
            this.instanceRoleCredentialsProvider = instanceRoleCredentialsProvider;
            return this;
        }

        @Override
        public final Builder instanceRoleCredentialsProvider(InstanceRoleCredentialsProvider instanceRoleCredentialsProvider) {
            this.instanceRoleCredentialsProvider(instanceRoleCredentialsProvider == null ? null : instanceRoleCredentialsProvider.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFleetRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder buildId(String var1);

        public Builder scriptId(String var1);

        public Builder serverLaunchPath(String var1);

        public Builder serverLaunchParameters(String var1);

        public Builder logPaths(Collection<String> var1);

        public Builder logPaths(String ... var1);

        public Builder ec2InstanceType(String var1);

        public Builder ec2InstanceType(EC2InstanceType var1);

        public Builder ec2InboundPermissions(Collection<IpPermission> var1);

        public Builder ec2InboundPermissions(IpPermission ... var1);

        public Builder ec2InboundPermissions(Consumer<IpPermission.Builder> ... var1);

        public Builder newGameSessionProtectionPolicy(String var1);

        public Builder newGameSessionProtectionPolicy(ProtectionPolicy var1);

        public Builder runtimeConfiguration(RuntimeConfiguration var1);

        default public Builder runtimeConfiguration(Consumer<RuntimeConfiguration.Builder> runtimeConfiguration) {
            return this.runtimeConfiguration((RuntimeConfiguration)((RuntimeConfiguration.Builder)RuntimeConfiguration.builder().applyMutation(runtimeConfiguration)).build());
        }

        public Builder resourceCreationLimitPolicy(ResourceCreationLimitPolicy var1);

        default public Builder resourceCreationLimitPolicy(Consumer<ResourceCreationLimitPolicy.Builder> resourceCreationLimitPolicy) {
            return this.resourceCreationLimitPolicy((ResourceCreationLimitPolicy)((ResourceCreationLimitPolicy.Builder)ResourceCreationLimitPolicy.builder().applyMutation(resourceCreationLimitPolicy)).build());
        }

        public Builder metricGroups(Collection<String> var1);

        public Builder metricGroups(String ... var1);

        public Builder peerVpcAwsAccountId(String var1);

        public Builder peerVpcId(String var1);

        public Builder fleetType(String var1);

        public Builder fleetType(FleetType var1);

        public Builder instanceRoleArn(String var1);

        public Builder certificateConfiguration(CertificateConfiguration var1);

        default public Builder certificateConfiguration(Consumer<CertificateConfiguration.Builder> certificateConfiguration) {
            return this.certificateConfiguration((CertificateConfiguration)((CertificateConfiguration.Builder)CertificateConfiguration.builder().applyMutation(certificateConfiguration)).build());
        }

        public Builder locations(Collection<LocationConfiguration> var1);

        public Builder locations(LocationConfiguration ... var1);

        public Builder locations(Consumer<LocationConfiguration.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder computeType(String var1);

        public Builder computeType(ComputeType var1);

        public Builder anywhereConfiguration(AnywhereConfiguration var1);

        default public Builder anywhereConfiguration(Consumer<AnywhereConfiguration.Builder> anywhereConfiguration) {
            return this.anywhereConfiguration((AnywhereConfiguration)((AnywhereConfiguration.Builder)AnywhereConfiguration.builder().applyMutation(anywhereConfiguration)).build());
        }

        public Builder instanceRoleCredentialsProvider(String var1);

        public Builder instanceRoleCredentialsProvider(InstanceRoleCredentialsProvider var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

