/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.EC2InstanceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2InstanceLimit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EC2InstanceLimit> {
    private static final SdkField<String> EC2_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EC2InstanceType").getter(EC2InstanceLimit.getter(EC2InstanceLimit::ec2InstanceTypeAsString)).setter(EC2InstanceLimit.setter(Builder::ec2InstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceType").build()}).build();
    private static final SdkField<Integer> CURRENT_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CurrentInstances").getter(EC2InstanceLimit.getter(EC2InstanceLimit::currentInstances)).setter(EC2InstanceLimit.setter(Builder::currentInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInstances").build()}).build();
    private static final SdkField<Integer> INSTANCE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceLimit").getter(EC2InstanceLimit.getter(EC2InstanceLimit::instanceLimit)).setter(EC2InstanceLimit.setter(Builder::instanceLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceLimit").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(EC2InstanceLimit.getter(EC2InstanceLimit::location)).setter(EC2InstanceLimit.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_TYPE_FIELD, CURRENT_INSTANCES_FIELD, INSTANCE_LIMIT_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EC2InstanceLimit.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ec2InstanceType;
    private final Integer currentInstances;
    private final Integer instanceLimit;
    private final String location;

    private EC2InstanceLimit(BuilderImpl builder) {
        this.ec2InstanceType = builder.ec2InstanceType;
        this.currentInstances = builder.currentInstances;
        this.instanceLimit = builder.instanceLimit;
        this.location = builder.location;
    }

    public final EC2InstanceType ec2InstanceType() {
        return EC2InstanceType.fromValue(this.ec2InstanceType);
    }

    public final String ec2InstanceTypeAsString() {
        return this.ec2InstanceType;
    }

    public final Integer currentInstances() {
        return this.currentInstances;
    }

    public final Integer instanceLimit() {
        return this.instanceLimit;
    }

    public final String location() {
        return this.location;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceLimit)) {
            return false;
        }
        EC2InstanceLimit other = (EC2InstanceLimit)obj;
        return Objects.equals(this.ec2InstanceTypeAsString(), other.ec2InstanceTypeAsString()) && Objects.equals(this.currentInstances(), other.currentInstances()) && Objects.equals(this.instanceLimit(), other.instanceLimit()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"EC2InstanceLimit").add("EC2InstanceType", (Object)this.ec2InstanceTypeAsString()).add("CurrentInstances", (Object)this.currentInstances()).add("InstanceLimit", (Object)this.instanceLimit()).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EC2InstanceType": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceTypeAsString()));
            }
            case "CurrentInstances": {
                return Optional.ofNullable(clazz.cast(this.currentInstances()));
            }
            case "InstanceLimit": {
                return Optional.ofNullable(clazz.cast(this.instanceLimit()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("EC2InstanceType", EC2_INSTANCE_TYPE_FIELD);
        map.put("CurrentInstances", CURRENT_INSTANCES_FIELD);
        map.put("InstanceLimit", INSTANCE_LIMIT_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EC2InstanceLimit, T> g) {
        return obj -> g.apply((EC2InstanceLimit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ec2InstanceType;
        private Integer currentInstances;
        private Integer instanceLimit;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceLimit model) {
            this.ec2InstanceType(model.ec2InstanceType);
            this.currentInstances(model.currentInstances);
            this.instanceLimit(model.instanceLimit);
            this.location(model.location);
        }

        public final String getEc2InstanceType() {
            return this.ec2InstanceType;
        }

        public final void setEc2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
        }

        @Override
        public final Builder ec2InstanceType(String ec2InstanceType) {
            this.ec2InstanceType = ec2InstanceType;
            return this;
        }

        @Override
        public final Builder ec2InstanceType(EC2InstanceType ec2InstanceType) {
            this.ec2InstanceType(ec2InstanceType == null ? null : ec2InstanceType.toString());
            return this;
        }

        public final Integer getCurrentInstances() {
            return this.currentInstances;
        }

        public final void setCurrentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
        }

        @Override
        public final Builder currentInstances(Integer currentInstances) {
            this.currentInstances = currentInstances;
            return this;
        }

        public final Integer getInstanceLimit() {
            return this.instanceLimit;
        }

        public final void setInstanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
        }

        @Override
        public final Builder instanceLimit(Integer instanceLimit) {
            this.instanceLimit = instanceLimit;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public EC2InstanceLimit build() {
            return new EC2InstanceLimit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EC2InstanceLimit> {
        public Builder ec2InstanceType(String var1);

        public Builder ec2InstanceType(EC2InstanceType var1);

        public Builder currentInstances(Integer var1);

        public Builder instanceLimit(Integer var1);

        public Builder location(String var1);
    }
}

