/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.LogDestination;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogConfiguration> {
    private static final SdkField<String> LOG_DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogDestination").getter(LogConfiguration.getter(LogConfiguration::logDestinationAsString)).setter(LogConfiguration.setter(Builder::logDestination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogDestination").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(LogConfiguration.getter(LogConfiguration::s3BucketName)).setter(LogConfiguration.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> LOG_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogGroupArn").getter(LogConfiguration.getter(LogConfiguration::logGroupArn)).setter(LogConfiguration.setter(Builder::logGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_DESTINATION_FIELD, S3_BUCKET_NAME_FIELD, LOG_GROUP_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LogConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String logDestination;
    private final String s3BucketName;
    private final String logGroupArn;

    private LogConfiguration(BuilderImpl builder) {
        this.logDestination = builder.logDestination;
        this.s3BucketName = builder.s3BucketName;
        this.logGroupArn = builder.logGroupArn;
    }

    public final LogDestination logDestination() {
        return LogDestination.fromValue(this.logDestination);
    }

    public final String logDestinationAsString() {
        return this.logDestination;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String logGroupArn() {
        return this.logGroupArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logDestinationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration)obj;
        return Objects.equals(this.logDestinationAsString(), other.logDestinationAsString()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.logGroupArn(), other.logGroupArn());
    }

    public final String toString() {
        return ToString.builder((String)"LogConfiguration").add("LogDestination", (Object)this.logDestinationAsString()).add("S3BucketName", (Object)this.s3BucketName()).add("LogGroupArn", (Object)this.logGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogDestination": {
                return Optional.ofNullable(clazz.cast(this.logDestinationAsString()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "LogGroupArn": {
                return Optional.ofNullable(clazz.cast(this.logGroupArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("LogDestination", LOG_DESTINATION_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("LogGroupArn", LOG_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LogConfiguration, T> g) {
        return obj -> g.apply((LogConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logDestination;
        private String s3BucketName;
        private String logGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfiguration model) {
            this.logDestination(model.logDestination);
            this.s3BucketName(model.s3BucketName);
            this.logGroupArn(model.logGroupArn);
        }

        public final String getLogDestination() {
            return this.logDestination;
        }

        public final void setLogDestination(String logDestination) {
            this.logDestination = logDestination;
        }

        @Override
        public final Builder logDestination(String logDestination) {
            this.logDestination = logDestination;
            return this;
        }

        @Override
        public final Builder logDestination(LogDestination logDestination) {
            this.logDestination(logDestination == null ? null : logDestination.toString());
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getLogGroupArn() {
            return this.logGroupArn;
        }

        public final void setLogGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
        }

        @Override
        public final Builder logGroupArn(String logGroupArn) {
            this.logGroupArn = logGroupArn;
            return this;
        }

        public LogConfiguration build() {
            return new LogConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogConfiguration> {
        public Builder logDestination(String var1);

        public Builder logDestination(LogDestination var1);

        public Builder s3BucketName(String var1);

        public Builder logGroupArn(String var1);
    }
}

