/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamelift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.gamelift.model.GameLiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterComputeRequest
extends GameLiftRequest
implements ToCopyableBuilder<Builder, RegisterComputeRequest> {
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FleetId").getter(RegisterComputeRequest.getter(RegisterComputeRequest::fleetId)).setter(RegisterComputeRequest.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetId").build()}).build();
    private static final SdkField<String> COMPUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ComputeName").getter(RegisterComputeRequest.getter(RegisterComputeRequest::computeName)).setter(RegisterComputeRequest.setter(Builder::computeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeName").build()}).build();
    private static final SdkField<String> CERTIFICATE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificatePath").getter(RegisterComputeRequest.getter(RegisterComputeRequest::certificatePath)).setter(RegisterComputeRequest.setter(Builder::certificatePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificatePath").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(RegisterComputeRequest.getter(RegisterComputeRequest::dnsName)).setter(RegisterComputeRequest.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<String> IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpAddress").getter(RegisterComputeRequest.getter(RegisterComputeRequest::ipAddress)).setter(RegisterComputeRequest.setter(Builder::ipAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddress").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Location").getter(RegisterComputeRequest.getter(RegisterComputeRequest::location)).setter(RegisterComputeRequest.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLEET_ID_FIELD, COMPUTE_NAME_FIELD, CERTIFICATE_PATH_FIELD, DNS_NAME_FIELD, IP_ADDRESS_FIELD, LOCATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RegisterComputeRequest.memberNameToFieldInitializer();
    private final String fleetId;
    private final String computeName;
    private final String certificatePath;
    private final String dnsName;
    private final String ipAddress;
    private final String location;

    private RegisterComputeRequest(BuilderImpl builder) {
        super(builder);
        this.fleetId = builder.fleetId;
        this.computeName = builder.computeName;
        this.certificatePath = builder.certificatePath;
        this.dnsName = builder.dnsName;
        this.ipAddress = builder.ipAddress;
        this.location = builder.location;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final String computeName() {
        return this.computeName;
    }

    public final String certificatePath() {
        return this.certificatePath;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final String ipAddress() {
        return this.ipAddress;
    }

    public final String location() {
        return this.location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificatePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterComputeRequest)) {
            return false;
        }
        RegisterComputeRequest other = (RegisterComputeRequest)((Object)obj);
        return Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.computeName(), other.computeName()) && Objects.equals(this.certificatePath(), other.certificatePath()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.ipAddress(), other.ipAddress()) && Objects.equals(this.location(), other.location());
    }

    public final String toString() {
        return ToString.builder((String)"RegisterComputeRequest").add("FleetId", (Object)this.fleetId()).add("ComputeName", (Object)this.computeName()).add("CertificatePath", (Object)this.certificatePath()).add("DnsName", (Object)this.dnsName()).add("IpAddress", (Object)(this.ipAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Location", (Object)this.location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "ComputeName": {
                return Optional.ofNullable(clazz.cast(this.computeName()));
            }
            case "CertificatePath": {
                return Optional.ofNullable(clazz.cast(this.certificatePath()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "IpAddress": {
                return Optional.ofNullable(clazz.cast(this.ipAddress()));
            }
            case "Location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("FleetId", FLEET_ID_FIELD);
        map.put("ComputeName", COMPUTE_NAME_FIELD);
        map.put("CertificatePath", CERTIFICATE_PATH_FIELD);
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("IpAddress", IP_ADDRESS_FIELD);
        map.put("Location", LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegisterComputeRequest, T> g) {
        return obj -> g.apply((RegisterComputeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GameLiftRequest.BuilderImpl
    implements Builder {
        private String fleetId;
        private String computeName;
        private String certificatePath;
        private String dnsName;
        private String ipAddress;
        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterComputeRequest model) {
            super(model);
            this.fleetId(model.fleetId);
            this.computeName(model.computeName);
            this.certificatePath(model.certificatePath);
            this.dnsName(model.dnsName);
            this.ipAddress(model.ipAddress);
            this.location(model.location);
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getComputeName() {
            return this.computeName;
        }

        public final void setComputeName(String computeName) {
            this.computeName = computeName;
        }

        @Override
        public final Builder computeName(String computeName) {
            this.computeName = computeName;
            return this;
        }

        public final String getCertificatePath() {
            return this.certificatePath;
        }

        public final void setCertificatePath(String certificatePath) {
            this.certificatePath = certificatePath;
        }

        @Override
        public final Builder certificatePath(String certificatePath) {
            this.certificatePath = certificatePath;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getIpAddress() {
            return this.ipAddress;
        }

        public final void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Override
        public final Builder ipAddress(String ipAddress) {
            this.ipAddress = ipAddress;
            return this;
        }

        public final String getLocation() {
            return this.location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterComputeRequest build() {
            return new RegisterComputeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GameLiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterComputeRequest> {
        public Builder fleetId(String var1);

        public Builder computeName(String var1);

        public Builder certificatePath(String var1);

        public Builder dnsName(String var1);

        public Builder ipAddress(String var1);

        public Builder location(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

