/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.gamesparks.model.AccessDeniedException;
import software.amazon.awssdk.services.gamesparks.model.ConflictException;
import software.amazon.awssdk.services.gamesparks.model.CreateGameRequest;
import software.amazon.awssdk.services.gamesparks.model.CreateGameResponse;
import software.amazon.awssdk.services.gamesparks.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.CreateStageRequest;
import software.amazon.awssdk.services.gamesparks.model.CreateStageResponse;
import software.amazon.awssdk.services.gamesparks.model.DeleteGameRequest;
import software.amazon.awssdk.services.gamesparks.model.DeleteGameResponse;
import software.amazon.awssdk.services.gamesparks.model.DeleteStageRequest;
import software.amazon.awssdk.services.gamesparks.model.DeleteStageResponse;
import software.amazon.awssdk.services.gamesparks.model.DisconnectPlayerRequest;
import software.amazon.awssdk.services.gamesparks.model.DisconnectPlayerResponse;
import software.amazon.awssdk.services.gamesparks.model.ExportSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.ExportSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.GameSparksException;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionRequest;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionResponse;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionVersionRequest;
import software.amazon.awssdk.services.gamesparks.model.GetExtensionVersionResponse;
import software.amazon.awssdk.services.gamesparks.model.GetGameConfigurationRequest;
import software.amazon.awssdk.services.gamesparks.model.GetGameConfigurationResponse;
import software.amazon.awssdk.services.gamesparks.model.GetGameRequest;
import software.amazon.awssdk.services.gamesparks.model.GetGameResponse;
import software.amazon.awssdk.services.gamesparks.model.GetGeneratedCodeJobRequest;
import software.amazon.awssdk.services.gamesparks.model.GetGeneratedCodeJobResponse;
import software.amazon.awssdk.services.gamesparks.model.GetPlayerConnectionStatusRequest;
import software.amazon.awssdk.services.gamesparks.model.GetPlayerConnectionStatusResponse;
import software.amazon.awssdk.services.gamesparks.model.GetSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.GetSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.GetStageDeploymentRequest;
import software.amazon.awssdk.services.gamesparks.model.GetStageDeploymentResponse;
import software.amazon.awssdk.services.gamesparks.model.GetStageRequest;
import software.amazon.awssdk.services.gamesparks.model.GetStageResponse;
import software.amazon.awssdk.services.gamesparks.model.ImportGameConfigurationRequest;
import software.amazon.awssdk.services.gamesparks.model.ImportGameConfigurationResponse;
import software.amazon.awssdk.services.gamesparks.model.InternalServerException;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListExtensionsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListGamesRequest;
import software.amazon.awssdk.services.gamesparks.model.ListGamesResponse;
import software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse;
import software.amazon.awssdk.services.gamesparks.model.ListStagesRequest;
import software.amazon.awssdk.services.gamesparks.model.ListStagesResponse;
import software.amazon.awssdk.services.gamesparks.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.gamesparks.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.gamesparks.model.ResourceNotFoundException;
import software.amazon.awssdk.services.gamesparks.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.gamesparks.model.StartGeneratedCodeJobRequest;
import software.amazon.awssdk.services.gamesparks.model.StartGeneratedCodeJobResponse;
import software.amazon.awssdk.services.gamesparks.model.StartStageDeploymentRequest;
import software.amazon.awssdk.services.gamesparks.model.StartStageDeploymentResponse;
import software.amazon.awssdk.services.gamesparks.model.TagResourceRequest;
import software.amazon.awssdk.services.gamesparks.model.TagResourceResponse;
import software.amazon.awssdk.services.gamesparks.model.ThrottlingException;
import software.amazon.awssdk.services.gamesparks.model.UntagResourceRequest;
import software.amazon.awssdk.services.gamesparks.model.UntagResourceResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameConfigurationRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameConfigurationResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateGameResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateSnapshotRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateSnapshotResponse;
import software.amazon.awssdk.services.gamesparks.model.UpdateStageRequest;
import software.amazon.awssdk.services.gamesparks.model.UpdateStageResponse;
import software.amazon.awssdk.services.gamesparks.model.ValidationException;
import software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListGamesIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsIterable;
import software.amazon.awssdk.services.gamesparks.paginators.ListStagesIterable;

/**
 * Service client for accessing GameSparks. This can be created using the static {@link #builder()} method.
 *
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface GameSparksClient extends AwsClient {
    String SERVICE_NAME = "gamesparks";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "gamesparks";

    /**
     * <p>
     * Creates a new game with an empty configuration. After creating your game, you can update the configuration using
     * <code>UpdateGameConfiguration</code> or <code>ImportGameConfiguration</code>.
     * </p>
     *
     * @param createGameRequest
     * @return Result of the CreateGame operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws ServiceQuotaExceededException
     *         The request would result in exceeding service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.CreateGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateGame" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGameResponse createGame(CreateGameRequest createGameRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ConflictException, InternalServerException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new game with an empty configuration. After creating your game, you can update the configuration using
     * <code>UpdateGameConfiguration</code> or <code>ImportGameConfiguration</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGameRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGameRequest#builder()}
     * </p>
     *
     * @param createGameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.CreateGameRequest.Builder} to create a request.
     * @return Result of the CreateGame operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws ServiceQuotaExceededException
     *         The request would result in exceeding service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.CreateGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateGame" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGameResponse createGame(Consumer<CreateGameRequest.Builder> createGameRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ConflictException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, GameSparksException {
        return createGame(CreateGameRequest.builder().applyMutation(createGameRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of the game configuration.
     * </p>
     *
     * @param createSnapshotRequest
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of the game configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link CreateSnapshotRequest#builder()}
     * </p>
     *
     * @param createSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.CreateSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateSnapshotResponse createSnapshot(Consumer<CreateSnapshotRequest.Builder> createSnapshotRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return createSnapshot(CreateSnapshotRequest.builder().applyMutation(createSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new stage for stage-by-stage game development and deployment.
     * </p>
     *
     * @param createStageRequest
     * @return Result of the CreateStage operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.CreateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStageResponse createStage(CreateStageRequest createStageRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new stage for stage-by-stage game development and deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStageRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStageRequest#builder()}
     * </p>
     *
     * @param createStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.CreateStageRequest.Builder} to create a request.
     * @return Result of the CreateStage operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.CreateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/CreateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStageResponse createStage(Consumer<CreateStageRequest.Builder> createStageRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, GameSparksException {
        return createStage(CreateStageRequest.builder().applyMutation(createStageRequest).build());
    }

    /**
     * <p>
     * Deletes a game.
     * </p>
     *
     * @param deleteGameRequest
     * @return Result of the DeleteGame operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.DeleteGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteGame" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGameResponse deleteGame(DeleteGameRequest deleteGameRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ConflictException, InternalServerException, AwsServiceException, SdkClientException,
            GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGameRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGameRequest#builder()}
     * </p>
     *
     * @param deleteGameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.DeleteGameRequest.Builder} to create a request.
     * @return Result of the DeleteGame operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.DeleteGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteGame" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGameResponse deleteGame(Consumer<DeleteGameRequest.Builder> deleteGameRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return deleteGame(DeleteGameRequest.builder().applyMutation(deleteGameRequest).build());
    }

    /**
     * <p>
     * Deletes a stage from a game, along with the associated game runtime.
     * </p>
     *
     * @param deleteStageRequest
     * @return Result of the DeleteStage operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.DeleteStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteStage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStageResponse deleteStage(DeleteStageRequest deleteStageRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a stage from a game, along with the associated game runtime.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStageRequest#builder()}
     * </p>
     *
     * @param deleteStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.DeleteStageRequest.Builder} to create a request.
     * @return Result of the DeleteStage operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.DeleteStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DeleteStage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStageResponse deleteStage(Consumer<DeleteStageRequest.Builder> deleteStageRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, GameSparksException {
        return deleteStage(DeleteStageRequest.builder().applyMutation(deleteStageRequest).build());
    }

    /**
     * <p>
     * Disconnects a player from the game runtime.
     * </p>
     * <p>
     * If a player has multiple connections, this operation attempts to close all of them.
     * </p>
     *
     * @param disconnectPlayerRequest
     * @return Result of the DisconnectPlayer operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.DisconnectPlayer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DisconnectPlayer" target="_top">AWS
     *      API Documentation</a>
     */
    default DisconnectPlayerResponse disconnectPlayer(DisconnectPlayerRequest disconnectPlayerRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disconnects a player from the game runtime.
     * </p>
     * <p>
     * If a player has multiple connections, this operation attempts to close all of them.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisconnectPlayerRequest.Builder} avoiding the need
     * to create one manually via {@link DisconnectPlayerRequest#builder()}
     * </p>
     *
     * @param disconnectPlayerRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.DisconnectPlayerRequest.Builder} to create a
     *        request.
     * @return Result of the DisconnectPlayer operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.DisconnectPlayer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/DisconnectPlayer" target="_top">AWS
     *      API Documentation</a>
     */
    default DisconnectPlayerResponse disconnectPlayer(Consumer<DisconnectPlayerRequest.Builder> disconnectPlayerRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return disconnectPlayer(DisconnectPlayerRequest.builder().applyMutation(disconnectPlayerRequest).build());
    }

    /**
     * <p>
     * Exports a game configuration snapshot.
     * </p>
     *
     * @param exportSnapshotRequest
     * @return Result of the ExportSnapshot operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ExportSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ExportSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportSnapshotResponse exportSnapshot(ExportSnapshotRequest exportSnapshotRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports a game configuration snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link ExportSnapshotRequest#builder()}
     * </p>
     *
     * @param exportSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ExportSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the ExportSnapshot operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ExportSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ExportSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default ExportSnapshotResponse exportSnapshot(Consumer<ExportSnapshotRequest.Builder> exportSnapshotRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return exportSnapshot(ExportSnapshotRequest.builder().applyMutation(exportSnapshotRequest).build());
    }

    /**
     * <p>
     * Gets details about a specified extension.
     * </p>
     *
     * @param getExtensionRequest
     * @return Result of the GetExtension operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExtensionResponse getExtension(GetExtensionRequest getExtensionRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a specified extension.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExtensionRequest.Builder} avoiding the need to
     * create one manually via {@link GetExtensionRequest#builder()}
     * </p>
     *
     * @param getExtensionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.GetExtensionRequest.Builder} to create a request.
     * @return Result of the GetExtension operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtension" target="_top">AWS API
     *      Documentation</a>
     */
    default GetExtensionResponse getExtension(Consumer<GetExtensionRequest.Builder> getExtensionRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return getExtension(GetExtensionRequest.builder().applyMutation(getExtensionRequest).build());
    }

    /**
     * <p>
     * Gets details about a specified extension version.
     * </p>
     *
     * @param getExtensionVersionRequest
     * @return Result of the GetExtensionVersion operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetExtensionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtensionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExtensionVersionResponse getExtensionVersion(GetExtensionVersionRequest getExtensionVersionRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a specified extension version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetExtensionVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetExtensionVersionRequest#builder()}
     * </p>
     *
     * @param getExtensionVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.GetExtensionVersionRequest.Builder} to create a
     *        request.
     * @return Result of the GetExtensionVersion operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetExtensionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetExtensionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default GetExtensionVersionResponse getExtensionVersion(
            Consumer<GetExtensionVersionRequest.Builder> getExtensionVersionRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return getExtensionVersion(GetExtensionVersionRequest.builder().applyMutation(getExtensionVersionRequest).build());
    }

    /**
     * <p>
     * Gets details about a game.
     * </p>
     *
     * @param getGameRequest
     * @return Result of the GetGame operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGame" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGameResponse getGame(GetGameRequest getGameRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGameRequest.Builder} avoiding the need to create
     * one manually via {@link GetGameRequest#builder()}
     * </p>
     *
     * @param getGameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.GetGameRequest.Builder} to create a request.
     * @return Result of the GetGame operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGame" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGameResponse getGame(Consumer<GetGameRequest.Builder> getGameRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return getGame(GetGameRequest.builder().applyMutation(getGameRequest).build());
    }

    /**
     * <p>
     * Gets the configuration of the game.
     * </p>
     *
     * @param getGameConfigurationRequest
     * @return Result of the GetGameConfiguration operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGameConfigurationResponse getGameConfiguration(GetGameConfigurationRequest getGameConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the configuration of the game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGameConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetGameConfigurationRequest#builder()}
     * </p>
     *
     * @param getGameConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.GetGameConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetGameConfiguration operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGameConfigurationResponse getGameConfiguration(
            Consumer<GetGameConfigurationRequest.Builder> getGameConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return getGameConfiguration(GetGameConfigurationRequest.builder().applyMutation(getGameConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets details about a job that is generating code for a snapshot.
     * </p>
     *
     * @param getGeneratedCodeJobRequest
     * @return Result of the GetGeneratedCodeJob operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetGeneratedCodeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGeneratedCodeJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGeneratedCodeJobResponse getGeneratedCodeJob(GetGeneratedCodeJobRequest getGeneratedCodeJobRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets details about a job that is generating code for a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGeneratedCodeJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetGeneratedCodeJobRequest#builder()}
     * </p>
     *
     * @param getGeneratedCodeJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.GetGeneratedCodeJobRequest.Builder} to create a
     *        request.
     * @return Result of the GetGeneratedCodeJob operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetGeneratedCodeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetGeneratedCodeJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGeneratedCodeJobResponse getGeneratedCodeJob(
            Consumer<GetGeneratedCodeJobRequest.Builder> getGeneratedCodeJobRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return getGeneratedCodeJob(GetGeneratedCodeJobRequest.builder().applyMutation(getGeneratedCodeJobRequest).build());
    }

    /**
     * <p>
     * Gets the status of a player's connection to the game runtime.
     * </p>
     * <p>
     * It's possible for a single player to have multiple connections to the game runtime. If a player is not connected,
     * this operation returns an empty list.
     * </p>
     *
     * @param getPlayerConnectionStatusRequest
     * @return Result of the GetPlayerConnectionStatus operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetPlayerConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetPlayerConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlayerConnectionStatusResponse getPlayerConnectionStatus(
            GetPlayerConnectionStatusRequest getPlayerConnectionStatusRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a player's connection to the game runtime.
     * </p>
     * <p>
     * It's possible for a single player to have multiple connections to the game runtime. If a player is not connected,
     * this operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPlayerConnectionStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetPlayerConnectionStatusRequest#builder()}
     * </p>
     *
     * @param getPlayerConnectionStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.GetPlayerConnectionStatusRequest.Builder} to
     *        create a request.
     * @return Result of the GetPlayerConnectionStatus operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetPlayerConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetPlayerConnectionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPlayerConnectionStatusResponse getPlayerConnectionStatus(
            Consumer<GetPlayerConnectionStatusRequest.Builder> getPlayerConnectionStatusRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return getPlayerConnectionStatus(GetPlayerConnectionStatusRequest.builder()
                .applyMutation(getPlayerConnectionStatusRequest).build());
    }

    /**
     * <p>
     * Gets a copy of the game configuration in a snapshot.
     * </p>
     *
     * @param getSnapshotRequest
     * @return Result of the GetSnapshot operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnapshotResponse getSnapshot(GetSnapshotRequest getSnapshotRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a copy of the game configuration in a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link GetSnapshotRequest#builder()}
     * </p>
     *
     * @param getSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.GetSnapshotRequest.Builder} to create a request.
     * @return Result of the GetSnapshot operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default GetSnapshotResponse getSnapshot(Consumer<GetSnapshotRequest.Builder> getSnapshotRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return getSnapshot(GetSnapshotRequest.builder().applyMutation(getSnapshotRequest).build());
    }

    /**
     * <p>
     * Gets information about a stage.
     * </p>
     *
     * @param getStageRequest
     * @return Result of the GetStage operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStageResponse getStage(GetStageRequest getStageRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStageRequest.Builder} avoiding the need to
     * create one manually via {@link GetStageRequest#builder()}
     * </p>
     *
     * @param getStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.GetStageRequest.Builder} to create a request.
     * @return Result of the GetStage operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStage" target="_top">AWS API
     *      Documentation</a>
     */
    default GetStageResponse getStage(Consumer<GetStageRequest.Builder> getStageRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return getStage(GetStageRequest.builder().applyMutation(getStageRequest).build());
    }

    /**
     * <p>
     * Gets information about a stage deployment.
     * </p>
     *
     * @param getStageDeploymentRequest
     * @return Result of the GetStageDeployment operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetStageDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStageDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default GetStageDeploymentResponse getStageDeployment(GetStageDeploymentRequest getStageDeploymentRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a stage deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetStageDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link GetStageDeploymentRequest#builder()}
     * </p>
     *
     * @param getStageDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.GetStageDeploymentRequest.Builder} to create a
     *        request.
     * @return Result of the GetStageDeployment operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.GetStageDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/GetStageDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    default GetStageDeploymentResponse getStageDeployment(Consumer<GetStageDeploymentRequest.Builder> getStageDeploymentRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return getStageDeployment(GetStageDeploymentRequest.builder().applyMutation(getStageDeploymentRequest).build());
    }

    /**
     * <p>
     * Imports a game configuration.
     * </p>
     * <p>
     * This operation replaces the current configuration of the game with the provided input. This is not a reversible
     * operation. If you want to preserve the previous configuration, use <code>CreateSnapshot</code> to make a new
     * snapshot before importing.
     * </p>
     *
     * @param importGameConfigurationRequest
     * @return Result of the ImportGameConfiguration operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws ServiceQuotaExceededException
     *         The request would result in exceeding service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ImportGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ImportGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportGameConfigurationResponse importGameConfiguration(ImportGameConfigurationRequest importGameConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a game configuration.
     * </p>
     * <p>
     * This operation replaces the current configuration of the game with the provided input. This is not a reversible
     * operation. If you want to preserve the previous configuration, use <code>CreateSnapshot</code> to make a new
     * snapshot before importing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportGameConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link ImportGameConfigurationRequest#builder()}
     * </p>
     *
     * @param importGameConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ImportGameConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the ImportGameConfiguration operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws ServiceQuotaExceededException
     *         The request would result in exceeding service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ImportGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ImportGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default ImportGameConfigurationResponse importGameConfiguration(
            Consumer<ImportGameConfigurationRequest.Builder> importGameConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, GameSparksException {
        return importGameConfiguration(ImportGameConfigurationRequest.builder().applyMutation(importGameConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Gets a paginated list of available versions for the extension.
     * </p>
     * <p>
     * Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation
     * shows the versions that are currently available.
     * </p>
     *
     * @param listExtensionVersionsRequest
     * @return Result of the ListExtensionVersions operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListExtensionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensionVersionsResponse listExtensionVersions(ListExtensionVersionsRequest listExtensionVersionsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of available versions for the extension.
     * </p>
     * <p>
     * Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation
     * shows the versions that are currently available.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListExtensionVersionsRequest#builder()}
     * </p>
     *
     * @param listExtensionVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListExtensionVersions operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListExtensionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensionVersionsResponse listExtensionVersions(
            Consumer<ListExtensionVersionsRequest.Builder> listExtensionVersionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return listExtensionVersions(ListExtensionVersionsRequest.builder().applyMutation(listExtensionVersionsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of available versions for the extension.
     * </p>
     * <p>
     * Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation
     * shows the versions that are currently available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExtensionVersions(software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsIterable responses = client.listExtensionVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsIterable responses = client
     *             .listExtensionVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsIterable responses = client.listExtensionVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensionVersions(software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listExtensionVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListExtensionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensionVersionsIterable listExtensionVersionsPaginator(ListExtensionVersionsRequest listExtensionVersionsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return new ListExtensionVersionsIterable(this, listExtensionVersionsRequest);
    }

    /**
     * <p>
     * Gets a paginated list of available versions for the extension.
     * </p>
     * <p>
     * Each time an API change is made to an extension, the version is incremented. The list retrieved by this operation
     * shows the versions that are currently available.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExtensionVersions(software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsIterable responses = client.listExtensionVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsIterable responses = client
     *             .listExtensionVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionVersionsIterable responses = client.listExtensionVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensionVersions(software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListExtensionVersionsRequest#builder()}
     * </p>
     *
     * @param listExtensionVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListExtensionVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListExtensionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListExtensionVersionsIterable listExtensionVersionsPaginator(
            Consumer<ListExtensionVersionsRequest.Builder> listExtensionVersionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return listExtensionVersionsPaginator(ListExtensionVersionsRequest.builder().applyMutation(listExtensionVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a paginated list of available extensions.
     * </p>
     * <p>
     * Extensions provide features that games can use from scripts.
     * </p>
     *
     * @param listExtensionsRequest
     * @return Result of the ListExtensions operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExtensionsResponse listExtensions(ListExtensionsRequest listExtensionsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of available extensions.
     * </p>
     * <p>
     * Extensions provide features that games can use from scripts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExtensionsRequest#builder()}
     * </p>
     *
     * @param listExtensionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListExtensions operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExtensionsResponse listExtensions(Consumer<ListExtensionsRequest.Builder> listExtensionsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return listExtensions(ListExtensionsRequest.builder().applyMutation(listExtensionsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of available extensions.
     * </p>
     * <p>
     * Extensions provide features that games can use from scripts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExtensions(software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsIterable responses = client.listExtensionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsIterable responses = client
     *             .listExtensionsPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListExtensionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsIterable responses = client.listExtensionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensions(software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest)} operation.</b>
     * </p>
     *
     * @param listExtensionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExtensionsIterable listExtensionsPaginator(ListExtensionsRequest listExtensionsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return new ListExtensionsIterable(this, listExtensionsRequest);
    }

    /**
     * <p>
     * Gets a paginated list of available extensions.
     * </p>
     * <p>
     * Extensions provide features that games can use from scripts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listExtensions(software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsIterable responses = client.listExtensionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsIterable responses = client
     *             .listExtensionsPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListExtensionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListExtensionsIterable responses = client.listExtensionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExtensions(software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExtensionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExtensionsRequest#builder()}
     * </p>
     *
     * @param listExtensionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListExtensionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExtensionsIterable listExtensionsPaginator(Consumer<ListExtensionsRequest.Builder> listExtensionsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return listExtensionsPaginator(ListExtensionsRequest.builder().applyMutation(listExtensionsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of games.
     * </p>
     *
     * @param listGamesRequest
     * @return Result of the ListGames operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListGames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGames" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGamesResponse listGames(ListGamesRequest listGamesRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of games.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGamesRequest.Builder} avoiding the need to
     * create one manually via {@link ListGamesRequest#builder()}
     * </p>
     *
     * @param listGamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListGamesRequest.Builder} to create a request.
     * @return Result of the ListGames operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListGames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGames" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGamesResponse listGames(Consumer<ListGamesRequest.Builder> listGamesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            GameSparksException {
        return listGames(ListGamesRequest.builder().applyMutation(listGamesRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of games.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGames(software.amazon.awssdk.services.gamesparks.model.ListGamesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGamesIterable responses = client.listGamesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListGamesIterable responses = client.listGamesPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListGamesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGamesIterable responses = client.listGamesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGames(software.amazon.awssdk.services.gamesparks.model.ListGamesRequest)} operation.</b>
     * </p>
     *
     * @param listGamesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListGames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGames" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGamesIterable listGamesPaginator(ListGamesRequest listGamesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            GameSparksException {
        return new ListGamesIterable(this, listGamesRequest);
    }

    /**
     * <p>
     * Gets a paginated list of games.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGames(software.amazon.awssdk.services.gamesparks.model.ListGamesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGamesIterable responses = client.listGamesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListGamesIterable responses = client.listGamesPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListGamesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGamesIterable responses = client.listGamesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGames(software.amazon.awssdk.services.gamesparks.model.ListGamesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGamesRequest.Builder} avoiding the need to
     * create one manually via {@link ListGamesRequest#builder()}
     * </p>
     *
     * @param listGamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListGamesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListGames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGames" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGamesIterable listGamesPaginator(Consumer<ListGamesRequest.Builder> listGamesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            GameSparksException {
        return listGamesPaginator(ListGamesRequest.builder().applyMutation(listGamesRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of code generation jobs for a snapshot.
     * </p>
     *
     * @param listGeneratedCodeJobsRequest
     * @return Result of the ListGeneratedCodeJobs operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListGeneratedCodeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGeneratedCodeJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeneratedCodeJobsResponse listGeneratedCodeJobs(ListGeneratedCodeJobsRequest listGeneratedCodeJobsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of code generation jobs for a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeneratedCodeJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGeneratedCodeJobsRequest#builder()}
     * </p>
     *
     * @param listGeneratedCodeJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListGeneratedCodeJobs operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListGeneratedCodeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGeneratedCodeJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeneratedCodeJobsResponse listGeneratedCodeJobs(
            Consumer<ListGeneratedCodeJobsRequest.Builder> listGeneratedCodeJobsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return listGeneratedCodeJobs(ListGeneratedCodeJobsRequest.builder().applyMutation(listGeneratedCodeJobsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of code generation jobs for a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGeneratedCodeJobs(software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsIterable responses = client.listGeneratedCodeJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsIterable responses = client
     *             .listGeneratedCodeJobsPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsIterable responses = client.listGeneratedCodeJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeneratedCodeJobs(software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGeneratedCodeJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListGeneratedCodeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGeneratedCodeJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeneratedCodeJobsIterable listGeneratedCodeJobsPaginator(ListGeneratedCodeJobsRequest listGeneratedCodeJobsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return new ListGeneratedCodeJobsIterable(this, listGeneratedCodeJobsRequest);
    }

    /**
     * <p>
     * Gets a paginated list of code generation jobs for a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGeneratedCodeJobs(software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsIterable responses = client.listGeneratedCodeJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsIterable responses = client
     *             .listGeneratedCodeJobsPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListGeneratedCodeJobsIterable responses = client.listGeneratedCodeJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGeneratedCodeJobs(software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGeneratedCodeJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGeneratedCodeJobsRequest#builder()}
     * </p>
     *
     * @param listGeneratedCodeJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListGeneratedCodeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListGeneratedCodeJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGeneratedCodeJobsIterable listGeneratedCodeJobsPaginator(
            Consumer<ListGeneratedCodeJobsRequest.Builder> listGeneratedCodeJobsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return listGeneratedCodeJobsPaginator(ListGeneratedCodeJobsRequest.builder().applyMutation(listGeneratedCodeJobsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a paginated list of snapshot summaries from the game.
     * </p>
     *
     * @param listSnapshotsRequest
     * @return Result of the ListSnapshots operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSnapshotsResponse listSnapshots(ListSnapshotsRequest listSnapshotsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of snapshot summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSnapshotsRequest#builder()}
     * </p>
     *
     * @param listSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest.Builder} to create a request.
     * @return Result of the ListSnapshots operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSnapshotsResponse listSnapshots(Consumer<ListSnapshotsRequest.Builder> listSnapshotsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return listSnapshots(ListSnapshotsRequest.builder().applyMutation(listSnapshotsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of snapshot summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSnapshots(software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsIterable responses = client.listSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsIterable responses = client
     *             .listSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsIterable responses = client.listSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshots(software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest)} operation.</b>
     * </p>
     *
     * @param listSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSnapshotsIterable listSnapshotsPaginator(ListSnapshotsRequest listSnapshotsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return new ListSnapshotsIterable(this, listSnapshotsRequest);
    }

    /**
     * <p>
     * Gets a paginated list of snapshot summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSnapshots(software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsIterable responses = client.listSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsIterable responses = client
     *             .listSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListSnapshotsIterable responses = client.listSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSnapshots(software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSnapshotsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSnapshotsRequest#builder()}
     * </p>
     *
     * @param listSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListSnapshotsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSnapshotsIterable listSnapshotsPaginator(Consumer<ListSnapshotsRequest.Builder> listSnapshotsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return listSnapshotsPaginator(ListSnapshotsRequest.builder().applyMutation(listSnapshotsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of stage deployment summaries from the game.
     * </p>
     *
     * @param listStageDeploymentsRequest
     * @return Result of the ListStageDeployments operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListStageDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStageDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStageDeploymentsResponse listStageDeployments(ListStageDeploymentsRequest listStageDeploymentsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of stage deployment summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStageDeploymentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStageDeploymentsRequest#builder()}
     * </p>
     *
     * @param listStageDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest.Builder} to create a
     *        request.
     * @return Result of the ListStageDeployments operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListStageDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStageDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStageDeploymentsResponse listStageDeployments(
            Consumer<ListStageDeploymentsRequest.Builder> listStageDeploymentsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return listStageDeployments(ListStageDeploymentsRequest.builder().applyMutation(listStageDeploymentsRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of stage deployment summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStageDeployments(software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsIterable responses = client.listStageDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsIterable responses = client
     *             .listStageDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsIterable responses = client.listStageDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStageDeployments(software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStageDeploymentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListStageDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStageDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStageDeploymentsIterable listStageDeploymentsPaginator(ListStageDeploymentsRequest listStageDeploymentsRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return new ListStageDeploymentsIterable(this, listStageDeploymentsRequest);
    }

    /**
     * <p>
     * Gets a paginated list of stage deployment summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listStageDeployments(software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsIterable responses = client.listStageDeploymentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsIterable responses = client
     *             .listStageDeploymentsPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStageDeploymentsIterable responses = client.listStageDeploymentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStageDeployments(software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStageDeploymentsRequest.Builder} avoiding the
     * need to create one manually via {@link ListStageDeploymentsRequest#builder()}
     * </p>
     *
     * @param listStageDeploymentsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListStageDeploymentsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListStageDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStageDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStageDeploymentsIterable listStageDeploymentsPaginator(
            Consumer<ListStageDeploymentsRequest.Builder> listStageDeploymentsRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return listStageDeploymentsPaginator(ListStageDeploymentsRequest.builder().applyMutation(listStageDeploymentsRequest)
                .build());
    }

    /**
     * <p>
     * Gets a paginated list of stage summaries from the game.
     * </p>
     *
     * @param listStagesRequest
     * @return Result of the ListStages operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagesResponse listStages(ListStagesRequest listStagesRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a paginated list of stage summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListStagesRequest#builder()}
     * </p>
     *
     * @param listStagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListStagesRequest.Builder} to create a request.
     * @return Result of the ListStages operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagesResponse listStages(Consumer<ListStagesRequest.Builder> listStagesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return listStages(ListStagesRequest.builder().applyMutation(listStagesRequest).build());
    }

    /**
     * <p>
     * Gets a paginated list of stage summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStages(software.amazon.awssdk.services.gamesparks.model.ListStagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStagesIterable responses = client.listStagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListStagesIterable responses = client.listStagesPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListStagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStagesIterable responses = client.listStagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStages(software.amazon.awssdk.services.gamesparks.model.ListStagesRequest)} operation.</b>
     * </p>
     *
     * @param listStagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagesIterable listStagesPaginator(ListStagesRequest listStagesRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return new ListStagesIterable(this, listStagesRequest);
    }

    /**
     * <p>
     * Gets a paginated list of stage summaries from the game.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listStages(software.amazon.awssdk.services.gamesparks.model.ListStagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStagesIterable responses = client.listStagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.gamesparks.paginators.ListStagesIterable responses = client.listStagesPaginator(request);
     *     for (software.amazon.awssdk.services.gamesparks.model.ListStagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.gamesparks.paginators.ListStagesIterable responses = client.listStagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStages(software.amazon.awssdk.services.gamesparks.model.ListStagesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStagesRequest.Builder} avoiding the need to
     * create one manually via {@link ListStagesRequest#builder()}
     * </p>
     *
     * @param listStagesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListStagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListStages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListStages" target="_top">AWS API
     *      Documentation</a>
     */
    default ListStagesIterable listStagesPaginator(Consumer<ListStagesRequest.Builder> listStagesRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return listStagesPaginator(ListStagesRequest.builder().applyMutation(listStagesRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with a GameSparks resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with a GameSparks resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts an asynchronous process that generates client code for system-defined and custom messages. The resulting
     * code is collected as a .zip file and uploaded to a pre-signed Amazon S3 URL.
     * </p>
     *
     * @param startGeneratedCodeJobRequest
     * @return Result of the StartGeneratedCodeJob operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.StartGeneratedCodeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartGeneratedCodeJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartGeneratedCodeJobResponse startGeneratedCodeJob(StartGeneratedCodeJobRequest startGeneratedCodeJobRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an asynchronous process that generates client code for system-defined and custom messages. The resulting
     * code is collected as a .zip file and uploaded to a pre-signed Amazon S3 URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartGeneratedCodeJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartGeneratedCodeJobRequest#builder()}
     * </p>
     *
     * @param startGeneratedCodeJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.StartGeneratedCodeJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartGeneratedCodeJob operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.StartGeneratedCodeJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartGeneratedCodeJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartGeneratedCodeJobResponse startGeneratedCodeJob(
            Consumer<StartGeneratedCodeJobRequest.Builder> startGeneratedCodeJobRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return startGeneratedCodeJob(StartGeneratedCodeJobRequest.builder().applyMutation(startGeneratedCodeJobRequest).build());
    }

    /**
     * <p>
     * Deploys a snapshot to the stage and creates a new game runtime.
     * </p>
     * <p>
     * After you call this operation, you can check the deployment status by using <code>GetStageDeployment</code>.
     * </p>
     * <p>
     * If there are any players connected to the previous game runtime, then both runtimes persist. Existing connections
     * to the previous runtime are maintained. When players disconnect and reconnect, they connect to the new runtime.
     * After there are no connections to the previous game runtime, it is deleted.
     * </p>
     *
     * @param startStageDeploymentRequest
     * @return Result of the StartStageDeployment operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.StartStageDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartStageDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartStageDeploymentResponse startStageDeployment(StartStageDeploymentRequest startStageDeploymentRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deploys a snapshot to the stage and creates a new game runtime.
     * </p>
     * <p>
     * After you call this operation, you can check the deployment status by using <code>GetStageDeployment</code>.
     * </p>
     * <p>
     * If there are any players connected to the previous game runtime, then both runtimes persist. Existing connections
     * to the previous runtime are maintained. When players disconnect and reconnect, they connect to the new runtime.
     * After there are no connections to the previous game runtime, it is deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartStageDeploymentRequest.Builder} avoiding the
     * need to create one manually via {@link StartStageDeploymentRequest#builder()}
     * </p>
     *
     * @param startStageDeploymentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.StartStageDeploymentRequest.Builder} to create a
     *        request.
     * @return Result of the StartStageDeployment operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ConflictException
     *         The resource already exists, or another operation is in progress.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.StartStageDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/StartStageDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    default StartStageDeploymentResponse startStageDeployment(
            Consumer<StartStageDeploymentRequest.Builder> startStageDeploymentRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ConflictException, ResourceNotFoundException, InternalServerException,
            AwsServiceException, SdkClientException, GameSparksException {
        return startStageDeployment(StartStageDeploymentRequest.builder().applyMutation(startStageDeploymentRequest).build());
    }

    /**
     * <p>
     * Adds tags to a GameSparks resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a GameSparks resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a GameSparks resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException,
            ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a GameSparks resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ValidationException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates details of the game.
     * </p>
     *
     * @param updateGameRequest
     * @return Result of the UpdateGame operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.UpdateGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGame" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGameResponse updateGame(UpdateGameRequest updateGameRequest) throws ValidationException, AccessDeniedException,
            ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException, SdkClientException,
            GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates details of the game.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGameRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGameRequest#builder()}
     * </p>
     *
     * @param updateGameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.UpdateGameRequest.Builder} to create a request.
     * @return Result of the UpdateGame operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.UpdateGame
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGame" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGameResponse updateGame(Consumer<UpdateGameRequest.Builder> updateGameRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return updateGame(UpdateGameRequest.builder().applyMutation(updateGameRequest).build());
    }

    /**
     * <p>
     * Updates one or more sections of the game configuration.
     * </p>
     *
     * @param updateGameConfigurationRequest
     * @return Result of the UpdateGameConfiguration operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws ServiceQuotaExceededException
     *         The request would result in exceeding service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.UpdateGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGameConfigurationResponse updateGameConfiguration(UpdateGameConfigurationRequest updateGameConfigurationRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates one or more sections of the game configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGameConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateGameConfigurationRequest#builder()}
     * </p>
     *
     * @param updateGameConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.UpdateGameConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateGameConfiguration operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws ServiceQuotaExceededException
     *         The request would result in exceeding service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.UpdateGameConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateGameConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateGameConfigurationResponse updateGameConfiguration(
            Consumer<UpdateGameConfigurationRequest.Builder> updateGameConfigurationRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, GameSparksException {
        return updateGameConfiguration(UpdateGameConfigurationRequest.builder().applyMutation(updateGameConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Updates the metadata of a GameSparks snapshot.
     * </p>
     *
     * @param updateSnapshotRequest
     * @return Result of the UpdateSnapshot operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSnapshotResponse updateSnapshot(UpdateSnapshotRequest updateSnapshotRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the metadata of a GameSparks snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSnapshotRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateSnapshotRequest#builder()}
     * </p>
     *
     * @param updateSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.UpdateSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSnapshot operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.UpdateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateSnapshotResponse updateSnapshot(Consumer<UpdateSnapshotRequest.Builder> updateSnapshotRequest)
            throws ValidationException, AccessDeniedException, ThrottlingException, ResourceNotFoundException,
            InternalServerException, AwsServiceException, SdkClientException, GameSparksException {
        return updateSnapshot(UpdateSnapshotRequest.builder().applyMutation(updateSnapshotRequest).build());
    }

    /**
     * <p>
     * Updates the metadata of a stage.
     * </p>
     *
     * @param updateStageRequest
     * @return Result of the UpdateStage operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.UpdateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStageResponse updateStage(UpdateStageRequest updateStageRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the metadata of a stage.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStageRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStageRequest#builder()}
     * </p>
     *
     * @param updateStageRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.gamesparks.model.UpdateStageRequest.Builder} to create a request.
     * @return Result of the UpdateStage operation returned by the service.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ResourceNotFoundException
     *         The resource specified in the request does not exist.
     * @throws InternalServerException
     *         The service encountered an internal error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws GameSparksException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample GameSparksClient.UpdateStage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/gamesparks-2021-08-17/UpdateStage" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStageResponse updateStage(Consumer<UpdateStageRequest.Builder> updateStageRequest) throws ValidationException,
            AccessDeniedException, ThrottlingException, ResourceNotFoundException, InternalServerException, AwsServiceException,
            SdkClientException, GameSparksException {
        return updateStage(UpdateStageRequest.builder().applyMutation(updateStageRequest).build());
    }

    /**
     * Create a {@link GameSparksClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static GameSparksClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link GameSparksClient}.
     */
    static GameSparksClientBuilder builder() {
        return new DefaultGameSparksClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default GameSparksServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
