/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.gamesparks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A single modification to the configuration section.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SectionModification implements SdkPojo, Serializable,
        ToCopyableBuilder<SectionModification.Builder, SectionModification> {
    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(SectionModification::operationAsString)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(SectionModification::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> SECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Section")
            .getter(getter(SectionModification::section)).setter(setter(Builder::section))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Section").build()).build();

    private static final SdkField<Document> VALUE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("Value").getter(getter(SectionModification::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_FIELD, PATH_FIELD,
            SECTION_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String operation;

    private final String path;

    private final String section;

    private final Document value;

    private SectionModification(BuilderImpl builder) {
        this.operation = builder.operation;
        this.path = builder.path;
        this.section = builder.section;
        this.value = builder.value;
    }

    /**
     * <p>
     * The operation to be performed on a configuration section.
     * </p>
     * <p>
     * Content can be added, deleted, or replaced within a section.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link Operation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationAsString}.
     * </p>
     * 
     * @return The operation to be performed on a configuration section.</p>
     *         <p>
     *         Content can be added, deleted, or replaced within a section.
     * @see Operation
     */
    public final Operation operation() {
        return Operation.fromValue(operation);
    }

    /**
     * <p>
     * The operation to be performed on a configuration section.
     * </p>
     * <p>
     * Content can be added, deleted, or replaced within a section.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link Operation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #operationAsString}.
     * </p>
     * 
     * @return The operation to be performed on a configuration section.</p>
     *         <p>
     *         Content can be added, deleted, or replaced within a section.
     * @see Operation
     */
    public final String operationAsString() {
        return operation;
    }

    /**
     * <p>
     * The path within the section content to be modified.
     * </p>
     * 
     * @return The path within the section content to be modified.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The name of the section to be modified.
     * </p>
     * 
     * @return The name of the section to be modified.
     */
    public final String section() {
        return section;
    }

    /**
     * <p>
     * For add and replace operations, this is the value that will be used.
     * </p>
     * <p>
     * This field should be omitted for delete operations.
     * </p>
     * 
     * @return For add and replace operations, this is the value that will be used.</p>
     *         <p>
     *         This field should be omitted for delete operations.
     */
    public final Document value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(section());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SectionModification)) {
            return false;
        }
        SectionModification other = (SectionModification) obj;
        return Objects.equals(operationAsString(), other.operationAsString()) && Objects.equals(path(), other.path())
                && Objects.equals(section(), other.section()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SectionModification").add("Operation", operationAsString()).add("Path", path())
                .add("Section", section()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Operation":
            return Optional.ofNullable(clazz.cast(operationAsString()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Section":
            return Optional.ofNullable(clazz.cast(section()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SectionModification, T> g) {
        return obj -> g.apply((SectionModification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SectionModification> {
        /**
         * <p>
         * The operation to be performed on a configuration section.
         * </p>
         * <p>
         * Content can be added, deleted, or replaced within a section.
         * </p>
         * 
         * @param operation
         *        The operation to be performed on a configuration section.</p>
         *        <p>
         *        Content can be added, deleted, or replaced within a section.
         * @see Operation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operation
         */
        Builder operation(String operation);

        /**
         * <p>
         * The operation to be performed on a configuration section.
         * </p>
         * <p>
         * Content can be added, deleted, or replaced within a section.
         * </p>
         * 
         * @param operation
         *        The operation to be performed on a configuration section.</p>
         *        <p>
         *        Content can be added, deleted, or replaced within a section.
         * @see Operation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Operation
         */
        Builder operation(Operation operation);

        /**
         * <p>
         * The path within the section content to be modified.
         * </p>
         * 
         * @param path
         *        The path within the section content to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The name of the section to be modified.
         * </p>
         * 
         * @param section
         *        The name of the section to be modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder section(String section);

        /**
         * <p>
         * For add and replace operations, this is the value that will be used.
         * </p>
         * <p>
         * This field should be omitted for delete operations.
         * </p>
         * 
         * @param value
         *        For add and replace operations, this is the value that will be used.</p>
         *        <p>
         *        This field should be omitted for delete operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Document value);
    }

    static final class BuilderImpl implements Builder {
        private String operation;

        private String path;

        private String section;

        private Document value;

        private BuilderImpl() {
        }

        private BuilderImpl(SectionModification model) {
            operation(model.operation);
            path(model.path);
            section(model.section);
            value(model.value);
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(Operation operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getSection() {
            return section;
        }

        public final void setSection(String section) {
            this.section = section;
        }

        @Override
        public final Builder section(String section) {
            this.section = section;
            return this;
        }

        public final Document getValue() {
            return value;
        }

        public final void setValue(Document value) {
            this.value = value;
        }

        @Override
        public final Builder value(Document value) {
            this.value = value;
            return this;
        }

        @Override
        public SectionModification build() {
            return new SectionModification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
