/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.gamesparks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.gamesparks.GameSparksAsyncClient;
import software.amazon.awssdk.services.gamesparks.internal.UserAgentUtils;
import software.amazon.awssdk.services.gamesparks.model.GeneratedCodeJobDetails;
import software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsRequest;
import software.amazon.awssdk.services.gamesparks.model.ListGeneratedCodeJobsResponse;

public class ListGeneratedCodeJobsPublisher
implements SdkPublisher<ListGeneratedCodeJobsResponse> {
    private final GameSparksAsyncClient client;
    private final ListGeneratedCodeJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGeneratedCodeJobsPublisher(GameSparksAsyncClient client, ListGeneratedCodeJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGeneratedCodeJobsPublisher(GameSparksAsyncClient client, ListGeneratedCodeJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGeneratedCodeJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGeneratedCodeJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GeneratedCodeJobDetails> generatedCodeJobs() {
        Function<ListGeneratedCodeJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.generatedCodeJobs() != null) {
                return response.generatedCodeJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGeneratedCodeJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGeneratedCodeJobsResponseFetcher
    implements AsyncPageFetcher<ListGeneratedCodeJobsResponse> {
        private ListGeneratedCodeJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListGeneratedCodeJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGeneratedCodeJobsResponse> nextPage(ListGeneratedCodeJobsResponse previousPage) {
            if (previousPage == null) {
                return ListGeneratedCodeJobsPublisher.this.client.listGeneratedCodeJobs(ListGeneratedCodeJobsPublisher.this.firstRequest);
            }
            return ListGeneratedCodeJobsPublisher.this.client.listGeneratedCodeJobs((ListGeneratedCodeJobsRequest)((Object)ListGeneratedCodeJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

