/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CompactionStrategy {
    BINPACK("binpack"),
    SORT("sort"),
    Z_ORDER("z-order"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CompactionStrategy> VALUE_MAP;
    private final String value;

    private CompactionStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CompactionStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CompactionStrategy> knownValues() {
        EnumSet<CompactionStrategy> knownValues = EnumSet.allOf(CompactionStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CompactionStrategy.class, CompactionStrategy::toString);
    }
}

