/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.StringToStringMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergEncryptedKey
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergEncryptedKey> {
    private static final SdkField<String> KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyId").getter(IcebergEncryptedKey.getter(IcebergEncryptedKey::keyId)).setter(IcebergEncryptedKey.setter(Builder::keyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyId").build()}).build();
    private static final SdkField<String> ENCRYPTED_KEY_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptedKeyMetadata").getter(IcebergEncryptedKey.getter(IcebergEncryptedKey::encryptedKeyMetadata)).setter(IcebergEncryptedKey.setter(Builder::encryptedKeyMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedKeyMetadata").build()}).build();
    private static final SdkField<String> ENCRYPTED_BY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptedById").getter(IcebergEncryptedKey.getter(IcebergEncryptedKey::encryptedById)).setter(IcebergEncryptedKey.setter(Builder::encryptedById)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedById").build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Properties").getter(IcebergEncryptedKey.getter(IcebergEncryptedKey::properties)).setter(IcebergEncryptedKey.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ID_FIELD, ENCRYPTED_KEY_METADATA_FIELD, ENCRYPTED_BY_ID_FIELD, PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IcebergEncryptedKey.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String keyId;
    private final String encryptedKeyMetadata;
    private final String encryptedById;
    private final Map<String, String> properties;

    private IcebergEncryptedKey(BuilderImpl builder) {
        this.keyId = builder.keyId;
        this.encryptedKeyMetadata = builder.encryptedKeyMetadata;
        this.encryptedById = builder.encryptedById;
        this.properties = builder.properties;
    }

    public final String keyId() {
        return this.keyId;
    }

    public final String encryptedKeyMetadata() {
        return this.encryptedKeyMetadata;
    }

    public final String encryptedById() {
        return this.encryptedById;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptedKeyMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptedById());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergEncryptedKey)) {
            return false;
        }
        IcebergEncryptedKey other = (IcebergEncryptedKey)obj;
        return Objects.equals(this.keyId(), other.keyId()) && Objects.equals(this.encryptedKeyMetadata(), other.encryptedKeyMetadata()) && Objects.equals(this.encryptedById(), other.encryptedById()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergEncryptedKey").add("KeyId", (Object)this.keyId()).add("EncryptedKeyMetadata", (Object)this.encryptedKeyMetadata()).add("EncryptedById", (Object)this.encryptedById()).add("Properties", this.hasProperties() ? this.properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyId": {
                return Optional.ofNullable(clazz.cast(this.keyId()));
            }
            case "EncryptedKeyMetadata": {
                return Optional.ofNullable(clazz.cast(this.encryptedKeyMetadata()));
            }
            case "EncryptedById": {
                return Optional.ofNullable(clazz.cast(this.encryptedById()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("KeyId", KEY_ID_FIELD);
        map.put("EncryptedKeyMetadata", ENCRYPTED_KEY_METADATA_FIELD);
        map.put("EncryptedById", ENCRYPTED_BY_ID_FIELD);
        map.put("Properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IcebergEncryptedKey, T> g) {
        return obj -> g.apply((IcebergEncryptedKey)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String keyId;
        private String encryptedKeyMetadata;
        private String encryptedById;
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergEncryptedKey model) {
            this.keyId(model.keyId);
            this.encryptedKeyMetadata(model.encryptedKeyMetadata);
            this.encryptedById(model.encryptedById);
            this.properties(model.properties);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public final Builder keyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public final String getEncryptedKeyMetadata() {
            return this.encryptedKeyMetadata;
        }

        public final void setEncryptedKeyMetadata(String encryptedKeyMetadata) {
            this.encryptedKeyMetadata = encryptedKeyMetadata;
        }

        @Override
        public final Builder encryptedKeyMetadata(String encryptedKeyMetadata) {
            this.encryptedKeyMetadata = encryptedKeyMetadata;
            return this;
        }

        public final String getEncryptedById() {
            return this.encryptedById;
        }

        public final void setEncryptedById(String encryptedById) {
            this.encryptedById = encryptedById;
        }

        @Override
        public final Builder encryptedById(String encryptedById) {
            this.encryptedById = encryptedById;
            return this;
        }

        public final Map<String, String> getProperties() {
            if (this.properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = StringToStringMapCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = StringToStringMapCopier.copy(properties);
            return this;
        }

        public IcebergEncryptedKey build() {
            return new IcebergEncryptedKey(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergEncryptedKey> {
        public Builder keyId(String var1);

        public Builder encryptedKeyMetadata(String var1);

        public Builder encryptedById(String var1);

        public Builder properties(Map<String, String> var1);
    }
}

