/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.ColumnNameListCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartColumnStatisticsTaskRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, StartColumnStatisticsTaskRunRequest> {
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(StartColumnStatisticsTaskRunRequest.getter(StartColumnStatisticsTaskRunRequest::databaseName)).setter(StartColumnStatisticsTaskRunRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(StartColumnStatisticsTaskRunRequest.getter(StartColumnStatisticsTaskRunRequest::tableName)).setter(StartColumnStatisticsTaskRunRequest.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<List<String>> COLUMN_NAME_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ColumnNameList").getter(StartColumnStatisticsTaskRunRequest.getter(StartColumnStatisticsTaskRunRequest::columnNameList)).setter(StartColumnStatisticsTaskRunRequest.setter(Builder::columnNameList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNameList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Role").getter(StartColumnStatisticsTaskRunRequest.getter(StartColumnStatisticsTaskRunRequest::role)).setter(StartColumnStatisticsTaskRunRequest.setter(Builder::role)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()}).build();
    private static final SdkField<Double> SAMPLE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("SampleSize").getter(StartColumnStatisticsTaskRunRequest.getter(StartColumnStatisticsTaskRunRequest::sampleSize)).setter(StartColumnStatisticsTaskRunRequest.setter(Builder::sampleSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleSize").build()}).build();
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogID").getter(StartColumnStatisticsTaskRunRequest.getter(StartColumnStatisticsTaskRunRequest::catalogID)).setter(StartColumnStatisticsTaskRunRequest.setter(Builder::catalogID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogID").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(StartColumnStatisticsTaskRunRequest.getter(StartColumnStatisticsTaskRunRequest::securityConfiguration)).setter(StartColumnStatisticsTaskRunRequest.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_NAME_FIELD, TABLE_NAME_FIELD, COLUMN_NAME_LIST_FIELD, ROLE_FIELD, SAMPLE_SIZE_FIELD, CATALOG_ID_FIELD, SECURITY_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartColumnStatisticsTaskRunRequest.memberNameToFieldInitializer();
    private final String databaseName;
    private final String tableName;
    private final List<String> columnNameList;
    private final String role;
    private final Double sampleSize;
    private final String catalogID;
    private final String securityConfiguration;

    private StartColumnStatisticsTaskRunRequest(BuilderImpl builder) {
        super(builder);
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.columnNameList = builder.columnNameList;
        this.role = builder.role;
        this.sampleSize = builder.sampleSize;
        this.catalogID = builder.catalogID;
        this.securityConfiguration = builder.securityConfiguration;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final boolean hasColumnNameList() {
        return this.columnNameList != null && !(this.columnNameList instanceof SdkAutoConstructList);
    }

    public final List<String> columnNameList() {
        return this.columnNameList;
    }

    public final String role() {
        return this.role;
    }

    public final Double sampleSize() {
        return this.sampleSize;
    }

    public final String catalogID() {
        return this.catalogID;
    }

    public final String securityConfiguration() {
        return this.securityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColumnNameList() ? this.columnNameList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.role());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogID());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartColumnStatisticsTaskRunRequest)) {
            return false;
        }
        StartColumnStatisticsTaskRunRequest other = (StartColumnStatisticsTaskRunRequest)((Object)obj);
        return Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && this.hasColumnNameList() == other.hasColumnNameList() && Objects.equals(this.columnNameList(), other.columnNameList()) && Objects.equals(this.role(), other.role()) && Objects.equals(this.sampleSize(), other.sampleSize()) && Objects.equals(this.catalogID(), other.catalogID()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StartColumnStatisticsTaskRunRequest").add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("ColumnNameList", this.hasColumnNameList() ? this.columnNameList() : null).add("Role", (Object)this.role()).add("SampleSize", (Object)this.sampleSize()).add("CatalogID", (Object)this.catalogID()).add("SecurityConfiguration", (Object)this.securityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "ColumnNameList": {
                return Optional.ofNullable(clazz.cast(this.columnNameList()));
            }
            case "Role": {
                return Optional.ofNullable(clazz.cast(this.role()));
            }
            case "SampleSize": {
                return Optional.ofNullable(clazz.cast(this.sampleSize()));
            }
            case "CatalogID": {
                return Optional.ofNullable(clazz.cast(this.catalogID()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DatabaseName", DATABASE_NAME_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("ColumnNameList", COLUMN_NAME_LIST_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("SampleSize", SAMPLE_SIZE_FIELD);
        map.put("CatalogID", CATALOG_ID_FIELD);
        map.put("SecurityConfiguration", SECURITY_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartColumnStatisticsTaskRunRequest, T> g) {
        return obj -> g.apply((StartColumnStatisticsTaskRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String databaseName;
        private String tableName;
        private List<String> columnNameList = DefaultSdkAutoConstructList.getInstance();
        private String role;
        private Double sampleSize;
        private String catalogID;
        private String securityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartColumnStatisticsTaskRunRequest model) {
            super(model);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.columnNameList(model.columnNameList);
            this.role(model.role);
            this.sampleSize(model.sampleSize);
            this.catalogID(model.catalogID);
            this.securityConfiguration(model.securityConfiguration);
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final Collection<String> getColumnNameList() {
            if (this.columnNameList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.columnNameList;
        }

        public final void setColumnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
        }

        @Override
        public final Builder columnNameList(Collection<String> columnNameList) {
            this.columnNameList = ColumnNameListCopier.copy(columnNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnNameList(String ... columnNameList) {
            this.columnNameList(Arrays.asList(columnNameList));
            return this;
        }

        public final String getRole() {
            return this.role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Double getSampleSize() {
            return this.sampleSize;
        }

        public final void setSampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Double sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final String getCatalogID() {
            return this.catalogID;
        }

        public final void setCatalogID(String catalogID) {
            this.catalogID = catalogID;
        }

        @Override
        public final Builder catalogID(String catalogID) {
            this.catalogID = catalogID;
            return this;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartColumnStatisticsTaskRunRequest build() {
            return new StartColumnStatisticsTaskRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartColumnStatisticsTaskRunRequest> {
        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder columnNameList(Collection<String> var1);

        public Builder columnNameList(String ... var1);

        public Builder role(String var1);

        public Builder sampleSize(Double var1);

        public Builder catalogID(String var1);

        public Builder securityConfiguration(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

