/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.GrafanaResponse;
import software.amazon.awssdk.services.grafana.model.WorkspaceListCopier;
import software.amazon.awssdk.services.grafana.model.WorkspaceSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListWorkspacesResponse
extends GrafanaResponse
implements ToCopyableBuilder<Builder, ListWorkspacesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListWorkspacesResponse.getter(ListWorkspacesResponse::nextToken)).setter(ListWorkspacesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<WorkspaceSummary>> WORKSPACES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("workspaces").getter(ListWorkspacesResponse.getter(ListWorkspacesResponse::workspaces)).setter(ListWorkspacesResponse.setter(Builder::workspaces)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workspaces").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkspaceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, WORKSPACES_FIELD));
    private final String nextToken;
    private final List<WorkspaceSummary> workspaces;

    private ListWorkspacesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.workspaces = builder.workspaces;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasWorkspaces() {
        return this.workspaces != null && !(this.workspaces instanceof SdkAutoConstructList);
    }

    public final List<WorkspaceSummary> workspaces() {
        return this.workspaces;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWorkspaces() ? this.workspaces() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkspacesResponse)) {
            return false;
        }
        ListWorkspacesResponse other = (ListWorkspacesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasWorkspaces() == other.hasWorkspaces() && Objects.equals(this.workspaces(), other.workspaces());
    }

    public final String toString() {
        return ToString.builder((String)"ListWorkspacesResponse").add("NextToken", (Object)this.nextToken()).add("Workspaces", this.hasWorkspaces() ? this.workspaces() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "workspaces": {
                return Optional.ofNullable(clazz.cast(this.workspaces()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkspacesResponse, T> g) {
        return obj -> g.apply((ListWorkspacesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GrafanaResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<WorkspaceSummary> workspaces = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkspacesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.workspaces(model.workspaces);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<WorkspaceSummary.Builder> getWorkspaces() {
            List<WorkspaceSummary.Builder> result = WorkspaceListCopier.copyToBuilder(this.workspaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkspaces(Collection<WorkspaceSummary.BuilderImpl> workspaces) {
            this.workspaces = WorkspaceListCopier.copyFromBuilder(workspaces);
        }

        @Override
        public final Builder workspaces(Collection<WorkspaceSummary> workspaces) {
            this.workspaces = WorkspaceListCopier.copy(workspaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(WorkspaceSummary ... workspaces) {
            this.workspaces(Arrays.asList(workspaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workspaces(Consumer<WorkspaceSummary.Builder> ... workspaces) {
            this.workspaces(Stream.of(workspaces).map(c -> (WorkspaceSummary)((WorkspaceSummary.Builder)WorkspaceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWorkspacesResponse build() {
            return new ListWorkspacesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GrafanaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListWorkspacesResponse> {
        public Builder nextToken(String var1);

        public Builder workspaces(Collection<WorkspaceSummary> var1);

        public Builder workspaces(WorkspaceSummary ... var1);

        public Builder workspaces(Consumer<WorkspaceSummary.Builder> ... var1);
    }
}

