/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.grafana.model.AllowedOrganizationsCopier;
import software.amazon.awssdk.services.grafana.model.AssertionAttributes;
import software.amazon.awssdk.services.grafana.model.IdpMetadata;
import software.amazon.awssdk.services.grafana.model.RoleValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SamlConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SamlConfiguration> {
    private static final SdkField<List<String>> ALLOWED_ORGANIZATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedOrganizations").getter(SamlConfiguration.getter(SamlConfiguration::allowedOrganizations)).setter(SamlConfiguration.setter(Builder::allowedOrganizations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedOrganizations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AssertionAttributes> ASSERTION_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assertionAttributes").getter(SamlConfiguration.getter(SamlConfiguration::assertionAttributes)).setter(SamlConfiguration.setter(Builder::assertionAttributes)).constructor(AssertionAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assertionAttributes").build()}).build();
    private static final SdkField<IdpMetadata> IDP_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("idpMetadata").getter(SamlConfiguration.getter(SamlConfiguration::idpMetadata)).setter(SamlConfiguration.setter(Builder::idpMetadata)).constructor(IdpMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idpMetadata").build()}).build();
    private static final SdkField<Integer> LOGIN_VALIDITY_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("loginValidityDuration").getter(SamlConfiguration.getter(SamlConfiguration::loginValidityDuration)).setter(SamlConfiguration.setter(Builder::loginValidityDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loginValidityDuration").build()}).build();
    private static final SdkField<RoleValues> ROLE_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("roleValues").getter(SamlConfiguration.getter(SamlConfiguration::roleValues)).setter(SamlConfiguration.setter(Builder::roleValues)).constructor(RoleValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_ORGANIZATIONS_FIELD, ASSERTION_ATTRIBUTES_FIELD, IDP_METADATA_FIELD, LOGIN_VALIDITY_DURATION_FIELD, ROLE_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SamlConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> allowedOrganizations;
    private final AssertionAttributes assertionAttributes;
    private final IdpMetadata idpMetadata;
    private final Integer loginValidityDuration;
    private final RoleValues roleValues;

    private SamlConfiguration(BuilderImpl builder) {
        this.allowedOrganizations = builder.allowedOrganizations;
        this.assertionAttributes = builder.assertionAttributes;
        this.idpMetadata = builder.idpMetadata;
        this.loginValidityDuration = builder.loginValidityDuration;
        this.roleValues = builder.roleValues;
    }

    public final boolean hasAllowedOrganizations() {
        return this.allowedOrganizations != null && !(this.allowedOrganizations instanceof SdkAutoConstructList);
    }

    public final List<String> allowedOrganizations() {
        return this.allowedOrganizations;
    }

    public final AssertionAttributes assertionAttributes() {
        return this.assertionAttributes;
    }

    public final IdpMetadata idpMetadata() {
        return this.idpMetadata;
    }

    public final Integer loginValidityDuration() {
        return this.loginValidityDuration;
    }

    public final RoleValues roleValues() {
        return this.roleValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedOrganizations() ? this.allowedOrganizations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assertionAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.idpMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.loginValidityDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleValues());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamlConfiguration)) {
            return false;
        }
        SamlConfiguration other = (SamlConfiguration)obj;
        return this.hasAllowedOrganizations() == other.hasAllowedOrganizations() && Objects.equals(this.allowedOrganizations(), other.allowedOrganizations()) && Objects.equals(this.assertionAttributes(), other.assertionAttributes()) && Objects.equals(this.idpMetadata(), other.idpMetadata()) && Objects.equals(this.loginValidityDuration(), other.loginValidityDuration()) && Objects.equals(this.roleValues(), other.roleValues());
    }

    public final String toString() {
        return ToString.builder((String)"SamlConfiguration").add("AllowedOrganizations", this.hasAllowedOrganizations() ? this.allowedOrganizations() : null).add("AssertionAttributes", (Object)this.assertionAttributes()).add("IdpMetadata", (Object)this.idpMetadata()).add("LoginValidityDuration", (Object)this.loginValidityDuration()).add("RoleValues", (Object)this.roleValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowedOrganizations": {
                return Optional.ofNullable(clazz.cast(this.allowedOrganizations()));
            }
            case "assertionAttributes": {
                return Optional.ofNullable(clazz.cast(this.assertionAttributes()));
            }
            case "idpMetadata": {
                return Optional.ofNullable(clazz.cast(this.idpMetadata()));
            }
            case "loginValidityDuration": {
                return Optional.ofNullable(clazz.cast(this.loginValidityDuration()));
            }
            case "roleValues": {
                return Optional.ofNullable(clazz.cast(this.roleValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowedOrganizations", ALLOWED_ORGANIZATIONS_FIELD);
        map.put("assertionAttributes", ASSERTION_ATTRIBUTES_FIELD);
        map.put("idpMetadata", IDP_METADATA_FIELD);
        map.put("loginValidityDuration", LOGIN_VALIDITY_DURATION_FIELD);
        map.put("roleValues", ROLE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamlConfiguration, T> g) {
        return obj -> g.apply((SamlConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> allowedOrganizations = DefaultSdkAutoConstructList.getInstance();
        private AssertionAttributes assertionAttributes;
        private IdpMetadata idpMetadata;
        private Integer loginValidityDuration;
        private RoleValues roleValues;

        private BuilderImpl() {
        }

        private BuilderImpl(SamlConfiguration model) {
            this.allowedOrganizations(model.allowedOrganizations);
            this.assertionAttributes(model.assertionAttributes);
            this.idpMetadata(model.idpMetadata);
            this.loginValidityDuration(model.loginValidityDuration);
            this.roleValues(model.roleValues);
        }

        public final Collection<String> getAllowedOrganizations() {
            if (this.allowedOrganizations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedOrganizations;
        }

        public final void setAllowedOrganizations(Collection<String> allowedOrganizations) {
            this.allowedOrganizations = AllowedOrganizationsCopier.copy(allowedOrganizations);
        }

        @Override
        public final Builder allowedOrganizations(Collection<String> allowedOrganizations) {
            this.allowedOrganizations = AllowedOrganizationsCopier.copy(allowedOrganizations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedOrganizations(String ... allowedOrganizations) {
            this.allowedOrganizations(Arrays.asList(allowedOrganizations));
            return this;
        }

        public final AssertionAttributes.Builder getAssertionAttributes() {
            return this.assertionAttributes != null ? this.assertionAttributes.toBuilder() : null;
        }

        public final void setAssertionAttributes(AssertionAttributes.BuilderImpl assertionAttributes) {
            this.assertionAttributes = assertionAttributes != null ? assertionAttributes.build() : null;
        }

        @Override
        public final Builder assertionAttributes(AssertionAttributes assertionAttributes) {
            this.assertionAttributes = assertionAttributes;
            return this;
        }

        public final IdpMetadata.Builder getIdpMetadata() {
            return this.idpMetadata != null ? this.idpMetadata.toBuilder() : null;
        }

        public final void setIdpMetadata(IdpMetadata.BuilderImpl idpMetadata) {
            this.idpMetadata = idpMetadata != null ? idpMetadata.build() : null;
        }

        @Override
        public final Builder idpMetadata(IdpMetadata idpMetadata) {
            this.idpMetadata = idpMetadata;
            return this;
        }

        public final Integer getLoginValidityDuration() {
            return this.loginValidityDuration;
        }

        public final void setLoginValidityDuration(Integer loginValidityDuration) {
            this.loginValidityDuration = loginValidityDuration;
        }

        @Override
        public final Builder loginValidityDuration(Integer loginValidityDuration) {
            this.loginValidityDuration = loginValidityDuration;
            return this;
        }

        public final RoleValues.Builder getRoleValues() {
            return this.roleValues != null ? this.roleValues.toBuilder() : null;
        }

        public final void setRoleValues(RoleValues.BuilderImpl roleValues) {
            this.roleValues = roleValues != null ? roleValues.build() : null;
        }

        @Override
        public final Builder roleValues(RoleValues roleValues) {
            this.roleValues = roleValues;
            return this;
        }

        public SamlConfiguration build() {
            return new SamlConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SamlConfiguration> {
        public Builder allowedOrganizations(Collection<String> var1);

        public Builder allowedOrganizations(String ... var1);

        public Builder assertionAttributes(AssertionAttributes var1);

        default public Builder assertionAttributes(Consumer<AssertionAttributes.Builder> assertionAttributes) {
            return this.assertionAttributes((AssertionAttributes)((AssertionAttributes.Builder)AssertionAttributes.builder().applyMutation(assertionAttributes)).build());
        }

        public Builder idpMetadata(IdpMetadata var1);

        default public Builder idpMetadata(Consumer<IdpMetadata.Builder> idpMetadata) {
            return this.idpMetadata((IdpMetadata)((IdpMetadata.Builder)IdpMetadata.builder().applyMutation(idpMetadata)).build());
        }

        public Builder loginValidityDuration(Integer var1);

        public Builder roleValues(RoleValues var1);

        default public Builder roleValues(Consumer<RoleValues.Builder> roleValues) {
            return this.roleValues((RoleValues)((RoleValues.Builder)RoleValues.builder().applyMutation(roleValues)).build());
        }
    }
}

