/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.grafana.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.grafana.GrafanaAsyncClient;
import software.amazon.awssdk.services.grafana.internal.UserAgentUtils;
import software.amazon.awssdk.services.grafana.model.ListWorkspaceServiceAccountsRequest;
import software.amazon.awssdk.services.grafana.model.ListWorkspaceServiceAccountsResponse;
import software.amazon.awssdk.services.grafana.model.ServiceAccountSummary;

public class ListWorkspaceServiceAccountsPublisher
implements SdkPublisher<ListWorkspaceServiceAccountsResponse> {
    private final GrafanaAsyncClient client;
    private final ListWorkspaceServiceAccountsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkspaceServiceAccountsPublisher(GrafanaAsyncClient client, ListWorkspaceServiceAccountsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkspaceServiceAccountsPublisher(GrafanaAsyncClient client, ListWorkspaceServiceAccountsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkspaceServiceAccountsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkspaceServiceAccountsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ServiceAccountSummary> serviceAccounts() {
        Function<ListWorkspaceServiceAccountsResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceAccounts() != null) {
                return response.serviceAccounts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkspaceServiceAccountsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkspaceServiceAccountsResponseFetcher
    implements AsyncPageFetcher<ListWorkspaceServiceAccountsResponse> {
        private ListWorkspaceServiceAccountsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkspaceServiceAccountsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkspaceServiceAccountsResponse> nextPage(ListWorkspaceServiceAccountsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkspaceServiceAccountsPublisher.this.client.listWorkspaceServiceAccounts(ListWorkspaceServiceAccountsPublisher.this.firstRequest);
            }
            return ListWorkspaceServiceAccountsPublisher.this.client.listWorkspaceServiceAccounts((ListWorkspaceServiceAccountsRequest)((Object)ListWorkspaceServiceAccountsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

