/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.greengrass.model.AssociateRoleToGroupRequest;
import software.amazon.awssdk.services.greengrass.model.AssociateRoleToGroupResponse;
import software.amazon.awssdk.services.greengrass.model.AssociateServiceRoleToAccountRequest;
import software.amazon.awssdk.services.greengrass.model.AssociateServiceRoleToAccountResponse;
import software.amazon.awssdk.services.greengrass.model.BadRequestException;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateConnectorDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateCoreDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateDeviceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateFunctionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupCertificateAuthorityRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupCertificateAuthorityResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupResponse;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateGroupVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateLoggerDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateResourceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSoftwareUpdateJobResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.CreateSubscriptionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteGroupRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteGroupResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DeleteSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.DeleteSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.DisassociateRoleFromGroupRequest;
import software.amazon.awssdk.services.greengrass.model.DisassociateRoleFromGroupResponse;
import software.amazon.awssdk.services.greengrass.model.DisassociateServiceRoleFromAccountRequest;
import software.amazon.awssdk.services.greengrass.model.DisassociateServiceRoleFromAccountResponse;
import software.amazon.awssdk.services.greengrass.model.GetAssociatedRoleRequest;
import software.amazon.awssdk.services.greengrass.model.GetAssociatedRoleResponse;
import software.amazon.awssdk.services.greengrass.model.GetBulkDeploymentStatusRequest;
import software.amazon.awssdk.services.greengrass.model.GetBulkDeploymentStatusResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetConnectorDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetCoreDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeploymentStatusRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeploymentStatusResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetDeviceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetFunctionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateAuthorityRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateAuthorityResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupCertificateConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupResponse;
import software.amazon.awssdk.services.greengrass.model.GetGroupVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetGroupVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetLoggerDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetResourceDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetServiceRoleForAccountRequest;
import software.amazon.awssdk.services.greengrass.model.GetServiceRoleForAccountResponse;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionVersionRequest;
import software.amazon.awssdk.services.greengrass.model.GetSubscriptionDefinitionVersionResponse;
import software.amazon.awssdk.services.greengrass.model.GetThingRuntimeConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.GetThingRuntimeConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.GreengrassException;
import software.amazon.awssdk.services.greengrass.model.InternalServerErrorException;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentDetailedReportsRequest;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentDetailedReportsResponse;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ListBulkDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListConnectorDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListCoreDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListDeviceDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListFunctionDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupCertificateAuthoritiesRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupCertificateAuthoritiesResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListGroupsRequest;
import software.amazon.awssdk.services.greengrass.model.ListGroupsResponse;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListLoggerDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListResourceDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionVersionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionVersionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionsRequest;
import software.amazon.awssdk.services.greengrass.model.ListSubscriptionDefinitionsResponse;
import software.amazon.awssdk.services.greengrass.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.greengrass.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.greengrass.model.ResetDeploymentsRequest;
import software.amazon.awssdk.services.greengrass.model.ResetDeploymentsResponse;
import software.amazon.awssdk.services.greengrass.model.StartBulkDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.StartBulkDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.StopBulkDeploymentRequest;
import software.amazon.awssdk.services.greengrass.model.StopBulkDeploymentResponse;
import software.amazon.awssdk.services.greengrass.model.TagResourceRequest;
import software.amazon.awssdk.services.greengrass.model.TagResourceResponse;
import software.amazon.awssdk.services.greengrass.model.UntagResourceRequest;
import software.amazon.awssdk.services.greengrass.model.UntagResourceResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectivityInfoRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectivityInfoResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectorDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateConnectorDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateCoreDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateCoreDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateDeviceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateDeviceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateFunctionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateFunctionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupCertificateConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupCertificateConfigurationResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateGroupResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateLoggerDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateLoggerDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateResourceDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateResourceDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateSubscriptionDefinitionRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateSubscriptionDefinitionResponse;
import software.amazon.awssdk.services.greengrass.model.UpdateThingRuntimeConfigurationRequest;
import software.amazon.awssdk.services.greengrass.model.UpdateThingRuntimeConfigurationResponse;
import software.amazon.awssdk.services.greengrass.transform.AssociateRoleToGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.AssociateServiceRoleToAccountRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateConnectorDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateCoreDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateDeploymentRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateDeviceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateFunctionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateGroupCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateGroupVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateLoggerDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateResourceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateSoftwareUpdateJobRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.CreateSubscriptionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DeleteSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DisassociateRoleFromGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.DisassociateServiceRoleFromAccountRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetAssociatedRoleRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetBulkDeploymentStatusRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetConnectivityInfoRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetConnectorDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetCoreDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetDeploymentStatusRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetDeviceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetFunctionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupCertificateAuthorityRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupCertificateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetGroupVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetLoggerDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetResourceDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetServiceRoleForAccountRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetSubscriptionDefinitionVersionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.GetThingRuntimeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListBulkDeploymentDetailedReportsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListBulkDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListConnectorDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListConnectorDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListCoreDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListCoreDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListDeviceDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListDeviceDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListFunctionDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListFunctionDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListGroupCertificateAuthoritiesRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListGroupVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListLoggerDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListLoggerDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListResourceDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListResourceDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListSubscriptionDefinitionVersionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListSubscriptionDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.ResetDeploymentsRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.StartBulkDeploymentRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.StopBulkDeploymentRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateConnectivityInfoRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateConnectorDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateCoreDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateDeviceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateFunctionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateGroupCertificateConfigurationRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateLoggerDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateResourceDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateSubscriptionDefinitionRequestMarshaller;
import software.amazon.awssdk.services.greengrass.transform.UpdateThingRuntimeConfigurationRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link GreengrassAsyncClient}.
 *
 * @see GreengrassAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultGreengrassAsyncClient implements GreengrassAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultGreengrassAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final GreengrassServiceClientConfiguration serviceClientConfiguration;

    protected DefaultGreengrassAsyncClient(GreengrassServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's
     * permissions should allow Greengrass core Lambda functions to perform actions against the cloud.
     *
     * @param associateRoleToGroupRequest
     * @return A Java Future containing the result of the AssociateRoleToGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.AssociateRoleToGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateRoleToGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateRoleToGroupResponse> associateRoleToGroup(
            AssociateRoleToGroupRequest associateRoleToGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateRoleToGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateRoleToGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateRoleToGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateRoleToGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateRoleToGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateRoleToGroupRequest, AssociateRoleToGroupResponse>()
                            .withOperationName("AssociateRoleToGroup")
                            .withMarshaller(new AssociateRoleToGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateRoleToGroupRequest));
            CompletableFuture<AssociateRoleToGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS
     * IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in
     * the policy ''AWSGreengrassResourceAccessRolePolicy''.
     *
     * @param associateServiceRoleToAccountRequest
     * @return A Java Future containing the result of the AssociateServiceRoleToAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.AssociateServiceRoleToAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/AssociateServiceRoleToAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateServiceRoleToAccountResponse> associateServiceRoleToAccount(
            AssociateServiceRoleToAccountRequest associateServiceRoleToAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateServiceRoleToAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateServiceRoleToAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateServiceRoleToAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateServiceRoleToAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateServiceRoleToAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateServiceRoleToAccountRequest, AssociateServiceRoleToAccountResponse>()
                            .withOperationName("AssociateServiceRoleToAccount")
                            .withMarshaller(new AssociateServiceRoleToAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateServiceRoleToAccountRequest));
            CompletableFuture<AssociateServiceRoleToAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a connector definition. You may provide the initial version of the connector definition now or use
     * ''CreateConnectorDefinitionVersion'' at a later time.
     *
     * @param createConnectorDefinitionRequest
     * @return A Java Future containing the result of the CreateConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConnectorDefinitionResponse> createConnectorDefinition(
            CreateConnectorDefinitionRequest createConnectorDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConnectorDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnectorDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateConnectorDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConnectorDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConnectorDefinitionRequest, CreateConnectorDefinitionResponse>()
                            .withOperationName("CreateConnectorDefinition")
                            .withMarshaller(new CreateConnectorDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createConnectorDefinitionRequest));
            CompletableFuture<CreateConnectorDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a connector definition which has already been defined.
     *
     * @param createConnectorDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateConnectorDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateConnectorDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateConnectorDefinitionVersionResponse> createConnectorDefinitionVersion(
            CreateConnectorDefinitionVersionRequest createConnectorDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createConnectorDefinitionVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConnectorDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateConnectorDefinitionVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateConnectorDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateConnectorDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateConnectorDefinitionVersionRequest, CreateConnectorDefinitionVersionResponse>()
                            .withOperationName("CreateConnectorDefinitionVersion")
                            .withMarshaller(new CreateConnectorDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createConnectorDefinitionVersionRequest));
            CompletableFuture<CreateConnectorDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a core definition. You may provide the initial version of the core definition now or use
     * ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.
     *
     * @param createCoreDefinitionRequest
     *        Information needed to create a core definition.
     * @return A Java Future containing the result of the CreateCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCoreDefinitionResponse> createCoreDefinition(
            CreateCoreDefinitionRequest createCoreDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCoreDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCoreDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCoreDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCoreDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCoreDefinitionRequest, CreateCoreDefinitionResponse>()
                            .withOperationName("CreateCoreDefinition")
                            .withMarshaller(new CreateCoreDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCoreDefinitionRequest));
            CompletableFuture<CreateCoreDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly
     * one Greengrass core.
     *
     * @param createCoreDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateCoreDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateCoreDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCoreDefinitionVersionResponse> createCoreDefinitionVersion(
            CreateCoreDefinitionVersionRequest createCoreDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCoreDefinitionVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCoreDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCoreDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCoreDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCoreDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCoreDefinitionVersionRequest, CreateCoreDefinitionVersionResponse>()
                            .withOperationName("CreateCoreDefinitionVersion")
                            .withMarshaller(new CreateCoreDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createCoreDefinitionVersionRequest));
            CompletableFuture<CreateCoreDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token''
     * token and the request parameters.
     *
     * @param createDeploymentRequest
     * @return A Java Future containing the result of the CreateDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeploymentResponse> createDeployment(CreateDeploymentRequest createDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeploymentRequest, CreateDeploymentResponse>()
                            .withOperationName("CreateDeployment")
                            .withMarshaller(new CreateDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDeploymentRequest));
            CompletableFuture<CreateDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a device definition. You may provide the initial version of the device definition now or use
     * ''CreateDeviceDefinitionVersion'' at a later time.
     *
     * @param createDeviceDefinitionRequest
     * @return A Java Future containing the result of the CreateDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeviceDefinitionResponse> createDeviceDefinition(
            CreateDeviceDefinitionRequest createDeviceDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDeviceDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeviceDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeviceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeviceDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeviceDefinitionRequest, CreateDeviceDefinitionResponse>()
                            .withOperationName("CreateDeviceDefinition")
                            .withMarshaller(new CreateDeviceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDeviceDefinitionRequest));
            CompletableFuture<CreateDeviceDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a device definition that has already been defined.
     *
     * @param createDeviceDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateDeviceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateDeviceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDeviceDefinitionVersionResponse> createDeviceDefinitionVersion(
            CreateDeviceDefinitionVersionRequest createDeviceDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createDeviceDefinitionVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDeviceDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDeviceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDeviceDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDeviceDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDeviceDefinitionVersionRequest, CreateDeviceDefinitionVersionResponse>()
                            .withOperationName("CreateDeviceDefinitionVersion")
                            .withMarshaller(new CreateDeviceDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDeviceDefinitionVersionRequest));
            CompletableFuture<CreateDeviceDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be
     * used in a group. You can create an initial version of the definition by providing a list of Lambda functions and
     * their configurations now, or use ''CreateFunctionDefinitionVersion'' later.
     *
     * @param createFunctionDefinitionRequest
     * @return A Java Future containing the result of the CreateFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFunctionDefinitionResponse> createFunctionDefinition(
            CreateFunctionDefinitionRequest createFunctionDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFunctionDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFunctionDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFunctionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFunctionDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFunctionDefinitionRequest, CreateFunctionDefinitionResponse>()
                            .withOperationName("CreateFunctionDefinition")
                            .withMarshaller(new CreateFunctionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createFunctionDefinitionRequest));
            CompletableFuture<CreateFunctionDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a Lambda function definition that has already been defined.
     *
     * @param createFunctionDefinitionVersionRequest
     *        Information needed to create a function definition version.
     * @return A Java Future containing the result of the CreateFunctionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateFunctionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFunctionDefinitionVersionResponse> createFunctionDefinitionVersion(
            CreateFunctionDefinitionVersionRequest createFunctionDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createFunctionDefinitionVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFunctionDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFunctionDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFunctionDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFunctionDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFunctionDefinitionVersionRequest, CreateFunctionDefinitionVersionResponse>()
                            .withOperationName("CreateFunctionDefinitionVersion")
                            .withMarshaller(new CreateFunctionDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createFunctionDefinitionVersionRequest));
            CompletableFuture<CreateFunctionDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time.
     * Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a
     * library or command-line application to create and deploy Greengrass groups.
     *
     * @param createGroupRequest
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                            .withOperationName("CreateGroup").withMarshaller(new CreateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createGroupRequest));
            CompletableFuture<CreateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a CA for the group. If a CA already exists, it will rotate the existing CA.
     *
     * @param createGroupCertificateAuthorityRequest
     * @return A Java Future containing the result of the CreateGroupCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroupCertificateAuthority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupCertificateAuthorityResponse> createGroupCertificateAuthority(
            CreateGroupCertificateAuthorityRequest createGroupCertificateAuthorityRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createGroupCertificateAuthorityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroupCertificateAuthority");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupCertificateAuthorityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGroupCertificateAuthorityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateGroupCertificateAuthorityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupCertificateAuthorityRequest, CreateGroupCertificateAuthorityResponse>()
                            .withOperationName("CreateGroupCertificateAuthority")
                            .withMarshaller(new CreateGroupCertificateAuthorityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createGroupCertificateAuthorityRequest));
            CompletableFuture<CreateGroupCertificateAuthorityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a group which has already been defined.
     *
     * @param createGroupVersionRequest
     * @return A Java Future containing the result of the CreateGroupVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateGroupVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateGroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupVersionResponse> createGroupVersion(CreateGroupVersionRequest createGroupVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroupVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGroupVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateGroupVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupVersionRequest, CreateGroupVersionResponse>()
                            .withOperationName("CreateGroupVersion")
                            .withMarshaller(new CreateGroupVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createGroupVersionRequest));
            CompletableFuture<CreateGroupVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a logger definition. You may provide the initial version of the logger definition now or use
     * ''CreateLoggerDefinitionVersion'' at a later time.
     *
     * @param createLoggerDefinitionRequest
     * @return A Java Future containing the result of the CreateLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoggerDefinitionResponse> createLoggerDefinition(
            CreateLoggerDefinitionRequest createLoggerDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLoggerDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLoggerDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLoggerDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLoggerDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLoggerDefinitionRequest, CreateLoggerDefinitionResponse>()
                            .withOperationName("CreateLoggerDefinition")
                            .withMarshaller(new CreateLoggerDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createLoggerDefinitionRequest));
            CompletableFuture<CreateLoggerDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a logger definition that has already been defined.
     *
     * @param createLoggerDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateLoggerDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateLoggerDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateLoggerDefinitionVersionResponse> createLoggerDefinitionVersion(
            CreateLoggerDefinitionVersionRequest createLoggerDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createLoggerDefinitionVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLoggerDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateLoggerDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateLoggerDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateLoggerDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateLoggerDefinitionVersionRequest, CreateLoggerDefinitionVersionResponse>()
                            .withOperationName("CreateLoggerDefinitionVersion")
                            .withMarshaller(new CreateLoggerDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createLoggerDefinitionVersionRequest));
            CompletableFuture<CreateLoggerDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a resource definition which contains a list of resources to be used in a group. You can create an initial
     * version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.
     *
     * @param createResourceDefinitionRequest
     * @return A Java Future containing the result of the CreateResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceDefinitionResponse> createResourceDefinition(
            CreateResourceDefinitionRequest createResourceDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourceDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceDefinitionRequest, CreateResourceDefinitionResponse>()
                            .withOperationName("CreateResourceDefinition")
                            .withMarshaller(new CreateResourceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createResourceDefinitionRequest));
            CompletableFuture<CreateResourceDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a resource definition that has already been defined.
     *
     * @param createResourceDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateResourceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateResourceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResourceDefinitionVersionResponse> createResourceDefinitionVersion(
            CreateResourceDefinitionVersionRequest createResourceDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createResourceDefinitionVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateResourceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateResourceDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateResourceDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResourceDefinitionVersionRequest, CreateResourceDefinitionVersionResponse>()
                            .withOperationName("CreateResourceDefinitionVersion")
                            .withMarshaller(new CreateResourceDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createResourceDefinitionVersionRequest));
            CompletableFuture<CreateResourceDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the
     * OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional
     * commands to manage a Greengrass core software update job.
     *
     * @param createSoftwareUpdateJobRequest
     * @return A Java Future containing the result of the CreateSoftwareUpdateJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSoftwareUpdateJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSoftwareUpdateJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSoftwareUpdateJobResponse> createSoftwareUpdateJob(
            CreateSoftwareUpdateJobRequest createSoftwareUpdateJobRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSoftwareUpdateJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSoftwareUpdateJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSoftwareUpdateJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSoftwareUpdateJobResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSoftwareUpdateJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSoftwareUpdateJobRequest, CreateSoftwareUpdateJobResponse>()
                            .withOperationName("CreateSoftwareUpdateJob")
                            .withMarshaller(new CreateSoftwareUpdateJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSoftwareUpdateJobRequest));
            CompletableFuture<CreateSoftwareUpdateJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a subscription definition. You may provide the initial version of the subscription definition now or use
     * ''CreateSubscriptionDefinitionVersion'' at a later time.
     *
     * @param createSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the CreateSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSubscriptionDefinitionResponse> createSubscriptionDefinition(
            CreateSubscriptionDefinitionRequest createSubscriptionDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSubscriptionDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSubscriptionDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSubscriptionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSubscriptionDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSubscriptionDefinitionRequest, CreateSubscriptionDefinitionResponse>()
                            .withOperationName("CreateSubscriptionDefinition")
                            .withMarshaller(new CreateSubscriptionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSubscriptionDefinitionRequest));
            CompletableFuture<CreateSubscriptionDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Creates a version of a subscription definition which has already been defined.
     *
     * @param createSubscriptionDefinitionVersionRequest
     * @return A Java Future containing the result of the CreateSubscriptionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.CreateSubscriptionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSubscriptionDefinitionVersionResponse> createSubscriptionDefinitionVersion(
            CreateSubscriptionDefinitionVersionRequest createSubscriptionDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createSubscriptionDefinitionVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSubscriptionDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSubscriptionDefinitionVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, CreateSubscriptionDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSubscriptionDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSubscriptionDefinitionVersionRequest, CreateSubscriptionDefinitionVersionResponse>()
                            .withOperationName("CreateSubscriptionDefinitionVersion")
                            .withMarshaller(new CreateSubscriptionDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createSubscriptionDefinitionVersionRequest));
            CompletableFuture<CreateSubscriptionDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a connector definition.
     *
     * @param deleteConnectorDefinitionRequest
     * @return A Java Future containing the result of the DeleteConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteConnectorDefinitionResponse> deleteConnectorDefinition(
            DeleteConnectorDefinitionRequest deleteConnectorDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConnectorDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConnectorDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteConnectorDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteConnectorDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteConnectorDefinitionRequest, DeleteConnectorDefinitionResponse>()
                            .withOperationName("DeleteConnectorDefinition")
                            .withMarshaller(new DeleteConnectorDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteConnectorDefinitionRequest));
            CompletableFuture<DeleteConnectorDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a core definition.
     *
     * @param deleteCoreDefinitionRequest
     * @return A Java Future containing the result of the DeleteCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCoreDefinitionResponse> deleteCoreDefinition(
            DeleteCoreDefinitionRequest deleteCoreDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCoreDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCoreDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteCoreDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteCoreDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCoreDefinitionRequest, DeleteCoreDefinitionResponse>()
                            .withOperationName("DeleteCoreDefinition")
                            .withMarshaller(new DeleteCoreDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteCoreDefinitionRequest));
            CompletableFuture<DeleteCoreDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a device definition.
     *
     * @param deleteDeviceDefinitionRequest
     * @return A Java Future containing the result of the DeleteDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDeviceDefinitionResponse> deleteDeviceDefinition(
            DeleteDeviceDefinitionRequest deleteDeviceDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDeviceDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDeviceDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDeviceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDeviceDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDeviceDefinitionRequest, DeleteDeviceDefinitionResponse>()
                            .withOperationName("DeleteDeviceDefinition")
                            .withMarshaller(new DeleteDeviceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDeviceDefinitionRequest));
            CompletableFuture<DeleteDeviceDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a Lambda function definition.
     *
     * @param deleteFunctionDefinitionRequest
     * @return A Java Future containing the result of the DeleteFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFunctionDefinitionResponse> deleteFunctionDefinition(
            DeleteFunctionDefinitionRequest deleteFunctionDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFunctionDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFunctionDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFunctionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFunctionDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFunctionDefinitionRequest, DeleteFunctionDefinitionResponse>()
                            .withOperationName("DeleteFunctionDefinition")
                            .withMarshaller(new DeleteFunctionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteFunctionDefinitionRequest));
            CompletableFuture<DeleteFunctionDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a group.
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                            .withOperationName("DeleteGroup").withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteGroupRequest));
            CompletableFuture<DeleteGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a logger definition.
     *
     * @param deleteLoggerDefinitionRequest
     * @return A Java Future containing the result of the DeleteLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteLoggerDefinitionResponse> deleteLoggerDefinition(
            DeleteLoggerDefinitionRequest deleteLoggerDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLoggerDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLoggerDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteLoggerDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteLoggerDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteLoggerDefinitionRequest, DeleteLoggerDefinitionResponse>()
                            .withOperationName("DeleteLoggerDefinition")
                            .withMarshaller(new DeleteLoggerDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteLoggerDefinitionRequest));
            CompletableFuture<DeleteLoggerDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a resource definition.
     *
     * @param deleteResourceDefinitionRequest
     * @return A Java Future containing the result of the DeleteResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResourceDefinitionResponse> deleteResourceDefinition(
            DeleteResourceDefinitionRequest deleteResourceDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourceDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteResourceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteResourceDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceDefinitionRequest, DeleteResourceDefinitionResponse>()
                            .withOperationName("DeleteResourceDefinition")
                            .withMarshaller(new DeleteResourceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteResourceDefinitionRequest));
            CompletableFuture<DeleteResourceDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deletes a subscription definition.
     *
     * @param deleteSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the DeleteSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DeleteSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeleteSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSubscriptionDefinitionResponse> deleteSubscriptionDefinition(
            DeleteSubscriptionDefinitionRequest deleteSubscriptionDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSubscriptionDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSubscriptionDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSubscriptionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSubscriptionDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSubscriptionDefinitionRequest, DeleteSubscriptionDefinitionResponse>()
                            .withOperationName("DeleteSubscriptionDefinition")
                            .withMarshaller(new DeleteSubscriptionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteSubscriptionDefinitionRequest));
            CompletableFuture<DeleteSubscriptionDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Disassociates the role from a group.
     *
     * @param disassociateRoleFromGroupRequest
     * @return A Java Future containing the result of the DisassociateRoleFromGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DisassociateRoleFromGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateRoleFromGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateRoleFromGroupResponse> disassociateRoleFromGroup(
            DisassociateRoleFromGroupRequest disassociateRoleFromGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateRoleFromGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateRoleFromGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateRoleFromGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateRoleFromGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateRoleFromGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateRoleFromGroupRequest, DisassociateRoleFromGroupResponse>()
                            .withOperationName("DisassociateRoleFromGroup")
                            .withMarshaller(new DisassociateRoleFromGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateRoleFromGroupRequest));
            CompletableFuture<DisassociateRoleFromGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Disassociates the service role from your account. Without a service role, deployments will not work.
     *
     * @param disassociateServiceRoleFromAccountRequest
     * @return A Java Future containing the result of the DisassociateServiceRoleFromAccount operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.DisassociateServiceRoleFromAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DisassociateServiceRoleFromAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateServiceRoleFromAccountResponse> disassociateServiceRoleFromAccount(
            DisassociateServiceRoleFromAccountRequest disassociateServiceRoleFromAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateServiceRoleFromAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateServiceRoleFromAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateServiceRoleFromAccountResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateServiceRoleFromAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateServiceRoleFromAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateServiceRoleFromAccountRequest, DisassociateServiceRoleFromAccountResponse>()
                            .withOperationName("DisassociateServiceRoleFromAccount")
                            .withMarshaller(new DisassociateServiceRoleFromAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateServiceRoleFromAccountRequest));
            CompletableFuture<DisassociateServiceRoleFromAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the role associated with a particular group.
     *
     * @param getAssociatedRoleRequest
     * @return A Java Future containing the result of the GetAssociatedRole operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetAssociatedRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetAssociatedRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAssociatedRoleResponse> getAssociatedRole(GetAssociatedRoleRequest getAssociatedRoleRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAssociatedRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAssociatedRole");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAssociatedRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAssociatedRoleResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetAssociatedRoleResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAssociatedRoleRequest, GetAssociatedRoleResponse>()
                            .withOperationName("GetAssociatedRole")
                            .withMarshaller(new GetAssociatedRoleRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getAssociatedRoleRequest));
            CompletableFuture<GetAssociatedRoleResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the status of a bulk deployment.
     *
     * @param getBulkDeploymentStatusRequest
     * @return A Java Future containing the result of the GetBulkDeploymentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetBulkDeploymentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetBulkDeploymentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBulkDeploymentStatusResponse> getBulkDeploymentStatus(
            GetBulkDeploymentStatusRequest getBulkDeploymentStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBulkDeploymentStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBulkDeploymentStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBulkDeploymentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBulkDeploymentStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBulkDeploymentStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBulkDeploymentStatusRequest, GetBulkDeploymentStatusResponse>()
                            .withOperationName("GetBulkDeploymentStatus")
                            .withMarshaller(new GetBulkDeploymentStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getBulkDeploymentStatusRequest));
            CompletableFuture<GetBulkDeploymentStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the connectivity information for a core.
     *
     * @param getConnectivityInfoRequest
     * @return A Java Future containing the result of the GetConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectivityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConnectivityInfoResponse> getConnectivityInfo(
            GetConnectivityInfoRequest getConnectivityInfoRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConnectivityInfoRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConnectivityInfo");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConnectivityInfoResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConnectivityInfoResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConnectivityInfoResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConnectivityInfoRequest, GetConnectivityInfoResponse>()
                            .withOperationName("GetConnectivityInfo")
                            .withMarshaller(new GetConnectivityInfoRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getConnectivityInfoRequest));
            CompletableFuture<GetConnectivityInfoResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a connector definition.
     *
     * @param getConnectorDefinitionRequest
     * @return A Java Future containing the result of the GetConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConnectorDefinitionResponse> getConnectorDefinition(
            GetConnectorDefinitionRequest getConnectorDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConnectorDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConnectorDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConnectorDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConnectorDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConnectorDefinitionRequest, GetConnectorDefinitionResponse>()
                            .withOperationName("GetConnectorDefinition")
                            .withMarshaller(new GetConnectorDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getConnectorDefinitionRequest));
            CompletableFuture<GetConnectorDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a connector definition version, including the connectors that the version contains.
     * Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud
     * services.
     *
     * @param getConnectorDefinitionVersionRequest
     * @return A Java Future containing the result of the GetConnectorDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetConnectorDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetConnectorDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetConnectorDefinitionVersionResponse> getConnectorDefinitionVersion(
            GetConnectorDefinitionVersionRequest getConnectorDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getConnectorDefinitionVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConnectorDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetConnectorDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetConnectorDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetConnectorDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetConnectorDefinitionVersionRequest, GetConnectorDefinitionVersionResponse>()
                            .withOperationName("GetConnectorDefinitionVersion")
                            .withMarshaller(new GetConnectorDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getConnectorDefinitionVersionRequest));
            CompletableFuture<GetConnectorDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a core definition version.
     *
     * @param getCoreDefinitionRequest
     * @return A Java Future containing the result of the GetCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinition" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCoreDefinitionResponse> getCoreDefinition(GetCoreDefinitionRequest getCoreDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCoreDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCoreDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCoreDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCoreDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCoreDefinitionRequest, GetCoreDefinitionResponse>()
                            .withOperationName("GetCoreDefinition")
                            .withMarshaller(new GetCoreDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCoreDefinitionRequest));
            CompletableFuture<GetCoreDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a core definition version.
     *
     * @param getCoreDefinitionVersionRequest
     * @return A Java Future containing the result of the GetCoreDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetCoreDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetCoreDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCoreDefinitionVersionResponse> getCoreDefinitionVersion(
            GetCoreDefinitionVersionRequest getCoreDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCoreDefinitionVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCoreDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCoreDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCoreDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCoreDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCoreDefinitionVersionRequest, GetCoreDefinitionVersionResponse>()
                            .withOperationName("GetCoreDefinitionVersion")
                            .withMarshaller(new GetCoreDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getCoreDefinitionVersionRequest));
            CompletableFuture<GetCoreDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns the status of a deployment.
     *
     * @param getDeploymentStatusRequest
     * @return A Java Future containing the result of the GetDeploymentStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeploymentStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeploymentStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeploymentStatusResponse> getDeploymentStatus(
            GetDeploymentStatusRequest getDeploymentStatusRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeploymentStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeploymentStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeploymentStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeploymentStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeploymentStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeploymentStatusRequest, GetDeploymentStatusResponse>()
                            .withOperationName("GetDeploymentStatus")
                            .withMarshaller(new GetDeploymentStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDeploymentStatusRequest));
            CompletableFuture<GetDeploymentStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a device definition.
     *
     * @param getDeviceDefinitionRequest
     * @return A Java Future containing the result of the GetDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceDefinitionResponse> getDeviceDefinition(
            GetDeviceDefinitionRequest getDeviceDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeviceDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeviceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeviceDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeviceDefinitionRequest, GetDeviceDefinitionResponse>()
                            .withOperationName("GetDeviceDefinition")
                            .withMarshaller(new GetDeviceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDeviceDefinitionRequest));
            CompletableFuture<GetDeviceDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a device definition version.
     *
     * @param getDeviceDefinitionVersionRequest
     * @return A Java Future containing the result of the GetDeviceDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetDeviceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetDeviceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDeviceDefinitionVersionResponse> getDeviceDefinitionVersion(
            GetDeviceDefinitionVersionRequest getDeviceDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDeviceDefinitionVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeviceDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDeviceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDeviceDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDeviceDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDeviceDefinitionVersionRequest, GetDeviceDefinitionVersionResponse>()
                            .withOperationName("GetDeviceDefinitionVersion")
                            .withMarshaller(new GetDeviceDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDeviceDefinitionVersionRequest));
            CompletableFuture<GetDeviceDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a Lambda function definition, including its creation time and latest version.
     *
     * @param getFunctionDefinitionRequest
     * @return A Java Future containing the result of the GetFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFunctionDefinitionResponse> getFunctionDefinition(
            GetFunctionDefinitionRequest getFunctionDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunctionDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFunctionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFunctionDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFunctionDefinitionRequest, GetFunctionDefinitionResponse>()
                            .withOperationName("GetFunctionDefinition")
                            .withMarshaller(new GetFunctionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getFunctionDefinitionRequest));
            CompletableFuture<GetFunctionDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a Lambda function definition version, including which Lambda functions are included
     * in the version and their configurations.
     *
     * @param getFunctionDefinitionVersionRequest
     * @return A Java Future containing the result of the GetFunctionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetFunctionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetFunctionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFunctionDefinitionVersionResponse> getFunctionDefinitionVersion(
            GetFunctionDefinitionVersionRequest getFunctionDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionDefinitionVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunctionDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFunctionDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFunctionDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFunctionDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFunctionDefinitionVersionRequest, GetFunctionDefinitionVersionResponse>()
                            .withOperationName("GetFunctionDefinitionVersion")
                            .withMarshaller(new GetFunctionDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getFunctionDefinitionVersionRequest));
            CompletableFuture<GetFunctionDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a group.
     *
     * @param getGroupRequest
     * @return A Java Future containing the result of the GetGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupResponse> getGroup(GetGroupRequest getGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGroupRequest, GetGroupResponse>().withOperationName("GetGroup")
                            .withMarshaller(new GetGroupRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getGroupRequest));
            CompletableFuture<GetGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retreives the CA associated with a group. Returns the public key of the CA.
     *
     * @param getGroupCertificateAuthorityRequest
     * @return A Java Future containing the result of the GetGroupCertificateAuthority operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupCertificateAuthority
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateAuthority"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupCertificateAuthorityResponse> getGroupCertificateAuthority(
            GetGroupCertificateAuthorityRequest getGroupCertificateAuthorityRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupCertificateAuthorityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroupCertificateAuthority");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupCertificateAuthorityResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGroupCertificateAuthorityResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGroupCertificateAuthorityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGroupCertificateAuthorityRequest, GetGroupCertificateAuthorityResponse>()
                            .withOperationName("GetGroupCertificateAuthority")
                            .withMarshaller(new GetGroupCertificateAuthorityRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGroupCertificateAuthorityRequest));
            CompletableFuture<GetGroupCertificateAuthorityResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the current configuration for the CA used by the group.
     *
     * @param getGroupCertificateConfigurationRequest
     * @return A Java Future containing the result of the GetGroupCertificateConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupCertificateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupCertificateConfigurationResponse> getGroupCertificateConfiguration(
            GetGroupCertificateConfigurationRequest getGroupCertificateConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getGroupCertificateConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroupCertificateConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupCertificateConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetGroupCertificateConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGroupCertificateConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGroupCertificateConfigurationRequest, GetGroupCertificateConfigurationResponse>()
                            .withOperationName("GetGroupCertificateConfiguration")
                            .withMarshaller(new GetGroupCertificateConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGroupCertificateConfigurationRequest));
            CompletableFuture<GetGroupCertificateConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a group version.
     *
     * @param getGroupVersionRequest
     * @return A Java Future containing the result of the GetGroupVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetGroupVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetGroupVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetGroupVersionResponse> getGroupVersion(GetGroupVersionRequest getGroupVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroupVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetGroupVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetGroupVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetGroupVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetGroupVersionRequest, GetGroupVersionResponse>()
                            .withOperationName("GetGroupVersion")
                            .withMarshaller(new GetGroupVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getGroupVersionRequest));
            CompletableFuture<GetGroupVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a logger definition.
     *
     * @param getLoggerDefinitionRequest
     * @return A Java Future containing the result of the GetLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoggerDefinitionResponse> getLoggerDefinition(
            GetLoggerDefinitionRequest getLoggerDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoggerDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoggerDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoggerDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoggerDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoggerDefinitionRequest, GetLoggerDefinitionResponse>()
                            .withOperationName("GetLoggerDefinition")
                            .withMarshaller(new GetLoggerDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLoggerDefinitionRequest));
            CompletableFuture<GetLoggerDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a logger definition version.
     *
     * @param getLoggerDefinitionVersionRequest
     * @return A Java Future containing the result of the GetLoggerDefinitionVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetLoggerDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetLoggerDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetLoggerDefinitionVersionResponse> getLoggerDefinitionVersion(
            GetLoggerDefinitionVersionRequest getLoggerDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoggerDefinitionVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoggerDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetLoggerDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetLoggerDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetLoggerDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetLoggerDefinitionVersionRequest, GetLoggerDefinitionVersionResponse>()
                            .withOperationName("GetLoggerDefinitionVersion")
                            .withMarshaller(new GetLoggerDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getLoggerDefinitionVersionRequest));
            CompletableFuture<GetLoggerDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a resource definition, including its creation time and latest version.
     *
     * @param getResourceDefinitionRequest
     * @return A Java Future containing the result of the GetResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceDefinitionResponse> getResourceDefinition(
            GetResourceDefinitionRequest getResourceDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourceDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceDefinitionRequest, GetResourceDefinitionResponse>()
                            .withOperationName("GetResourceDefinition")
                            .withMarshaller(new GetResourceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getResourceDefinitionRequest));
            CompletableFuture<GetResourceDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a resource definition version, including which resources are included in the version.
     *
     * @param getResourceDefinitionVersionRequest
     * @return A Java Future containing the result of the GetResourceDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetResourceDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetResourceDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResourceDefinitionVersionResponse> getResourceDefinitionVersion(
            GetResourceDefinitionVersionRequest getResourceDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceDefinitionVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetResourceDefinitionVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetResourceDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetResourceDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResourceDefinitionVersionRequest, GetResourceDefinitionVersionResponse>()
                            .withOperationName("GetResourceDefinitionVersion")
                            .withMarshaller(new GetResourceDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getResourceDefinitionVersionRequest));
            CompletableFuture<GetResourceDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the service role that is attached to your account.
     *
     * @param getServiceRoleForAccountRequest
     * @return A Java Future containing the result of the GetServiceRoleForAccount operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetServiceRoleForAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetServiceRoleForAccount"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetServiceRoleForAccountResponse> getServiceRoleForAccount(
            GetServiceRoleForAccountRequest getServiceRoleForAccountRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServiceRoleForAccountRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceRoleForAccount");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetServiceRoleForAccountResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetServiceRoleForAccountResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetServiceRoleForAccountResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetServiceRoleForAccountRequest, GetServiceRoleForAccountResponse>()
                            .withOperationName("GetServiceRoleForAccount")
                            .withMarshaller(new GetServiceRoleForAccountRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getServiceRoleForAccountRequest));
            CompletableFuture<GetServiceRoleForAccountResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a subscription definition.
     *
     * @param getSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the GetSubscriptionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSubscriptionDefinitionResponse> getSubscriptionDefinition(
            GetSubscriptionDefinitionRequest getSubscriptionDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSubscriptionDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSubscriptionDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSubscriptionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSubscriptionDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSubscriptionDefinitionRequest, GetSubscriptionDefinitionResponse>()
                            .withOperationName("GetSubscriptionDefinition")
                            .withMarshaller(new GetSubscriptionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSubscriptionDefinitionRequest));
            CompletableFuture<GetSubscriptionDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves information about a subscription definition version.
     *
     * @param getSubscriptionDefinitionVersionRequest
     * @return A Java Future containing the result of the GetSubscriptionDefinitionVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetSubscriptionDefinitionVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetSubscriptionDefinitionVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSubscriptionDefinitionVersionResponse> getSubscriptionDefinitionVersion(
            GetSubscriptionDefinitionVersionRequest getSubscriptionDefinitionVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getSubscriptionDefinitionVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSubscriptionDefinitionVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSubscriptionDefinitionVersionResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetSubscriptionDefinitionVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSubscriptionDefinitionVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSubscriptionDefinitionVersionRequest, GetSubscriptionDefinitionVersionResponse>()
                            .withOperationName("GetSubscriptionDefinitionVersion")
                            .withMarshaller(new GetSubscriptionDefinitionVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSubscriptionDefinitionVersionRequest));
            CompletableFuture<GetSubscriptionDefinitionVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Get the runtime configuration of a thing.
     *
     * @param getThingRuntimeConfigurationRequest
     * @return A Java Future containing the result of the GetThingRuntimeConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.GetThingRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GetThingRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetThingRuntimeConfigurationResponse> getThingRuntimeConfiguration(
            GetThingRuntimeConfigurationRequest getThingRuntimeConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getThingRuntimeConfigurationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetThingRuntimeConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetThingRuntimeConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetThingRuntimeConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetThingRuntimeConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetThingRuntimeConfigurationRequest, GetThingRuntimeConfigurationResponse>()
                            .withOperationName("GetThingRuntimeConfiguration")
                            .withMarshaller(new GetThingRuntimeConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getThingRuntimeConfigurationRequest));
            CompletableFuture<GetThingRuntimeConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current
     * deployment status.
     *
     * @param listBulkDeploymentDetailedReportsRequest
     * @return A Java Future containing the result of the ListBulkDeploymentDetailedReports operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListBulkDeploymentDetailedReports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeploymentDetailedReports"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBulkDeploymentDetailedReportsResponse> listBulkDeploymentDetailedReports(
            ListBulkDeploymentDetailedReportsRequest listBulkDeploymentDetailedReportsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listBulkDeploymentDetailedReportsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBulkDeploymentDetailedReports");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBulkDeploymentDetailedReportsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListBulkDeploymentDetailedReportsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBulkDeploymentDetailedReportsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBulkDeploymentDetailedReportsRequest, ListBulkDeploymentDetailedReportsResponse>()
                            .withOperationName("ListBulkDeploymentDetailedReports")
                            .withMarshaller(new ListBulkDeploymentDetailedReportsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBulkDeploymentDetailedReportsRequest));
            CompletableFuture<ListBulkDeploymentDetailedReportsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns a list of bulk deployments.
     *
     * @param listBulkDeploymentsRequest
     * @return A Java Future containing the result of the ListBulkDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListBulkDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListBulkDeployments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBulkDeploymentsResponse> listBulkDeployments(
            ListBulkDeploymentsRequest listBulkDeploymentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBulkDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBulkDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBulkDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBulkDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBulkDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBulkDeploymentsRequest, ListBulkDeploymentsResponse>()
                            .withOperationName("ListBulkDeployments")
                            .withMarshaller(new ListBulkDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBulkDeploymentsRequest));
            CompletableFuture<ListBulkDeploymentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a connector definition, which are containers for connectors. Connectors run on the
     * Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other
     * cloud services.
     *
     * @param listConnectorDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListConnectorDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListConnectorDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConnectorDefinitionVersionsResponse> listConnectorDefinitionVersions(
            ListConnectorDefinitionVersionsRequest listConnectorDefinitionVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listConnectorDefinitionVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConnectorDefinitionVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConnectorDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConnectorDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConnectorDefinitionVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConnectorDefinitionVersionsRequest, ListConnectorDefinitionVersionsResponse>()
                            .withOperationName("ListConnectorDefinitionVersions")
                            .withMarshaller(new ListConnectorDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listConnectorDefinitionVersionsRequest));
            CompletableFuture<ListConnectorDefinitionVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of connector definitions.
     *
     * @param listConnectorDefinitionsRequest
     * @return A Java Future containing the result of the ListConnectorDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListConnectorDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListConnectorDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConnectorDefinitionsResponse> listConnectorDefinitions(
            ListConnectorDefinitionsRequest listConnectorDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConnectorDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConnectorDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListConnectorDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListConnectorDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListConnectorDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConnectorDefinitionsRequest, ListConnectorDefinitionsResponse>()
                            .withOperationName("ListConnectorDefinitions")
                            .withMarshaller(new ListConnectorDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listConnectorDefinitionsRequest));
            CompletableFuture<ListConnectorDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a core definition.
     *
     * @param listCoreDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListCoreDefinitionVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListCoreDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCoreDefinitionVersionsResponse> listCoreDefinitionVersions(
            ListCoreDefinitionVersionsRequest listCoreDefinitionVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCoreDefinitionVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCoreDefinitionVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCoreDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCoreDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCoreDefinitionVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCoreDefinitionVersionsRequest, ListCoreDefinitionVersionsResponse>()
                            .withOperationName("ListCoreDefinitionVersions")
                            .withMarshaller(new ListCoreDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCoreDefinitionVersionsRequest));
            CompletableFuture<ListCoreDefinitionVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of core definitions.
     *
     * @param listCoreDefinitionsRequest
     * @return A Java Future containing the result of the ListCoreDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListCoreDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListCoreDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCoreDefinitionsResponse> listCoreDefinitions(
            ListCoreDefinitionsRequest listCoreDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCoreDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCoreDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCoreDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListCoreDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCoreDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCoreDefinitionsRequest, ListCoreDefinitionsResponse>()
                            .withOperationName("ListCoreDefinitions")
                            .withMarshaller(new ListCoreDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCoreDefinitionsRequest));
            CompletableFuture<ListCoreDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Returns a history of deployments for the group.
     *
     * @param listDeploymentsRequest
     * @return A Java Future containing the result of the ListDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeploymentsResponse> listDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeploymentsRequest, ListDeploymentsResponse>()
                            .withOperationName("ListDeployments")
                            .withMarshaller(new ListDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDeploymentsRequest));
            CompletableFuture<ListDeploymentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a device definition.
     *
     * @param listDeviceDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListDeviceDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeviceDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeviceDefinitionVersionsResponse> listDeviceDefinitionVersions(
            ListDeviceDefinitionVersionsRequest listDeviceDefinitionVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeviceDefinitionVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeviceDefinitionVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeviceDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeviceDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeviceDefinitionVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeviceDefinitionVersionsRequest, ListDeviceDefinitionVersionsResponse>()
                            .withOperationName("ListDeviceDefinitionVersions")
                            .withMarshaller(new ListDeviceDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDeviceDefinitionVersionsRequest));
            CompletableFuture<ListDeviceDefinitionVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of device definitions.
     *
     * @param listDeviceDefinitionsRequest
     * @return A Java Future containing the result of the ListDeviceDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListDeviceDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListDeviceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDeviceDefinitionsResponse> listDeviceDefinitions(
            ListDeviceDefinitionsRequest listDeviceDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDeviceDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDeviceDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDeviceDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDeviceDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDeviceDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDeviceDefinitionsRequest, ListDeviceDefinitionsResponse>()
                            .withOperationName("ListDeviceDefinitions")
                            .withMarshaller(new ListDeviceDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDeviceDefinitionsRequest));
            CompletableFuture<ListDeviceDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a Lambda function definition.
     *
     * @param listFunctionDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListFunctionDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListFunctionDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFunctionDefinitionVersionsResponse> listFunctionDefinitionVersions(
            ListFunctionDefinitionVersionsRequest listFunctionDefinitionVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listFunctionDefinitionVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFunctionDefinitionVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFunctionDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFunctionDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFunctionDefinitionVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFunctionDefinitionVersionsRequest, ListFunctionDefinitionVersionsResponse>()
                            .withOperationName("ListFunctionDefinitionVersions")
                            .withMarshaller(new ListFunctionDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFunctionDefinitionVersionsRequest));
            CompletableFuture<ListFunctionDefinitionVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of Lambda function definitions.
     *
     * @param listFunctionDefinitionsRequest
     * @return A Java Future containing the result of the ListFunctionDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListFunctionDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListFunctionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFunctionDefinitionsResponse> listFunctionDefinitions(
            ListFunctionDefinitionsRequest listFunctionDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFunctionDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFunctionDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFunctionDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFunctionDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFunctionDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFunctionDefinitionsRequest, ListFunctionDefinitionsResponse>()
                            .withOperationName("ListFunctionDefinitions")
                            .withMarshaller(new ListFunctionDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFunctionDefinitionsRequest));
            CompletableFuture<ListFunctionDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves the current CAs for a group.
     *
     * @param listGroupCertificateAuthoritiesRequest
     * @return A Java Future containing the result of the ListGroupCertificateAuthorities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroupCertificateAuthorities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupCertificateAuthorities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupCertificateAuthoritiesResponse> listGroupCertificateAuthorities(
            ListGroupCertificateAuthoritiesRequest listGroupCertificateAuthoritiesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listGroupCertificateAuthoritiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupCertificateAuthorities");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupCertificateAuthoritiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGroupCertificateAuthoritiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupCertificateAuthoritiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupCertificateAuthoritiesRequest, ListGroupCertificateAuthoritiesResponse>()
                            .withOperationName("ListGroupCertificateAuthorities")
                            .withMarshaller(new ListGroupCertificateAuthoritiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listGroupCertificateAuthoritiesRequest));
            CompletableFuture<ListGroupCertificateAuthoritiesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a group.
     *
     * @param listGroupVersionsRequest
     * @return A Java Future containing the result of the ListGroupVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroupVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroupVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupVersionsResponse> listGroupVersions(ListGroupVersionsRequest listGroupVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGroupVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupVersionsRequest, ListGroupVersionsResponse>()
                            .withOperationName("ListGroupVersions")
                            .withMarshaller(new ListGroupVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listGroupVersionsRequest));
            CompletableFuture<ListGroupVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of groups.
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listGroupsRequest));
            CompletableFuture<ListGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a logger definition.
     *
     * @param listLoggerDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListLoggerDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListLoggerDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLoggerDefinitionVersionsResponse> listLoggerDefinitionVersions(
            ListLoggerDefinitionVersionsRequest listLoggerDefinitionVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLoggerDefinitionVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLoggerDefinitionVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLoggerDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLoggerDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLoggerDefinitionVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLoggerDefinitionVersionsRequest, ListLoggerDefinitionVersionsResponse>()
                            .withOperationName("ListLoggerDefinitionVersions")
                            .withMarshaller(new ListLoggerDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listLoggerDefinitionVersionsRequest));
            CompletableFuture<ListLoggerDefinitionVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of logger definitions.
     *
     * @param listLoggerDefinitionsRequest
     * @return A Java Future containing the result of the ListLoggerDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListLoggerDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListLoggerDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListLoggerDefinitionsResponse> listLoggerDefinitions(
            ListLoggerDefinitionsRequest listLoggerDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLoggerDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLoggerDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListLoggerDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListLoggerDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListLoggerDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListLoggerDefinitionsRequest, ListLoggerDefinitionsResponse>()
                            .withOperationName("ListLoggerDefinitions")
                            .withMarshaller(new ListLoggerDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listLoggerDefinitionsRequest));
            CompletableFuture<ListLoggerDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a resource definition.
     *
     * @param listResourceDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListResourceDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListResourceDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceDefinitionVersionsResponse> listResourceDefinitionVersions(
            ListResourceDefinitionVersionsRequest listResourceDefinitionVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResourceDefinitionVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceDefinitionVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceDefinitionVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceDefinitionVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceDefinitionVersionsRequest, ListResourceDefinitionVersionsResponse>()
                            .withOperationName("ListResourceDefinitionVersions")
                            .withMarshaller(new ListResourceDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listResourceDefinitionVersionsRequest));
            CompletableFuture<ListResourceDefinitionVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of resource definitions.
     *
     * @param listResourceDefinitionsRequest
     * @return A Java Future containing the result of the ListResourceDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListResourceDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListResourceDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResourceDefinitionsResponse> listResourceDefinitions(
            ListResourceDefinitionsRequest listResourceDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListResourceDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListResourceDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListResourceDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResourceDefinitionsRequest, ListResourceDefinitionsResponse>()
                            .withOperationName("ListResourceDefinitions")
                            .withMarshaller(new ListResourceDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listResourceDefinitionsRequest));
            CompletableFuture<ListResourceDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Lists the versions of a subscription definition.
     *
     * @param listSubscriptionDefinitionVersionsRequest
     * @return A Java Future containing the result of the ListSubscriptionDefinitionVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListSubscriptionDefinitionVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitionVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSubscriptionDefinitionVersionsResponse> listSubscriptionDefinitionVersions(
            ListSubscriptionDefinitionVersionsRequest listSubscriptionDefinitionVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listSubscriptionDefinitionVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSubscriptionDefinitionVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSubscriptionDefinitionVersionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, ListSubscriptionDefinitionVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSubscriptionDefinitionVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSubscriptionDefinitionVersionsRequest, ListSubscriptionDefinitionVersionsResponse>()
                            .withOperationName("ListSubscriptionDefinitionVersions")
                            .withMarshaller(new ListSubscriptionDefinitionVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSubscriptionDefinitionVersionsRequest));
            CompletableFuture<ListSubscriptionDefinitionVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of subscription definitions.
     *
     * @param listSubscriptionDefinitionsRequest
     * @return A Java Future containing the result of the ListSubscriptionDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListSubscriptionDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListSubscriptionDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListSubscriptionDefinitionsResponse> listSubscriptionDefinitions(
            ListSubscriptionDefinitionsRequest listSubscriptionDefinitionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSubscriptionDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSubscriptionDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSubscriptionDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSubscriptionDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListSubscriptionDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSubscriptionDefinitionsRequest, ListSubscriptionDefinitionsResponse>()
                            .withOperationName("ListSubscriptionDefinitions")
                            .withMarshaller(new ListSubscriptionDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listSubscriptionDefinitionsRequest));
            CompletableFuture<ListSubscriptionDefinitionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Retrieves a list of resource tags for a resource arn.
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Resets a group's deployments.
     *
     * @param resetDeploymentsRequest
     *        Information needed to reset deployments.
     * @return A Java Future containing the result of the ResetDeployments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.ResetDeployments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResetDeployments" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ResetDeploymentsResponse> resetDeployments(ResetDeploymentsRequest resetDeploymentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetDeploymentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetDeployments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ResetDeploymentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ResetDeploymentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ResetDeploymentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ResetDeploymentsRequest, ResetDeploymentsResponse>()
                            .withOperationName("ResetDeployments")
                            .withMarshaller(new ResetDeploymentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(resetDeploymentsRequest));
            CompletableFuture<ResetDeploymentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group
     * versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We
     * recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These
     * requests are idempotent with respect to the token and the request parameters.
     *
     * @param startBulkDeploymentRequest
     * @return A Java Future containing the result of the StartBulkDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.StartBulkDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StartBulkDeployment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartBulkDeploymentResponse> startBulkDeployment(
            StartBulkDeploymentRequest startBulkDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startBulkDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartBulkDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartBulkDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartBulkDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StartBulkDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartBulkDeploymentRequest, StartBulkDeploymentResponse>()
                            .withOperationName("StartBulkDeployment")
                            .withMarshaller(new StartBulkDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(startBulkDeploymentRequest));
            CompletableFuture<StartBulkDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is
     * stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This
     * action doesn't rollback completed deployments or cancel pending deployments.
     *
     * @param stopBulkDeploymentRequest
     * @return A Java Future containing the result of the StopBulkDeployment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.StopBulkDeployment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/StopBulkDeployment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StopBulkDeploymentResponse> stopBulkDeployment(StopBulkDeploymentRequest stopBulkDeploymentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopBulkDeploymentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopBulkDeployment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StopBulkDeploymentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StopBulkDeploymentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<StopBulkDeploymentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StopBulkDeploymentRequest, StopBulkDeploymentResponse>()
                            .withOperationName("StopBulkDeployment")
                            .withMarshaller(new StopBulkDeploymentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(stopBulkDeploymentRequest));
            CompletableFuture<StopBulkDeploymentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Adds tags to a Greengrass resource. Valid resources are 'Group', 'ConnectorDefinition', 'CoreDefinition',
     * 'DeviceDefinition', 'FunctionDefinition', 'LoggerDefinition', 'SubscriptionDefinition', 'ResourceDefinition', and
     * 'BulkDeployment'.
     *
     * @param tagResourceRequest
     *        A map of the key-value pairs for the resource tag.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Remove resource tags from a Greengrass Resource.
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates the connectivity information for the core. Any devices that belong to the group which has this core will
     * receive this information in order to find the location of the core and connect to it.
     *
     * @param updateConnectivityInfoRequest
     *        Connectivity information.
     * @return A Java Future containing the result of the UpdateConnectivityInfo operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateConnectivityInfo
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectivityInfo"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConnectivityInfoResponse> updateConnectivityInfo(
            UpdateConnectivityInfoRequest updateConnectivityInfoRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConnectivityInfoRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConnectivityInfo");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConnectivityInfoResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConnectivityInfoResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConnectivityInfoResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConnectivityInfoRequest, UpdateConnectivityInfoResponse>()
                            .withOperationName("UpdateConnectivityInfo")
                            .withMarshaller(new UpdateConnectivityInfoRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateConnectivityInfoRequest));
            CompletableFuture<UpdateConnectivityInfoResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a connector definition.
     *
     * @param updateConnectorDefinitionRequest
     * @return A Java Future containing the result of the UpdateConnectorDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateConnectorDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateConnectorDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateConnectorDefinitionResponse> updateConnectorDefinition(
            UpdateConnectorDefinitionRequest updateConnectorDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateConnectorDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateConnectorDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateConnectorDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateConnectorDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateConnectorDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateConnectorDefinitionRequest, UpdateConnectorDefinitionResponse>()
                            .withOperationName("UpdateConnectorDefinition")
                            .withMarshaller(new UpdateConnectorDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateConnectorDefinitionRequest));
            CompletableFuture<UpdateConnectorDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a core definition.
     *
     * @param updateCoreDefinitionRequest
     * @return A Java Future containing the result of the UpdateCoreDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateCoreDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateCoreDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCoreDefinitionResponse> updateCoreDefinition(
            UpdateCoreDefinitionRequest updateCoreDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCoreDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCoreDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCoreDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCoreDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCoreDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCoreDefinitionRequest, UpdateCoreDefinitionResponse>()
                            .withOperationName("UpdateCoreDefinition")
                            .withMarshaller(new UpdateCoreDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateCoreDefinitionRequest));
            CompletableFuture<UpdateCoreDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a device definition.
     *
     * @param updateDeviceDefinitionRequest
     * @return A Java Future containing the result of the UpdateDeviceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateDeviceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateDeviceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDeviceDefinitionResponse> updateDeviceDefinition(
            UpdateDeviceDefinitionRequest updateDeviceDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDeviceDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDeviceDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDeviceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDeviceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDeviceDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDeviceDefinitionRequest, UpdateDeviceDefinitionResponse>()
                            .withOperationName("UpdateDeviceDefinition")
                            .withMarshaller(new UpdateDeviceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDeviceDefinitionRequest));
            CompletableFuture<UpdateDeviceDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a Lambda function definition.
     *
     * @param updateFunctionDefinitionRequest
     * @return A Java Future containing the result of the UpdateFunctionDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateFunctionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateFunctionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFunctionDefinitionResponse> updateFunctionDefinition(
            UpdateFunctionDefinitionRequest updateFunctionDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFunctionDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFunctionDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFunctionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFunctionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFunctionDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFunctionDefinitionRequest, UpdateFunctionDefinitionResponse>()
                            .withOperationName("UpdateFunctionDefinition")
                            .withMarshaller(new UpdateFunctionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateFunctionDefinitionRequest));
            CompletableFuture<UpdateFunctionDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a group.
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                            .withOperationName("UpdateGroup").withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateGroupRequest));
            CompletableFuture<UpdateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates the Certificate expiry time for a group.
     *
     * @param updateGroupCertificateConfigurationRequest
     * @return A Java Future containing the result of the UpdateGroupCertificateConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateGroupCertificateConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGroupCertificateConfigurationResponse> updateGroupCertificateConfiguration(
            UpdateGroupCertificateConfigurationRequest updateGroupCertificateConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateGroupCertificateConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGroupCertificateConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGroupCertificateConfigurationResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, UpdateGroupCertificateConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGroupCertificateConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGroupCertificateConfigurationRequest, UpdateGroupCertificateConfigurationResponse>()
                            .withOperationName("UpdateGroupCertificateConfiguration")
                            .withMarshaller(new UpdateGroupCertificateConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateGroupCertificateConfigurationRequest));
            CompletableFuture<UpdateGroupCertificateConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a logger definition.
     *
     * @param updateLoggerDefinitionRequest
     * @return A Java Future containing the result of the UpdateLoggerDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateLoggerDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateLoggerDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateLoggerDefinitionResponse> updateLoggerDefinition(
            UpdateLoggerDefinitionRequest updateLoggerDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLoggerDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLoggerDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateLoggerDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateLoggerDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateLoggerDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateLoggerDefinitionRequest, UpdateLoggerDefinitionResponse>()
                            .withOperationName("UpdateLoggerDefinition")
                            .withMarshaller(new UpdateLoggerDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateLoggerDefinitionRequest));
            CompletableFuture<UpdateLoggerDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a resource definition.
     *
     * @param updateResourceDefinitionRequest
     * @return A Java Future containing the result of the UpdateResourceDefinition operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateResourceDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateResourceDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResourceDefinitionResponse> updateResourceDefinition(
            UpdateResourceDefinitionRequest updateResourceDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourceDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourceDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResourceDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResourceDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResourceDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceDefinitionRequest, UpdateResourceDefinitionResponse>()
                            .withOperationName("UpdateResourceDefinition")
                            .withMarshaller(new UpdateResourceDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateResourceDefinitionRequest));
            CompletableFuture<UpdateResourceDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates a subscription definition.
     *
     * @param updateSubscriptionDefinitionRequest
     * @return A Java Future containing the result of the UpdateSubscriptionDefinition operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateSubscriptionDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateSubscriptionDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSubscriptionDefinitionResponse> updateSubscriptionDefinition(
            UpdateSubscriptionDefinitionRequest updateSubscriptionDefinitionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSubscriptionDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSubscriptionDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSubscriptionDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSubscriptionDefinitionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSubscriptionDefinitionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSubscriptionDefinitionRequest, UpdateSubscriptionDefinitionResponse>()
                            .withOperationName("UpdateSubscriptionDefinition")
                            .withMarshaller(new UpdateSubscriptionDefinitionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateSubscriptionDefinitionRequest));
            CompletableFuture<UpdateSubscriptionDefinitionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * Updates the runtime configuration of a thing.
     *
     * @param updateThingRuntimeConfigurationRequest
     * @return A Java Future containing the result of the UpdateThingRuntimeConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>BadRequestException invalid request</li>
     *         <li>InternalServerErrorException server error</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>GreengrassException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample GreengrassAsyncClient.UpdateThingRuntimeConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateThingRuntimeConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateThingRuntimeConfigurationResponse> updateThingRuntimeConfiguration(
            UpdateThingRuntimeConfigurationRequest updateThingRuntimeConfigurationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateThingRuntimeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Greengrass");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateThingRuntimeConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateThingRuntimeConfigurationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateThingRuntimeConfigurationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateThingRuntimeConfigurationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateThingRuntimeConfigurationRequest, UpdateThingRuntimeConfigurationResponse>()
                            .withOperationName("UpdateThingRuntimeConfiguration")
                            .withMarshaller(new UpdateThingRuntimeConfigurationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateThingRuntimeConfigurationRequest));
            CompletableFuture<UpdateThingRuntimeConfigurationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final GreengrassServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(GreengrassException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
