/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.greengrass.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Information about a subscription.
 */
@Generated("software.amazon.awssdk:codegen")
public final class Subscription implements SdkPojo, Serializable, ToCopyableBuilder<Subscription.Builder, Subscription> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(Subscription::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(Subscription::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> SUBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Subject")
            .getter(getter(Subscription::subject)).setter(setter(Builder::subject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subject").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(Subscription::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SOURCE_FIELD,
            SUBJECT_FIELD, TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String source;

    private final String subject;

    private final String target;

    private Subscription(BuilderImpl builder) {
        this.id = builder.id;
        this.source = builder.source;
        this.subject = builder.subject;
        this.target = builder.target;
    }

    /**
     * A descriptive or arbitrary ID for the subscription. This value must be unique within the subscription definition
     * version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
     * 
     * @return A descriptive or arbitrary ID for the subscription. This value must be unique within the subscription
     *         definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
     */
    public final String id() {
        return id;
    }

    /**
     * The source of the subscription. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which
     * represents the AWS IoT cloud), or 'GGShadowService'.
     * 
     * @return The source of the subscription. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud'
     *         (which represents the AWS IoT cloud), or 'GGShadowService'.
     */
    public final String source() {
        return source;
    }

    /**
     * The MQTT topic used to route the message.
     * 
     * @return The MQTT topic used to route the message.
     */
    public final String subject() {
        return subject;
    }

    /**
     * Where the message is sent to. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which
     * represents the AWS IoT cloud), or 'GGShadowService'.
     * 
     * @return Where the message is sent to. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which
     *         represents the AWS IoT cloud), or 'GGShadowService'.
     */
    public final String target() {
        return target;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(subject());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subscription)) {
            return false;
        }
        Subscription other = (Subscription) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(source(), other.source())
                && Objects.equals(subject(), other.subject()) && Objects.equals(target(), other.target());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Subscription").add("Id", id()).add("Source", source()).add("Subject", subject())
                .add("Target", target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "Subject":
            return Optional.ofNullable(clazz.cast(subject()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Subscription, T> g) {
        return obj -> g.apply((Subscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Subscription> {
        /**
         * A descriptive or arbitrary ID for the subscription. This value must be unique within the subscription
         * definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
         * 
         * @param id
         *        A descriptive or arbitrary ID for the subscription. This value must be unique within the subscription
         *        definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * The source of the subscription. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which
         * represents the AWS IoT cloud), or 'GGShadowService'.
         * 
         * @param source
         *        The source of the subscription. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud'
         *        (which represents the AWS IoT cloud), or 'GGShadowService'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * The MQTT topic used to route the message.
         * 
         * @param subject
         *        The MQTT topic used to route the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(String subject);

        /**
         * Where the message is sent to. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud' (which
         * represents the AWS IoT cloud), or 'GGShadowService'.
         * 
         * @param target
         *        Where the message is sent to. Can be a thing ARN, a Lambda function ARN, a connector ARN, 'cloud'
         *        (which represents the AWS IoT cloud), or 'GGShadowService'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String source;

        private String subject;

        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(Subscription model) {
            id(model.id);
            source(model.source);
            subject(model.subject);
            target(model.target);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getSubject() {
            return subject;
        }

        public final void setSubject(String subject) {
            this.subject = subject;
        }

        @Override
        public final Builder subject(String subject) {
            this.subject = subject;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        @Override
        public Subscription build() {
            return new Subscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
