/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeploymentHistoryFilter {
    ALL("ALL"),
    LATEST_ONLY("LATEST_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeploymentHistoryFilter> VALUE_MAP;
    private final String value;

    private DeploymentHistoryFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentHistoryFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentHistoryFilter> knownValues() {
        EnumSet<DeploymentHistoryFilter> knownValues = EnumSet.allOf(DeploymentHistoryFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeploymentHistoryFilter.class, DeploymentHistoryFilter::toString);
    }
}

