/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrassv2.model.IoTJobAbortConfig;
import software.amazon.awssdk.services.greengrassv2.model.IoTJobExecutionsRolloutConfig;
import software.amazon.awssdk.services.greengrassv2.model.IoTJobTimeoutConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentIoTJobConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentIoTJobConfiguration> {
    private static final SdkField<IoTJobExecutionsRolloutConfig> JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobExecutionsRolloutConfig").getter(DeploymentIoTJobConfiguration.getter(DeploymentIoTJobConfiguration::jobExecutionsRolloutConfig)).setter(DeploymentIoTJobConfiguration.setter(Builder::jobExecutionsRolloutConfig)).constructor(IoTJobExecutionsRolloutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobExecutionsRolloutConfig").build()}).build();
    private static final SdkField<IoTJobAbortConfig> ABORT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("abortConfig").getter(DeploymentIoTJobConfiguration.getter(DeploymentIoTJobConfiguration::abortConfig)).setter(DeploymentIoTJobConfiguration.setter(Builder::abortConfig)).constructor(IoTJobAbortConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("abortConfig").build()}).build();
    private static final SdkField<IoTJobTimeoutConfig> TIMEOUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timeoutConfig").getter(DeploymentIoTJobConfiguration.getter(DeploymentIoTJobConfiguration::timeoutConfig)).setter(DeploymentIoTJobConfiguration.setter(Builder::timeoutConfig)).constructor(IoTJobTimeoutConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD, ABORT_CONFIG_FIELD, TIMEOUT_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeploymentIoTJobConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final IoTJobExecutionsRolloutConfig jobExecutionsRolloutConfig;
    private final IoTJobAbortConfig abortConfig;
    private final IoTJobTimeoutConfig timeoutConfig;

    private DeploymentIoTJobConfiguration(BuilderImpl builder) {
        this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
        this.abortConfig = builder.abortConfig;
        this.timeoutConfig = builder.timeoutConfig;
    }

    public final IoTJobExecutionsRolloutConfig jobExecutionsRolloutConfig() {
        return this.jobExecutionsRolloutConfig;
    }

    public final IoTJobAbortConfig abortConfig() {
        return this.abortConfig;
    }

    public final IoTJobTimeoutConfig timeoutConfig() {
        return this.timeoutConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobExecutionsRolloutConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.abortConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentIoTJobConfiguration)) {
            return false;
        }
        DeploymentIoTJobConfiguration other = (DeploymentIoTJobConfiguration)obj;
        return Objects.equals(this.jobExecutionsRolloutConfig(), other.jobExecutionsRolloutConfig()) && Objects.equals(this.abortConfig(), other.abortConfig()) && Objects.equals(this.timeoutConfig(), other.timeoutConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DeploymentIoTJobConfiguration").add("JobExecutionsRolloutConfig", (Object)this.jobExecutionsRolloutConfig()).add("AbortConfig", (Object)this.abortConfig()).add("TimeoutConfig", (Object)this.timeoutConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobExecutionsRolloutConfig": {
                return Optional.ofNullable(clazz.cast(this.jobExecutionsRolloutConfig()));
            }
            case "abortConfig": {
                return Optional.ofNullable(clazz.cast(this.abortConfig()));
            }
            case "timeoutConfig": {
                return Optional.ofNullable(clazz.cast(this.timeoutConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("jobExecutionsRolloutConfig", JOB_EXECUTIONS_ROLLOUT_CONFIG_FIELD);
        map.put("abortConfig", ABORT_CONFIG_FIELD);
        map.put("timeoutConfig", TIMEOUT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentIoTJobConfiguration, T> g) {
        return obj -> g.apply((DeploymentIoTJobConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private IoTJobExecutionsRolloutConfig jobExecutionsRolloutConfig;
        private IoTJobAbortConfig abortConfig;
        private IoTJobTimeoutConfig timeoutConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentIoTJobConfiguration model) {
            this.jobExecutionsRolloutConfig(model.jobExecutionsRolloutConfig);
            this.abortConfig(model.abortConfig);
            this.timeoutConfig(model.timeoutConfig);
        }

        public final IoTJobExecutionsRolloutConfig.Builder getJobExecutionsRolloutConfig() {
            return this.jobExecutionsRolloutConfig != null ? this.jobExecutionsRolloutConfig.toBuilder() : null;
        }

        public final void setJobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfig.BuilderImpl jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig != null ? jobExecutionsRolloutConfig.build() : null;
        }

        @Override
        public final Builder jobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfig jobExecutionsRolloutConfig) {
            this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
            return this;
        }

        public final IoTJobAbortConfig.Builder getAbortConfig() {
            return this.abortConfig != null ? this.abortConfig.toBuilder() : null;
        }

        public final void setAbortConfig(IoTJobAbortConfig.BuilderImpl abortConfig) {
            this.abortConfig = abortConfig != null ? abortConfig.build() : null;
        }

        @Override
        public final Builder abortConfig(IoTJobAbortConfig abortConfig) {
            this.abortConfig = abortConfig;
            return this;
        }

        public final IoTJobTimeoutConfig.Builder getTimeoutConfig() {
            return this.timeoutConfig != null ? this.timeoutConfig.toBuilder() : null;
        }

        public final void setTimeoutConfig(IoTJobTimeoutConfig.BuilderImpl timeoutConfig) {
            this.timeoutConfig = timeoutConfig != null ? timeoutConfig.build() : null;
        }

        @Override
        public final Builder timeoutConfig(IoTJobTimeoutConfig timeoutConfig) {
            this.timeoutConfig = timeoutConfig;
            return this;
        }

        public DeploymentIoTJobConfiguration build() {
            return new DeploymentIoTJobConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentIoTJobConfiguration> {
        public Builder jobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfig var1);

        default public Builder jobExecutionsRolloutConfig(Consumer<IoTJobExecutionsRolloutConfig.Builder> jobExecutionsRolloutConfig) {
            return this.jobExecutionsRolloutConfig((IoTJobExecutionsRolloutConfig)((IoTJobExecutionsRolloutConfig.Builder)IoTJobExecutionsRolloutConfig.builder().applyMutation(jobExecutionsRolloutConfig)).build());
        }

        public Builder abortConfig(IoTJobAbortConfig var1);

        default public Builder abortConfig(Consumer<IoTJobAbortConfig.Builder> abortConfig) {
            return this.abortConfig((IoTJobAbortConfig)((IoTJobAbortConfig.Builder)IoTJobAbortConfig.builder().applyMutation(abortConfig)).build());
        }

        public Builder timeoutConfig(IoTJobTimeoutConfig var1);

        default public Builder timeoutConfig(Consumer<IoTJobTimeoutConfig.Builder> timeoutConfig) {
            return this.timeoutConfig((IoTJobTimeoutConfig)((IoTJobTimeoutConfig.Builder)IoTJobTimeoutConfig.builder().applyMutation(timeoutConfig)).build());
        }
    }
}

