/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.greengrassv2.model.ComponentDeploymentSpecification;
import software.amazon.awssdk.services.greengrassv2.model.ComponentDeploymentSpecificationsCopier;
import software.amazon.awssdk.services.greengrassv2.model.DeploymentIoTJobConfiguration;
import software.amazon.awssdk.services.greengrassv2.model.DeploymentPolicies;
import software.amazon.awssdk.services.greengrassv2.model.DeploymentStatus;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Response;
import software.amazon.awssdk.services.greengrassv2.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDeploymentResponse
extends GreengrassV2Response
implements ToCopyableBuilder<Builder, GetDeploymentResponse> {
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(GetDeploymentResponse.getter(GetDeploymentResponse::targetArn)).setter(GetDeploymentResponse.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(GetDeploymentResponse.getter(GetDeploymentResponse::revisionId)).setter(GetDeploymentResponse.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(GetDeploymentResponse.getter(GetDeploymentResponse::deploymentId)).setter(GetDeploymentResponse.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> DEPLOYMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentName").getter(GetDeploymentResponse.getter(GetDeploymentResponse::deploymentName)).setter(GetDeploymentResponse.setter(Builder::deploymentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentStatus").getter(GetDeploymentResponse.getter(GetDeploymentResponse::deploymentStatusAsString)).setter(GetDeploymentResponse.setter(Builder::deploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStatus").build()}).build();
    private static final SdkField<String> IOT_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iotJobId").getter(GetDeploymentResponse.getter(GetDeploymentResponse::iotJobId)).setter(GetDeploymentResponse.setter(Builder::iotJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobId").build()}).build();
    private static final SdkField<String> IOT_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iotJobArn").getter(GetDeploymentResponse.getter(GetDeploymentResponse::iotJobArn)).setter(GetDeploymentResponse.setter(Builder::iotJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobArn").build()}).build();
    private static final SdkField<Map<String, ComponentDeploymentSpecification>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("components").getter(GetDeploymentResponse.getter(GetDeploymentResponse::components)).setter(GetDeploymentResponse.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentDeploymentSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<DeploymentPolicies> DEPLOYMENT_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentPolicies").getter(GetDeploymentResponse.getter(GetDeploymentResponse::deploymentPolicies)).setter(GetDeploymentResponse.setter(Builder::deploymentPolicies)).constructor(DeploymentPolicies::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentPolicies").build()}).build();
    private static final SdkField<DeploymentIoTJobConfiguration> IOT_JOB_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotJobConfiguration").getter(GetDeploymentResponse.getter(GetDeploymentResponse::iotJobConfiguration)).setter(GetDeploymentResponse.setter(Builder::iotJobConfiguration)).constructor(DeploymentIoTJobConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotJobConfiguration").build()}).build();
    private static final SdkField<Instant> CREATION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimestamp").getter(GetDeploymentResponse.getter(GetDeploymentResponse::creationTimestamp)).setter(GetDeploymentResponse.setter(Builder::creationTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTimestamp").build()}).build();
    private static final SdkField<Boolean> IS_LATEST_FOR_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isLatestForTarget").getter(GetDeploymentResponse.getter(GetDeploymentResponse::isLatestForTarget)).setter(GetDeploymentResponse.setter(Builder::isLatestForTarget)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLatestForTarget").build()}).build();
    private static final SdkField<String> PARENT_TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("parentTargetArn").getter(GetDeploymentResponse.getter(GetDeploymentResponse::parentTargetArn)).setter(GetDeploymentResponse.setter(Builder::parentTargetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentTargetArn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetDeploymentResponse.getter(GetDeploymentResponse::tags)).setter(GetDeploymentResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_ARN_FIELD, REVISION_ID_FIELD, DEPLOYMENT_ID_FIELD, DEPLOYMENT_NAME_FIELD, DEPLOYMENT_STATUS_FIELD, IOT_JOB_ID_FIELD, IOT_JOB_ARN_FIELD, COMPONENTS_FIELD, DEPLOYMENT_POLICIES_FIELD, IOT_JOB_CONFIGURATION_FIELD, CREATION_TIMESTAMP_FIELD, IS_LATEST_FOR_TARGET_FIELD, PARENT_TARGET_ARN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDeploymentResponse.memberNameToFieldInitializer();
    private final String targetArn;
    private final String revisionId;
    private final String deploymentId;
    private final String deploymentName;
    private final String deploymentStatus;
    private final String iotJobId;
    private final String iotJobArn;
    private final Map<String, ComponentDeploymentSpecification> components;
    private final DeploymentPolicies deploymentPolicies;
    private final DeploymentIoTJobConfiguration iotJobConfiguration;
    private final Instant creationTimestamp;
    private final Boolean isLatestForTarget;
    private final String parentTargetArn;
    private final Map<String, String> tags;

    private GetDeploymentResponse(BuilderImpl builder) {
        super(builder);
        this.targetArn = builder.targetArn;
        this.revisionId = builder.revisionId;
        this.deploymentId = builder.deploymentId;
        this.deploymentName = builder.deploymentName;
        this.deploymentStatus = builder.deploymentStatus;
        this.iotJobId = builder.iotJobId;
        this.iotJobArn = builder.iotJobArn;
        this.components = builder.components;
        this.deploymentPolicies = builder.deploymentPolicies;
        this.iotJobConfiguration = builder.iotJobConfiguration;
        this.creationTimestamp = builder.creationTimestamp;
        this.isLatestForTarget = builder.isLatestForTarget;
        this.parentTargetArn = builder.parentTargetArn;
        this.tags = builder.tags;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String deploymentName() {
        return this.deploymentName;
    }

    public final DeploymentStatus deploymentStatus() {
        return DeploymentStatus.fromValue(this.deploymentStatus);
    }

    public final String deploymentStatusAsString() {
        return this.deploymentStatus;
    }

    public final String iotJobId() {
        return this.iotJobId;
    }

    public final String iotJobArn() {
        return this.iotJobArn;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComponentDeploymentSpecification> components() {
        return this.components;
    }

    public final DeploymentPolicies deploymentPolicies() {
        return this.deploymentPolicies;
    }

    public final DeploymentIoTJobConfiguration iotJobConfiguration() {
        return this.iotJobConfiguration;
    }

    public final Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public final Boolean isLatestForTarget() {
        return this.isLatestForTarget;
    }

    public final String parentTargetArn() {
        return this.parentTargetArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotJobConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.isLatestForTarget());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDeploymentResponse)) {
            return false;
        }
        GetDeploymentResponse other = (GetDeploymentResponse)((Object)obj);
        return Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.deploymentName(), other.deploymentName()) && Objects.equals(this.deploymentStatusAsString(), other.deploymentStatusAsString()) && Objects.equals(this.iotJobId(), other.iotJobId()) && Objects.equals(this.iotJobArn(), other.iotJobArn()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components()) && Objects.equals(this.deploymentPolicies(), other.deploymentPolicies()) && Objects.equals(this.iotJobConfiguration(), other.iotJobConfiguration()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.isLatestForTarget(), other.isLatestForTarget()) && Objects.equals(this.parentTargetArn(), other.parentTargetArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetDeploymentResponse").add("TargetArn", (Object)this.targetArn()).add("RevisionId", (Object)this.revisionId()).add("DeploymentId", (Object)this.deploymentId()).add("DeploymentName", (Object)this.deploymentName()).add("DeploymentStatus", (Object)this.deploymentStatusAsString()).add("IotJobId", (Object)this.iotJobId()).add("IotJobArn", (Object)this.iotJobArn()).add("Components", this.hasComponents() ? this.components() : null).add("DeploymentPolicies", (Object)this.deploymentPolicies()).add("IotJobConfiguration", (Object)this.iotJobConfiguration()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("IsLatestForTarget", (Object)this.isLatestForTarget()).add("ParentTargetArn", (Object)this.parentTargetArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "deploymentName": {
                return Optional.ofNullable(clazz.cast(this.deploymentName()));
            }
            case "deploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.deploymentStatusAsString()));
            }
            case "iotJobId": {
                return Optional.ofNullable(clazz.cast(this.iotJobId()));
            }
            case "iotJobArn": {
                return Optional.ofNullable(clazz.cast(this.iotJobArn()));
            }
            case "components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "deploymentPolicies": {
                return Optional.ofNullable(clazz.cast(this.deploymentPolicies()));
            }
            case "iotJobConfiguration": {
                return Optional.ofNullable(clazz.cast(this.iotJobConfiguration()));
            }
            case "creationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "isLatestForTarget": {
                return Optional.ofNullable(clazz.cast(this.isLatestForTarget()));
            }
            case "parentTargetArn": {
                return Optional.ofNullable(clazz.cast(this.parentTargetArn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetArn", TARGET_ARN_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        map.put("deploymentId", DEPLOYMENT_ID_FIELD);
        map.put("deploymentName", DEPLOYMENT_NAME_FIELD);
        map.put("deploymentStatus", DEPLOYMENT_STATUS_FIELD);
        map.put("iotJobId", IOT_JOB_ID_FIELD);
        map.put("iotJobArn", IOT_JOB_ARN_FIELD);
        map.put("components", COMPONENTS_FIELD);
        map.put("deploymentPolicies", DEPLOYMENT_POLICIES_FIELD);
        map.put("iotJobConfiguration", IOT_JOB_CONFIGURATION_FIELD);
        map.put("creationTimestamp", CREATION_TIMESTAMP_FIELD);
        map.put("isLatestForTarget", IS_LATEST_FOR_TARGET_FIELD);
        map.put("parentTargetArn", PARENT_TARGET_ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDeploymentResponse, T> g) {
        return obj -> g.apply((GetDeploymentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Response.BuilderImpl
    implements Builder {
        private String targetArn;
        private String revisionId;
        private String deploymentId;
        private String deploymentName;
        private String deploymentStatus;
        private String iotJobId;
        private String iotJobArn;
        private Map<String, ComponentDeploymentSpecification> components = DefaultSdkAutoConstructMap.getInstance();
        private DeploymentPolicies deploymentPolicies;
        private DeploymentIoTJobConfiguration iotJobConfiguration;
        private Instant creationTimestamp;
        private Boolean isLatestForTarget;
        private String parentTargetArn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetDeploymentResponse model) {
            super(model);
            this.targetArn(model.targetArn);
            this.revisionId(model.revisionId);
            this.deploymentId(model.deploymentId);
            this.deploymentName(model.deploymentName);
            this.deploymentStatus(model.deploymentStatus);
            this.iotJobId(model.iotJobId);
            this.iotJobArn(model.iotJobArn);
            this.components(model.components);
            this.deploymentPolicies(model.deploymentPolicies);
            this.iotJobConfiguration(model.iotJobConfiguration);
            this.creationTimestamp(model.creationTimestamp);
            this.isLatestForTarget(model.isLatestForTarget);
            this.parentTargetArn(model.parentTargetArn);
            this.tags(model.tags);
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getDeploymentName() {
            return this.deploymentName;
        }

        public final void setDeploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
        }

        @Override
        public final Builder deploymentName(String deploymentName) {
            this.deploymentName = deploymentName;
            return this;
        }

        public final String getDeploymentStatus() {
            return this.deploymentStatus;
        }

        public final void setDeploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
        }

        @Override
        public final Builder deploymentStatus(String deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        @Override
        public final Builder deploymentStatus(DeploymentStatus deploymentStatus) {
            this.deploymentStatus(deploymentStatus == null ? null : deploymentStatus.toString());
            return this;
        }

        public final String getIotJobId() {
            return this.iotJobId;
        }

        public final void setIotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
        }

        @Override
        public final Builder iotJobId(String iotJobId) {
            this.iotJobId = iotJobId;
            return this;
        }

        public final String getIotJobArn() {
            return this.iotJobArn;
        }

        public final void setIotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
        }

        @Override
        public final Builder iotJobArn(String iotJobArn) {
            this.iotJobArn = iotJobArn;
            return this;
        }

        public final Map<String, ComponentDeploymentSpecification.Builder> getComponents() {
            Map<String, ComponentDeploymentSpecification.Builder> result = ComponentDeploymentSpecificationsCopier.copyToBuilder(this.components);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComponents(Map<String, ComponentDeploymentSpecification.BuilderImpl> components) {
            this.components = ComponentDeploymentSpecificationsCopier.copyFromBuilder(components);
        }

        @Override
        public final Builder components(Map<String, ComponentDeploymentSpecification> components) {
            this.components = ComponentDeploymentSpecificationsCopier.copy(components);
            return this;
        }

        public final DeploymentPolicies.Builder getDeploymentPolicies() {
            return this.deploymentPolicies != null ? this.deploymentPolicies.toBuilder() : null;
        }

        public final void setDeploymentPolicies(DeploymentPolicies.BuilderImpl deploymentPolicies) {
            this.deploymentPolicies = deploymentPolicies != null ? deploymentPolicies.build() : null;
        }

        @Override
        public final Builder deploymentPolicies(DeploymentPolicies deploymentPolicies) {
            this.deploymentPolicies = deploymentPolicies;
            return this;
        }

        public final DeploymentIoTJobConfiguration.Builder getIotJobConfiguration() {
            return this.iotJobConfiguration != null ? this.iotJobConfiguration.toBuilder() : null;
        }

        public final void setIotJobConfiguration(DeploymentIoTJobConfiguration.BuilderImpl iotJobConfiguration) {
            this.iotJobConfiguration = iotJobConfiguration != null ? iotJobConfiguration.build() : null;
        }

        @Override
        public final Builder iotJobConfiguration(DeploymentIoTJobConfiguration iotJobConfiguration) {
            this.iotJobConfiguration = iotJobConfiguration;
            return this;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final Boolean getIsLatestForTarget() {
            return this.isLatestForTarget;
        }

        public final void setIsLatestForTarget(Boolean isLatestForTarget) {
            this.isLatestForTarget = isLatestForTarget;
        }

        @Override
        public final Builder isLatestForTarget(Boolean isLatestForTarget) {
            this.isLatestForTarget = isLatestForTarget;
            return this;
        }

        public final String getParentTargetArn() {
            return this.parentTargetArn;
        }

        public final void setParentTargetArn(String parentTargetArn) {
            this.parentTargetArn = parentTargetArn;
        }

        @Override
        public final Builder parentTargetArn(String parentTargetArn) {
            this.parentTargetArn = parentTargetArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetDeploymentResponse build() {
            return new GetDeploymentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GreengrassV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDeploymentResponse> {
        public Builder targetArn(String var1);

        public Builder revisionId(String var1);

        public Builder deploymentId(String var1);

        public Builder deploymentName(String var1);

        public Builder deploymentStatus(String var1);

        public Builder deploymentStatus(DeploymentStatus var1);

        public Builder iotJobId(String var1);

        public Builder iotJobArn(String var1);

        public Builder components(Map<String, ComponentDeploymentSpecification> var1);

        public Builder deploymentPolicies(DeploymentPolicies var1);

        default public Builder deploymentPolicies(Consumer<DeploymentPolicies.Builder> deploymentPolicies) {
            return this.deploymentPolicies((DeploymentPolicies)((DeploymentPolicies.Builder)DeploymentPolicies.builder().applyMutation(deploymentPolicies)).build());
        }

        public Builder iotJobConfiguration(DeploymentIoTJobConfiguration var1);

        default public Builder iotJobConfiguration(Consumer<DeploymentIoTJobConfiguration.Builder> iotJobConfiguration) {
            return this.iotJobConfiguration((DeploymentIoTJobConfiguration)((DeploymentIoTJobConfiguration.Builder)DeploymentIoTJobConfiguration.builder().applyMutation(iotJobConfiguration)).build());
        }

        public Builder creationTimestamp(Instant var1);

        public Builder isLatestForTarget(Boolean var1);

        public Builder parentTargetArn(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

