/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrassv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.greengrassv2.model.ComponentCandidate;
import software.amazon.awssdk.services.greengrassv2.model.ComponentCandidateListCopier;
import software.amazon.awssdk.services.greengrassv2.model.ComponentPlatform;
import software.amazon.awssdk.services.greengrassv2.model.GreengrassV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResolveComponentCandidatesRequest
extends GreengrassV2Request
implements ToCopyableBuilder<Builder, ResolveComponentCandidatesRequest> {
    private static final SdkField<ComponentPlatform> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("platform").getter(ResolveComponentCandidatesRequest.getter(ResolveComponentCandidatesRequest::platform)).setter(ResolveComponentCandidatesRequest.setter(Builder::platform)).constructor(ComponentPlatform::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<List<ComponentCandidate>> COMPONENT_CANDIDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("componentCandidates").getter(ResolveComponentCandidatesRequest.getter(ResolveComponentCandidatesRequest::componentCandidates)).setter(ResolveComponentCandidatesRequest.setter(Builder::componentCandidates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentCandidates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentCandidate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLATFORM_FIELD, COMPONENT_CANDIDATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResolveComponentCandidatesRequest.memberNameToFieldInitializer();
    private final ComponentPlatform platform;
    private final List<ComponentCandidate> componentCandidates;

    private ResolveComponentCandidatesRequest(BuilderImpl builder) {
        super(builder);
        this.platform = builder.platform;
        this.componentCandidates = builder.componentCandidates;
    }

    public final ComponentPlatform platform() {
        return this.platform;
    }

    public final boolean hasComponentCandidates() {
        return this.componentCandidates != null && !(this.componentCandidates instanceof SdkAutoConstructList);
    }

    public final List<ComponentCandidate> componentCandidates() {
        return this.componentCandidates;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponentCandidates() ? this.componentCandidates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResolveComponentCandidatesRequest)) {
            return false;
        }
        ResolveComponentCandidatesRequest other = (ResolveComponentCandidatesRequest)((Object)obj);
        return Objects.equals(this.platform(), other.platform()) && this.hasComponentCandidates() == other.hasComponentCandidates() && Objects.equals(this.componentCandidates(), other.componentCandidates());
    }

    public final String toString() {
        return ToString.builder((String)"ResolveComponentCandidatesRequest").add("Platform", (Object)this.platform()).add("ComponentCandidates", this.hasComponentCandidates() ? this.componentCandidates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "componentCandidates": {
                return Optional.ofNullable(clazz.cast(this.componentCandidates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("platform", PLATFORM_FIELD);
        map.put("componentCandidates", COMPONENT_CANDIDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResolveComponentCandidatesRequest, T> g) {
        return obj -> g.apply((ResolveComponentCandidatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassV2Request.BuilderImpl
    implements Builder {
        private ComponentPlatform platform;
        private List<ComponentCandidate> componentCandidates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResolveComponentCandidatesRequest model) {
            super(model);
            this.platform(model.platform);
            this.componentCandidates(model.componentCandidates);
        }

        public final ComponentPlatform.Builder getPlatform() {
            return this.platform != null ? this.platform.toBuilder() : null;
        }

        public final void setPlatform(ComponentPlatform.BuilderImpl platform) {
            this.platform = platform != null ? platform.build() : null;
        }

        @Override
        public final Builder platform(ComponentPlatform platform) {
            this.platform = platform;
            return this;
        }

        public final List<ComponentCandidate.Builder> getComponentCandidates() {
            List<ComponentCandidate.Builder> result = ComponentCandidateListCopier.copyToBuilder(this.componentCandidates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComponentCandidates(Collection<ComponentCandidate.BuilderImpl> componentCandidates) {
            this.componentCandidates = ComponentCandidateListCopier.copyFromBuilder(componentCandidates);
        }

        @Override
        public final Builder componentCandidates(Collection<ComponentCandidate> componentCandidates) {
            this.componentCandidates = ComponentCandidateListCopier.copy(componentCandidates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentCandidates(ComponentCandidate ... componentCandidates) {
            this.componentCandidates(Arrays.asList(componentCandidates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentCandidates(Consumer<ComponentCandidate.Builder> ... componentCandidates) {
            this.componentCandidates(Stream.of(componentCandidates).map(c -> (ComponentCandidate)((ComponentCandidate.Builder)ComponentCandidate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResolveComponentCandidatesRequest build() {
            return new ResolveComponentCandidatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GreengrassV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResolveComponentCandidatesRequest> {
        public Builder platform(ComponentPlatform var1);

        default public Builder platform(Consumer<ComponentPlatform.Builder> platform) {
            return this.platform((ComponentPlatform)((ComponentPlatform.Builder)ComponentPlatform.builder().applyMutation(platform)).build());
        }

        public Builder componentCandidates(Collection<ComponentCandidate> var1);

        public Builder componentCandidates(ComponentCandidate ... var1);

        public Builder componentCandidates(Consumer<ComponentCandidate.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

