/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3RecordingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3RecordingConfig> {
    private static final SdkField<String> BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("bucketArn").getter(S3RecordingConfig.getter(S3RecordingConfig::bucketArn)).setter(S3RecordingConfig.setter(Builder::bucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bucketArn").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("prefix").getter(S3RecordingConfig.getter(S3RecordingConfig::prefix)).setter(S3RecordingConfig.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prefix").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(S3RecordingConfig.getter(S3RecordingConfig::roleArn)).setter(S3RecordingConfig.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_ARN_FIELD, PREFIX_FIELD, ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String bucketArn;
    private final String prefix;
    private final String roleArn;

    private S3RecordingConfig(BuilderImpl builder) {
        this.bucketArn = builder.bucketArn;
        this.prefix = builder.prefix;
        this.roleArn = builder.roleArn;
    }

    public final String bucketArn() {
        return this.bucketArn;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3RecordingConfig)) {
            return false;
        }
        S3RecordingConfig other = (S3RecordingConfig)obj;
        return Objects.equals(this.bucketArn(), other.bucketArn()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3RecordingConfig").add("BucketArn", (Object)this.bucketArn()).add("Prefix", (Object)this.prefix()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bucketArn": {
                return Optional.ofNullable(clazz.cast(this.bucketArn()));
            }
            case "prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3RecordingConfig, T> g) {
        return obj -> g.apply((S3RecordingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucketArn;
        private String prefix;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3RecordingConfig model) {
            this.bucketArn(model.bucketArn);
            this.prefix(model.prefix);
            this.roleArn(model.roleArn);
        }

        public final String getBucketArn() {
            return this.bucketArn;
        }

        public final void setBucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
        }

        @Override
        public final Builder bucketArn(String bucketArn) {
            this.bucketArn = bucketArn;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public S3RecordingConfig build() {
            return new S3RecordingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3RecordingConfig> {
        public Builder bucketArn(String var1);

        public Builder prefix(String var1);

        public Builder roleArn(String var1);
    }
}

