/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.AngleUnits;
import software.amazon.awssdk.services.groundstation.model.AzElSegment;
import software.amazon.awssdk.services.groundstation.model.AzElSegmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AzElSegments
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AzElSegments> {
    private static final SdkField<String> ANGLE_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("angleUnit").getter(AzElSegments.getter(AzElSegments::angleUnitAsString)).setter(AzElSegments.setter(Builder::angleUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("angleUnit").build()}).build();
    private static final SdkField<List<AzElSegment>> AZ_EL_SEGMENT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("azElSegmentList").getter(AzElSegments.getter(AzElSegments::azElSegmentList)).setter(AzElSegments.setter(Builder::azElSegmentList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("azElSegmentList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AzElSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANGLE_UNIT_FIELD, AZ_EL_SEGMENT_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AzElSegments.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String angleUnit;
    private final List<AzElSegment> azElSegmentList;

    private AzElSegments(BuilderImpl builder) {
        this.angleUnit = builder.angleUnit;
        this.azElSegmentList = builder.azElSegmentList;
    }

    public final AngleUnits angleUnit() {
        return AngleUnits.fromValue(this.angleUnit);
    }

    public final String angleUnitAsString() {
        return this.angleUnit;
    }

    public final boolean hasAzElSegmentList() {
        return this.azElSegmentList != null && !(this.azElSegmentList instanceof SdkAutoConstructList);
    }

    public final List<AzElSegment> azElSegmentList() {
        return this.azElSegmentList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.angleUnitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAzElSegmentList() ? this.azElSegmentList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AzElSegments)) {
            return false;
        }
        AzElSegments other = (AzElSegments)obj;
        return Objects.equals(this.angleUnitAsString(), other.angleUnitAsString()) && this.hasAzElSegmentList() == other.hasAzElSegmentList() && Objects.equals(this.azElSegmentList(), other.azElSegmentList());
    }

    public final String toString() {
        return ToString.builder((String)"AzElSegments").add("AngleUnit", (Object)this.angleUnitAsString()).add("AzElSegmentList", this.hasAzElSegmentList() ? this.azElSegmentList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "angleUnit": {
                return Optional.ofNullable(clazz.cast(this.angleUnitAsString()));
            }
            case "azElSegmentList": {
                return Optional.ofNullable(clazz.cast(this.azElSegmentList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("angleUnit", ANGLE_UNIT_FIELD);
        map.put("azElSegmentList", AZ_EL_SEGMENT_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AzElSegments, T> g) {
        return obj -> g.apply((AzElSegments)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String angleUnit;
        private List<AzElSegment> azElSegmentList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AzElSegments model) {
            this.angleUnit(model.angleUnit);
            this.azElSegmentList(model.azElSegmentList);
        }

        public final String getAngleUnit() {
            return this.angleUnit;
        }

        public final void setAngleUnit(String angleUnit) {
            this.angleUnit = angleUnit;
        }

        @Override
        public final Builder angleUnit(String angleUnit) {
            this.angleUnit = angleUnit;
            return this;
        }

        @Override
        public final Builder angleUnit(AngleUnits angleUnit) {
            this.angleUnit(angleUnit == null ? null : angleUnit.toString());
            return this;
        }

        public final List<AzElSegment.Builder> getAzElSegmentList() {
            List<AzElSegment.Builder> result = AzElSegmentListCopier.copyToBuilder(this.azElSegmentList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAzElSegmentList(Collection<AzElSegment.BuilderImpl> azElSegmentList) {
            this.azElSegmentList = AzElSegmentListCopier.copyFromBuilder(azElSegmentList);
        }

        @Override
        public final Builder azElSegmentList(Collection<AzElSegment> azElSegmentList) {
            this.azElSegmentList = AzElSegmentListCopier.copy(azElSegmentList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder azElSegmentList(AzElSegment ... azElSegmentList) {
            this.azElSegmentList(Arrays.asList(azElSegmentList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder azElSegmentList(Consumer<AzElSegment.Builder> ... azElSegmentList) {
            this.azElSegmentList(Stream.of(azElSegmentList).map(c -> (AzElSegment)((AzElSegment.Builder)AzElSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AzElSegments build() {
            return new AzElSegments(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AzElSegments> {
        public Builder angleUnit(String var1);

        public Builder angleUnit(AngleUnits var1);

        public Builder azElSegmentList(Collection<AzElSegment> var1);

        public Builder azElSegmentList(AzElSegment ... var1);

        public Builder azElSegmentList(Consumer<AzElSegment.Builder> ... var1);
    }
}

