/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.ConfigListCopier;
import software.amazon.awssdk.services.groundstation.model.ConfigListItem;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListConfigsResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, ListConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListConfigsResponse.getter(ListConfigsResponse::nextToken)).setter(ListConfigsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ConfigListItem>> CONFIG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("configList").getter(ListConfigsResponse.getter(ListConfigsResponse::configList)).setter(ListConfigsResponse.setter(Builder::configList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConfigListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, CONFIG_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListConfigsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ConfigListItem> configList;

    private ListConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.configList = builder.configList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasConfigList() {
        return this.configList != null && !(this.configList instanceof SdkAutoConstructList);
    }

    public final List<ConfigListItem> configList() {
        return this.configList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigList() ? this.configList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigsResponse)) {
            return false;
        }
        ListConfigsResponse other = (ListConfigsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasConfigList() == other.hasConfigList() && Objects.equals(this.configList(), other.configList());
    }

    public final String toString() {
        return ToString.builder((String)"ListConfigsResponse").add("NextToken", (Object)this.nextToken()).add("ConfigList", this.hasConfigList() ? this.configList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "configList": {
                return Optional.ofNullable(clazz.cast(this.configList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("configList", CONFIG_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConfigsResponse, T> g) {
        return obj -> g.apply((ListConfigsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ConfigListItem> configList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.configList(model.configList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ConfigListItem.Builder> getConfigList() {
            List<ConfigListItem.Builder> result = ConfigListCopier.copyToBuilder(this.configList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigList(Collection<ConfigListItem.BuilderImpl> configList) {
            this.configList = ConfigListCopier.copyFromBuilder(configList);
        }

        @Override
        public final Builder configList(Collection<ConfigListItem> configList) {
            this.configList = ConfigListCopier.copy(configList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configList(ConfigListItem ... configList) {
            this.configList(Arrays.asList(configList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configList(Consumer<ConfigListItem.Builder> ... configList) {
            this.configList(Stream.of(configList).map(c -> (ConfigListItem)((ConfigListItem.Builder)ConfigListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConfigsResponse build() {
            return new ListConfigsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListConfigsResponse> {
        public Builder nextToken(String var1);

        public Builder configList(Collection<ConfigListItem> var1);

        public Builder configList(ConfigListItem ... var1);

        public Builder configList(Consumer<ConfigListItem.Builder> ... var1);
    }
}

