/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.DataflowEndpointGroupListCopier;
import software.amazon.awssdk.services.groundstation.model.DataflowEndpointListItem;
import software.amazon.awssdk.services.groundstation.model.GroundStationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataflowEndpointGroupsResponse
extends GroundStationResponse
implements ToCopyableBuilder<Builder, ListDataflowEndpointGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataflowEndpointGroupsResponse.getter(ListDataflowEndpointGroupsResponse::nextToken)).setter(ListDataflowEndpointGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<DataflowEndpointListItem>> DATAFLOW_ENDPOINT_GROUP_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dataflowEndpointGroupList").getter(ListDataflowEndpointGroupsResponse.getter(ListDataflowEndpointGroupsResponse::dataflowEndpointGroupList)).setter(ListDataflowEndpointGroupsResponse.setter(Builder::dataflowEndpointGroupList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataflowEndpointGroupList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataflowEndpointListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DATAFLOW_ENDPOINT_GROUP_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataflowEndpointGroupsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<DataflowEndpointListItem> dataflowEndpointGroupList;

    private ListDataflowEndpointGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.dataflowEndpointGroupList = builder.dataflowEndpointGroupList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDataflowEndpointGroupList() {
        return this.dataflowEndpointGroupList != null && !(this.dataflowEndpointGroupList instanceof SdkAutoConstructList);
    }

    public final List<DataflowEndpointListItem> dataflowEndpointGroupList() {
        return this.dataflowEndpointGroupList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataflowEndpointGroupList() ? this.dataflowEndpointGroupList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataflowEndpointGroupsResponse)) {
            return false;
        }
        ListDataflowEndpointGroupsResponse other = (ListDataflowEndpointGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDataflowEndpointGroupList() == other.hasDataflowEndpointGroupList() && Objects.equals(this.dataflowEndpointGroupList(), other.dataflowEndpointGroupList());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataflowEndpointGroupsResponse").add("NextToken", (Object)this.nextToken()).add("DataflowEndpointGroupList", this.hasDataflowEndpointGroupList() ? this.dataflowEndpointGroupList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "dataflowEndpointGroupList": {
                return Optional.ofNullable(clazz.cast(this.dataflowEndpointGroupList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("dataflowEndpointGroupList", DATAFLOW_ENDPOINT_GROUP_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataflowEndpointGroupsResponse, T> g) {
        return obj -> g.apply((ListDataflowEndpointGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GroundStationResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DataflowEndpointListItem> dataflowEndpointGroupList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataflowEndpointGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.dataflowEndpointGroupList(model.dataflowEndpointGroupList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DataflowEndpointListItem.Builder> getDataflowEndpointGroupList() {
            List<DataflowEndpointListItem.Builder> result = DataflowEndpointGroupListCopier.copyToBuilder(this.dataflowEndpointGroupList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataflowEndpointGroupList(Collection<DataflowEndpointListItem.BuilderImpl> dataflowEndpointGroupList) {
            this.dataflowEndpointGroupList = DataflowEndpointGroupListCopier.copyFromBuilder(dataflowEndpointGroupList);
        }

        @Override
        public final Builder dataflowEndpointGroupList(Collection<DataflowEndpointListItem> dataflowEndpointGroupList) {
            this.dataflowEndpointGroupList = DataflowEndpointGroupListCopier.copy(dataflowEndpointGroupList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowEndpointGroupList(DataflowEndpointListItem ... dataflowEndpointGroupList) {
            this.dataflowEndpointGroupList(Arrays.asList(dataflowEndpointGroupList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataflowEndpointGroupList(Consumer<DataflowEndpointListItem.Builder> ... dataflowEndpointGroupList) {
            this.dataflowEndpointGroupList(Stream.of(dataflowEndpointGroupList).map(c -> (DataflowEndpointListItem)((DataflowEndpointListItem.Builder)DataflowEndpointListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDataflowEndpointGroupsResponse build() {
            return new ListDataflowEndpointGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GroundStationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataflowEndpointGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder dataflowEndpointGroupList(Collection<DataflowEndpointListItem> var1);

        public Builder dataflowEndpointGroupList(DataflowEndpointListItem ... var1);

        public Builder dataflowEndpointGroupList(Consumer<DataflowEndpointListItem.Builder> ... var1);
    }
}

