/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MissionProfileListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MissionProfileListItem> {
    private static final SdkField<String> MISSION_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("missionProfileId").getter(MissionProfileListItem.getter(MissionProfileListItem::missionProfileId)).setter(MissionProfileListItem.setter(Builder::missionProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileId").build()}).build();
    private static final SdkField<String> MISSION_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("missionProfileArn").getter(MissionProfileListItem.getter(MissionProfileListItem::missionProfileArn)).setter(MissionProfileListItem.setter(Builder::missionProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missionProfileArn").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(MissionProfileListItem.getter(MissionProfileListItem::region)).setter(MissionProfileListItem.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(MissionProfileListItem.getter(MissionProfileListItem::name)).setter(MissionProfileListItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MISSION_PROFILE_ID_FIELD, MISSION_PROFILE_ARN_FIELD, REGION_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MissionProfileListItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String missionProfileId;
    private final String missionProfileArn;
    private final String region;
    private final String name;

    private MissionProfileListItem(BuilderImpl builder) {
        this.missionProfileId = builder.missionProfileId;
        this.missionProfileArn = builder.missionProfileArn;
        this.region = builder.region;
        this.name = builder.name;
    }

    public final String missionProfileId() {
        return this.missionProfileId;
    }

    public final String missionProfileArn() {
        return this.missionProfileArn;
    }

    public final String region() {
        return this.region;
    }

    public final String name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.missionProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MissionProfileListItem)) {
            return false;
        }
        MissionProfileListItem other = (MissionProfileListItem)obj;
        return Objects.equals(this.missionProfileId(), other.missionProfileId()) && Objects.equals(this.missionProfileArn(), other.missionProfileArn()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"MissionProfileListItem").add("MissionProfileId", (Object)this.missionProfileId()).add("MissionProfileArn", (Object)this.missionProfileArn()).add("Region", (Object)this.region()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "missionProfileId": {
                return Optional.ofNullable(clazz.cast(this.missionProfileId()));
            }
            case "missionProfileArn": {
                return Optional.ofNullable(clazz.cast(this.missionProfileArn()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("missionProfileId", MISSION_PROFILE_ID_FIELD);
        map.put("missionProfileArn", MISSION_PROFILE_ARN_FIELD);
        map.put("region", REGION_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MissionProfileListItem, T> g) {
        return obj -> g.apply((MissionProfileListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String missionProfileId;
        private String missionProfileArn;
        private String region;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(MissionProfileListItem model) {
            this.missionProfileId(model.missionProfileId);
            this.missionProfileArn(model.missionProfileArn);
            this.region(model.region);
            this.name(model.name);
        }

        public final String getMissionProfileId() {
            return this.missionProfileId;
        }

        public final void setMissionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
        }

        @Override
        public final Builder missionProfileId(String missionProfileId) {
            this.missionProfileId = missionProfileId;
            return this;
        }

        public final String getMissionProfileArn() {
            return this.missionProfileArn;
        }

        public final void setMissionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
        }

        @Override
        public final Builder missionProfileArn(String missionProfileArn) {
            this.missionProfileArn = missionProfileArn;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public MissionProfileListItem build() {
            return new MissionProfileListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MissionProfileListItem> {
        public Builder missionProfileId(String var1);

        public Builder missionProfileArn(String var1);

        public Builder region(String var1);

        public Builder name(String var1);
    }
}

