/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.groundstation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.groundstation.model.EphemerisMetaData;
import software.amazon.awssdk.services.groundstation.model.GroundStationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SatelliteListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SatelliteListItem> {
    private static final SdkField<String> SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteId").getter(SatelliteListItem.getter(SatelliteListItem::satelliteId)).setter(SatelliteListItem.setter(Builder::satelliteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteId").build()}).build();
    private static final SdkField<String> SATELLITE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("satelliteArn").getter(SatelliteListItem.getter(SatelliteListItem::satelliteArn)).setter(SatelliteListItem.setter(Builder::satelliteArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("satelliteArn").build()}).build();
    private static final SdkField<Integer> NORAD_SATELLITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("noradSatelliteID").getter(SatelliteListItem.getter(SatelliteListItem::noradSatelliteID)).setter(SatelliteListItem.setter(Builder::noradSatelliteID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noradSatelliteID").build()}).build();
    private static final SdkField<List<String>> GROUND_STATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groundStations").getter(SatelliteListItem.getter(SatelliteListItem::groundStations)).setter(SatelliteListItem.setter(Builder::groundStations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groundStations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EphemerisMetaData> CURRENT_EPHEMERIS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("currentEphemeris").getter(SatelliteListItem.getter(SatelliteListItem::currentEphemeris)).setter(SatelliteListItem.setter(Builder::currentEphemeris)).constructor(EphemerisMetaData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentEphemeris").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SATELLITE_ID_FIELD, SATELLITE_ARN_FIELD, NORAD_SATELLITE_ID_FIELD, GROUND_STATIONS_FIELD, CURRENT_EPHEMERIS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SatelliteListItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String satelliteId;
    private final String satelliteArn;
    private final Integer noradSatelliteID;
    private final List<String> groundStations;
    private final EphemerisMetaData currentEphemeris;

    private SatelliteListItem(BuilderImpl builder) {
        this.satelliteId = builder.satelliteId;
        this.satelliteArn = builder.satelliteArn;
        this.noradSatelliteID = builder.noradSatelliteID;
        this.groundStations = builder.groundStations;
        this.currentEphemeris = builder.currentEphemeris;
    }

    public final String satelliteId() {
        return this.satelliteId;
    }

    public final String satelliteArn() {
        return this.satelliteArn;
    }

    public final Integer noradSatelliteID() {
        return this.noradSatelliteID;
    }

    public final boolean hasGroundStations() {
        return this.groundStations != null && !(this.groundStations instanceof SdkAutoConstructList);
    }

    public final List<String> groundStations() {
        return this.groundStations;
    }

    public final EphemerisMetaData currentEphemeris() {
        return this.currentEphemeris;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.satelliteArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.noradSatelliteID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroundStations() ? this.groundStations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.currentEphemeris());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SatelliteListItem)) {
            return false;
        }
        SatelliteListItem other = (SatelliteListItem)obj;
        return Objects.equals(this.satelliteId(), other.satelliteId()) && Objects.equals(this.satelliteArn(), other.satelliteArn()) && Objects.equals(this.noradSatelliteID(), other.noradSatelliteID()) && this.hasGroundStations() == other.hasGroundStations() && Objects.equals(this.groundStations(), other.groundStations()) && Objects.equals(this.currentEphemeris(), other.currentEphemeris());
    }

    public final String toString() {
        return ToString.builder((String)"SatelliteListItem").add("SatelliteId", (Object)this.satelliteId()).add("SatelliteArn", (Object)this.satelliteArn()).add("NoradSatelliteID", (Object)this.noradSatelliteID()).add("GroundStations", this.hasGroundStations() ? this.groundStations() : null).add("CurrentEphemeris", (Object)this.currentEphemeris()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "satelliteId": {
                return Optional.ofNullable(clazz.cast(this.satelliteId()));
            }
            case "satelliteArn": {
                return Optional.ofNullable(clazz.cast(this.satelliteArn()));
            }
            case "noradSatelliteID": {
                return Optional.ofNullable(clazz.cast(this.noradSatelliteID()));
            }
            case "groundStations": {
                return Optional.ofNullable(clazz.cast(this.groundStations()));
            }
            case "currentEphemeris": {
                return Optional.ofNullable(clazz.cast(this.currentEphemeris()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("satelliteId", SATELLITE_ID_FIELD);
        map.put("satelliteArn", SATELLITE_ARN_FIELD);
        map.put("noradSatelliteID", NORAD_SATELLITE_ID_FIELD);
        map.put("groundStations", GROUND_STATIONS_FIELD);
        map.put("currentEphemeris", CURRENT_EPHEMERIS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SatelliteListItem, T> g) {
        return obj -> g.apply((SatelliteListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String satelliteId;
        private String satelliteArn;
        private Integer noradSatelliteID;
        private List<String> groundStations = DefaultSdkAutoConstructList.getInstance();
        private EphemerisMetaData currentEphemeris;

        private BuilderImpl() {
        }

        private BuilderImpl(SatelliteListItem model) {
            this.satelliteId(model.satelliteId);
            this.satelliteArn(model.satelliteArn);
            this.noradSatelliteID(model.noradSatelliteID);
            this.groundStations(model.groundStations);
            this.currentEphemeris(model.currentEphemeris);
        }

        public final String getSatelliteId() {
            return this.satelliteId;
        }

        public final void setSatelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
        }

        @Override
        public final Builder satelliteId(String satelliteId) {
            this.satelliteId = satelliteId;
            return this;
        }

        public final String getSatelliteArn() {
            return this.satelliteArn;
        }

        public final void setSatelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
        }

        @Override
        public final Builder satelliteArn(String satelliteArn) {
            this.satelliteArn = satelliteArn;
            return this;
        }

        public final Integer getNoradSatelliteID() {
            return this.noradSatelliteID;
        }

        public final void setNoradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
        }

        @Override
        public final Builder noradSatelliteID(Integer noradSatelliteID) {
            this.noradSatelliteID = noradSatelliteID;
            return this;
        }

        public final Collection<String> getGroundStations() {
            if (this.groundStations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groundStations;
        }

        public final void setGroundStations(Collection<String> groundStations) {
            this.groundStations = GroundStationIdListCopier.copy(groundStations);
        }

        @Override
        public final Builder groundStations(Collection<String> groundStations) {
            this.groundStations = GroundStationIdListCopier.copy(groundStations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groundStations(String ... groundStations) {
            this.groundStations(Arrays.asList(groundStations));
            return this;
        }

        public final EphemerisMetaData.Builder getCurrentEphemeris() {
            return this.currentEphemeris != null ? this.currentEphemeris.toBuilder() : null;
        }

        public final void setCurrentEphemeris(EphemerisMetaData.BuilderImpl currentEphemeris) {
            this.currentEphemeris = currentEphemeris != null ? currentEphemeris.build() : null;
        }

        @Override
        public final Builder currentEphemeris(EphemerisMetaData currentEphemeris) {
            this.currentEphemeris = currentEphemeris;
            return this;
        }

        public SatelliteListItem build() {
            return new SatelliteListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SatelliteListItem> {
        public Builder satelliteId(String var1);

        public Builder satelliteArn(String var1);

        public Builder noradSatelliteID(Integer var1);

        public Builder groundStations(Collection<String> var1);

        public Builder groundStations(String ... var1);

        public Builder currentEphemeris(EphemerisMetaData var1);

        default public Builder currentEphemeris(Consumer<EphemerisMetaData.Builder> currentEphemeris) {
            return this.currentEphemeris((EphemerisMetaData)((EphemerisMetaData.Builder)EphemerisMetaData.builder().applyMutation(currentEphemeris)).build());
        }
    }
}

