/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.DataSourceFreeTrial;
import software.amazon.awssdk.services.guardduty.model.KubernetesDataSourceFreeTrial;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionDataSourceFreeTrial;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourcesFreeTrial
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourcesFreeTrial> {
    private static final SdkField<DataSourceFreeTrial> CLOUD_TRAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudTrail").getter(DataSourcesFreeTrial.getter(DataSourcesFreeTrial::cloudTrail)).setter(DataSourcesFreeTrial.setter(Builder::cloudTrail)).constructor(DataSourceFreeTrial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudTrail").build()}).build();
    private static final SdkField<DataSourceFreeTrial> DNS_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DnsLogs").getter(DataSourcesFreeTrial.getter(DataSourcesFreeTrial::dnsLogs)).setter(DataSourcesFreeTrial.setter(Builder::dnsLogs)).constructor(DataSourceFreeTrial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsLogs").build()}).build();
    private static final SdkField<DataSourceFreeTrial> FLOW_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FlowLogs").getter(DataSourcesFreeTrial.getter(DataSourcesFreeTrial::flowLogs)).setter(DataSourcesFreeTrial.setter(Builder::flowLogs)).constructor(DataSourceFreeTrial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowLogs").build()}).build();
    private static final SdkField<DataSourceFreeTrial> S3_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Logs").getter(DataSourcesFreeTrial.getter(DataSourcesFreeTrial::s3Logs)).setter(DataSourcesFreeTrial.setter(Builder::s3Logs)).constructor(DataSourceFreeTrial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Logs").build()}).build();
    private static final SdkField<KubernetesDataSourceFreeTrial> KUBERNETES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Kubernetes").getter(DataSourcesFreeTrial.getter(DataSourcesFreeTrial::kubernetes)).setter(DataSourcesFreeTrial.setter(Builder::kubernetes)).constructor(KubernetesDataSourceFreeTrial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetes").build()}).build();
    private static final SdkField<MalwareProtectionDataSourceFreeTrial> MALWARE_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MalwareProtection").getter(DataSourcesFreeTrial.getter(DataSourcesFreeTrial::malwareProtection)).setter(DataSourcesFreeTrial.setter(Builder::malwareProtection)).constructor(MalwareProtectionDataSourceFreeTrial::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("malwareProtection").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_TRAIL_FIELD, DNS_LOGS_FIELD, FLOW_LOGS_FIELD, S3_LOGS_FIELD, KUBERNETES_FIELD, MALWARE_PROTECTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final DataSourceFreeTrial cloudTrail;
    private final DataSourceFreeTrial dnsLogs;
    private final DataSourceFreeTrial flowLogs;
    private final DataSourceFreeTrial s3Logs;
    private final KubernetesDataSourceFreeTrial kubernetes;
    private final MalwareProtectionDataSourceFreeTrial malwareProtection;

    private DataSourcesFreeTrial(BuilderImpl builder) {
        this.cloudTrail = builder.cloudTrail;
        this.dnsLogs = builder.dnsLogs;
        this.flowLogs = builder.flowLogs;
        this.s3Logs = builder.s3Logs;
        this.kubernetes = builder.kubernetes;
        this.malwareProtection = builder.malwareProtection;
    }

    public final DataSourceFreeTrial cloudTrail() {
        return this.cloudTrail;
    }

    public final DataSourceFreeTrial dnsLogs() {
        return this.dnsLogs;
    }

    public final DataSourceFreeTrial flowLogs() {
        return this.flowLogs;
    }

    public final DataSourceFreeTrial s3Logs() {
        return this.s3Logs;
    }

    public final KubernetesDataSourceFreeTrial kubernetes() {
        return this.kubernetes;
    }

    public final MalwareProtectionDataSourceFreeTrial malwareProtection() {
        return this.malwareProtection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudTrail());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.flowLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Logs());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetes());
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareProtection());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourcesFreeTrial)) {
            return false;
        }
        DataSourcesFreeTrial other = (DataSourcesFreeTrial)obj;
        return Objects.equals(this.cloudTrail(), other.cloudTrail()) && Objects.equals(this.dnsLogs(), other.dnsLogs()) && Objects.equals(this.flowLogs(), other.flowLogs()) && Objects.equals(this.s3Logs(), other.s3Logs()) && Objects.equals(this.kubernetes(), other.kubernetes()) && Objects.equals(this.malwareProtection(), other.malwareProtection());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourcesFreeTrial").add("CloudTrail", (Object)this.cloudTrail()).add("DnsLogs", (Object)this.dnsLogs()).add("FlowLogs", (Object)this.flowLogs()).add("S3Logs", (Object)this.s3Logs()).add("Kubernetes", (Object)this.kubernetes()).add("MalwareProtection", (Object)this.malwareProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudTrail": {
                return Optional.ofNullable(clazz.cast(this.cloudTrail()));
            }
            case "DnsLogs": {
                return Optional.ofNullable(clazz.cast(this.dnsLogs()));
            }
            case "FlowLogs": {
                return Optional.ofNullable(clazz.cast(this.flowLogs()));
            }
            case "S3Logs": {
                return Optional.ofNullable(clazz.cast(this.s3Logs()));
            }
            case "Kubernetes": {
                return Optional.ofNullable(clazz.cast(this.kubernetes()));
            }
            case "MalwareProtection": {
                return Optional.ofNullable(clazz.cast(this.malwareProtection()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourcesFreeTrial, T> g) {
        return obj -> g.apply((DataSourcesFreeTrial)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataSourceFreeTrial cloudTrail;
        private DataSourceFreeTrial dnsLogs;
        private DataSourceFreeTrial flowLogs;
        private DataSourceFreeTrial s3Logs;
        private KubernetesDataSourceFreeTrial kubernetes;
        private MalwareProtectionDataSourceFreeTrial malwareProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourcesFreeTrial model) {
            this.cloudTrail(model.cloudTrail);
            this.dnsLogs(model.dnsLogs);
            this.flowLogs(model.flowLogs);
            this.s3Logs(model.s3Logs);
            this.kubernetes(model.kubernetes);
            this.malwareProtection(model.malwareProtection);
        }

        public final DataSourceFreeTrial.Builder getCloudTrail() {
            return this.cloudTrail != null ? this.cloudTrail.toBuilder() : null;
        }

        public final void setCloudTrail(DataSourceFreeTrial.BuilderImpl cloudTrail) {
            this.cloudTrail = cloudTrail != null ? cloudTrail.build() : null;
        }

        @Override
        public final Builder cloudTrail(DataSourceFreeTrial cloudTrail) {
            this.cloudTrail = cloudTrail;
            return this;
        }

        public final DataSourceFreeTrial.Builder getDnsLogs() {
            return this.dnsLogs != null ? this.dnsLogs.toBuilder() : null;
        }

        public final void setDnsLogs(DataSourceFreeTrial.BuilderImpl dnsLogs) {
            this.dnsLogs = dnsLogs != null ? dnsLogs.build() : null;
        }

        @Override
        public final Builder dnsLogs(DataSourceFreeTrial dnsLogs) {
            this.dnsLogs = dnsLogs;
            return this;
        }

        public final DataSourceFreeTrial.Builder getFlowLogs() {
            return this.flowLogs != null ? this.flowLogs.toBuilder() : null;
        }

        public final void setFlowLogs(DataSourceFreeTrial.BuilderImpl flowLogs) {
            this.flowLogs = flowLogs != null ? flowLogs.build() : null;
        }

        @Override
        public final Builder flowLogs(DataSourceFreeTrial flowLogs) {
            this.flowLogs = flowLogs;
            return this;
        }

        public final DataSourceFreeTrial.Builder getS3Logs() {
            return this.s3Logs != null ? this.s3Logs.toBuilder() : null;
        }

        public final void setS3Logs(DataSourceFreeTrial.BuilderImpl s3Logs) {
            this.s3Logs = s3Logs != null ? s3Logs.build() : null;
        }

        @Override
        public final Builder s3Logs(DataSourceFreeTrial s3Logs) {
            this.s3Logs = s3Logs;
            return this;
        }

        public final KubernetesDataSourceFreeTrial.Builder getKubernetes() {
            return this.kubernetes != null ? this.kubernetes.toBuilder() : null;
        }

        public final void setKubernetes(KubernetesDataSourceFreeTrial.BuilderImpl kubernetes) {
            this.kubernetes = kubernetes != null ? kubernetes.build() : null;
        }

        @Override
        public final Builder kubernetes(KubernetesDataSourceFreeTrial kubernetes) {
            this.kubernetes = kubernetes;
            return this;
        }

        public final MalwareProtectionDataSourceFreeTrial.Builder getMalwareProtection() {
            return this.malwareProtection != null ? this.malwareProtection.toBuilder() : null;
        }

        public final void setMalwareProtection(MalwareProtectionDataSourceFreeTrial.BuilderImpl malwareProtection) {
            this.malwareProtection = malwareProtection != null ? malwareProtection.build() : null;
        }

        @Override
        public final Builder malwareProtection(MalwareProtectionDataSourceFreeTrial malwareProtection) {
            this.malwareProtection = malwareProtection;
            return this;
        }

        public DataSourcesFreeTrial build() {
            return new DataSourcesFreeTrial(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourcesFreeTrial> {
        public Builder cloudTrail(DataSourceFreeTrial var1);

        default public Builder cloudTrail(Consumer<DataSourceFreeTrial.Builder> cloudTrail) {
            return this.cloudTrail((DataSourceFreeTrial)((DataSourceFreeTrial.Builder)DataSourceFreeTrial.builder().applyMutation(cloudTrail)).build());
        }

        public Builder dnsLogs(DataSourceFreeTrial var1);

        default public Builder dnsLogs(Consumer<DataSourceFreeTrial.Builder> dnsLogs) {
            return this.dnsLogs((DataSourceFreeTrial)((DataSourceFreeTrial.Builder)DataSourceFreeTrial.builder().applyMutation(dnsLogs)).build());
        }

        public Builder flowLogs(DataSourceFreeTrial var1);

        default public Builder flowLogs(Consumer<DataSourceFreeTrial.Builder> flowLogs) {
            return this.flowLogs((DataSourceFreeTrial)((DataSourceFreeTrial.Builder)DataSourceFreeTrial.builder().applyMutation(flowLogs)).build());
        }

        public Builder s3Logs(DataSourceFreeTrial var1);

        default public Builder s3Logs(Consumer<DataSourceFreeTrial.Builder> s3Logs) {
            return this.s3Logs((DataSourceFreeTrial)((DataSourceFreeTrial.Builder)DataSourceFreeTrial.builder().applyMutation(s3Logs)).build());
        }

        public Builder kubernetes(KubernetesDataSourceFreeTrial var1);

        default public Builder kubernetes(Consumer<KubernetesDataSourceFreeTrial.Builder> kubernetes) {
            return this.kubernetes((KubernetesDataSourceFreeTrial)((KubernetesDataSourceFreeTrial.Builder)KubernetesDataSourceFreeTrial.builder().applyMutation(kubernetes)).build());
        }

        public Builder malwareProtection(MalwareProtectionDataSourceFreeTrial var1);

        default public Builder malwareProtection(Consumer<MalwareProtectionDataSourceFreeTrial.Builder> malwareProtection) {
            return this.malwareProtection((MalwareProtectionDataSourceFreeTrial)((MalwareProtectionDataSourceFreeTrial.Builder)MalwareProtectionDataSourceFreeTrial.builder().applyMutation(malwareProtection)).build());
        }
    }
}

