/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.FreeTrialFeatureResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FreeTrialFeatureConfigurationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FreeTrialFeatureConfigurationResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FreeTrialFeatureConfigurationResult.getter(FreeTrialFeatureConfigurationResult::nameAsString)).setter(FreeTrialFeatureConfigurationResult.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> FREE_TRIAL_DAYS_REMAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FreeTrialDaysRemaining").getter(FreeTrialFeatureConfigurationResult.getter(FreeTrialFeatureConfigurationResult::freeTrialDaysRemaining)).setter(FreeTrialFeatureConfigurationResult.setter(Builder::freeTrialDaysRemaining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("freeTrialDaysRemaining").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, FREE_TRIAL_DAYS_REMAINING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FreeTrialFeatureConfigurationResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Integer freeTrialDaysRemaining;

    private FreeTrialFeatureConfigurationResult(BuilderImpl builder) {
        this.name = builder.name;
        this.freeTrialDaysRemaining = builder.freeTrialDaysRemaining;
    }

    public final FreeTrialFeatureResult name() {
        return FreeTrialFeatureResult.fromValue(this.name);
    }

    public final String nameAsString() {
        return this.name;
    }

    public final Integer freeTrialDaysRemaining() {
        return this.freeTrialDaysRemaining;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.freeTrialDaysRemaining());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FreeTrialFeatureConfigurationResult)) {
            return false;
        }
        FreeTrialFeatureConfigurationResult other = (FreeTrialFeatureConfigurationResult)obj;
        return Objects.equals(this.nameAsString(), other.nameAsString()) && Objects.equals(this.freeTrialDaysRemaining(), other.freeTrialDaysRemaining());
    }

    public final String toString() {
        return ToString.builder((String)"FreeTrialFeatureConfigurationResult").add("Name", (Object)this.nameAsString()).add("FreeTrialDaysRemaining", (Object)this.freeTrialDaysRemaining()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.nameAsString()));
            }
            case "FreeTrialDaysRemaining": {
                return Optional.ofNullable(clazz.cast(this.freeTrialDaysRemaining()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("freeTrialDaysRemaining", FREE_TRIAL_DAYS_REMAINING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FreeTrialFeatureConfigurationResult, T> g) {
        return obj -> g.apply((FreeTrialFeatureConfigurationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Integer freeTrialDaysRemaining;

        private BuilderImpl() {
        }

        private BuilderImpl(FreeTrialFeatureConfigurationResult model) {
            this.name(model.name);
            this.freeTrialDaysRemaining(model.freeTrialDaysRemaining);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(FreeTrialFeatureResult name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final Integer getFreeTrialDaysRemaining() {
            return this.freeTrialDaysRemaining;
        }

        public final void setFreeTrialDaysRemaining(Integer freeTrialDaysRemaining) {
            this.freeTrialDaysRemaining = freeTrialDaysRemaining;
        }

        @Override
        public final Builder freeTrialDaysRemaining(Integer freeTrialDaysRemaining) {
            this.freeTrialDaysRemaining = freeTrialDaysRemaining;
            return this;
        }

        public FreeTrialFeatureConfigurationResult build() {
            return new FreeTrialFeatureConfigurationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FreeTrialFeatureConfigurationResult> {
        public Builder name(String var1);

        public Builder name(FreeTrialFeatureResult var1);

        public Builder freeTrialDaysRemaining(Integer var1);
    }
}

