/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.ScanResultStatus;
import software.amazon.awssdk.services.guardduty.model.ScanResultThreat;
import software.amazon.awssdk.services.guardduty.model.ScanResultThreatsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMalwareScanResultDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GetMalwareScanResultDetails> {
    private static final SdkField<String> SCAN_RESULT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanResultStatus").getter(GetMalwareScanResultDetails.getter(GetMalwareScanResultDetails::scanResultStatusAsString)).setter(GetMalwareScanResultDetails.setter(Builder::scanResultStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanResultStatus").build()}).build();
    private static final SdkField<Long> SKIPPED_FILE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SkippedFileCount").getter(GetMalwareScanResultDetails.getter(GetMalwareScanResultDetails::skippedFileCount)).setter(GetMalwareScanResultDetails.setter(Builder::skippedFileCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedFileCount").build()}).build();
    private static final SdkField<Long> FAILED_FILE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FailedFileCount").getter(GetMalwareScanResultDetails.getter(GetMalwareScanResultDetails::failedFileCount)).setter(GetMalwareScanResultDetails.setter(Builder::failedFileCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedFileCount").build()}).build();
    private static final SdkField<Long> THREAT_FOUND_FILE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ThreatFoundFileCount").getter(GetMalwareScanResultDetails.getter(GetMalwareScanResultDetails::threatFoundFileCount)).setter(GetMalwareScanResultDetails.setter(Builder::threatFoundFileCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatFoundFileCount").build()}).build();
    private static final SdkField<Long> TOTAL_FILE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalFileCount").getter(GetMalwareScanResultDetails.getter(GetMalwareScanResultDetails::totalFileCount)).setter(GetMalwareScanResultDetails.setter(Builder::totalFileCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalFileCount").build()}).build();
    private static final SdkField<Long> TOTAL_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalBytes").getter(GetMalwareScanResultDetails.getter(GetMalwareScanResultDetails::totalBytes)).setter(GetMalwareScanResultDetails.setter(Builder::totalBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalBytes").build()}).build();
    private static final SdkField<Long> UNIQUE_THREAT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("UniqueThreatCount").getter(GetMalwareScanResultDetails.getter(GetMalwareScanResultDetails::uniqueThreatCount)).setter(GetMalwareScanResultDetails.setter(Builder::uniqueThreatCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueThreatCount").build()}).build();
    private static final SdkField<List<ScanResultThreat>> THREATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Threats").getter(GetMalwareScanResultDetails.getter(GetMalwareScanResultDetails::threats)).setter(GetMalwareScanResultDetails.setter(Builder::threats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanResultThreat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCAN_RESULT_STATUS_FIELD, SKIPPED_FILE_COUNT_FIELD, FAILED_FILE_COUNT_FIELD, THREAT_FOUND_FILE_COUNT_FIELD, TOTAL_FILE_COUNT_FIELD, TOTAL_BYTES_FIELD, UNIQUE_THREAT_COUNT_FIELD, THREATS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetMalwareScanResultDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String scanResultStatus;
    private final Long skippedFileCount;
    private final Long failedFileCount;
    private final Long threatFoundFileCount;
    private final Long totalFileCount;
    private final Long totalBytes;
    private final Long uniqueThreatCount;
    private final List<ScanResultThreat> threats;

    private GetMalwareScanResultDetails(BuilderImpl builder) {
        this.scanResultStatus = builder.scanResultStatus;
        this.skippedFileCount = builder.skippedFileCount;
        this.failedFileCount = builder.failedFileCount;
        this.threatFoundFileCount = builder.threatFoundFileCount;
        this.totalFileCount = builder.totalFileCount;
        this.totalBytes = builder.totalBytes;
        this.uniqueThreatCount = builder.uniqueThreatCount;
        this.threats = builder.threats;
    }

    public final ScanResultStatus scanResultStatus() {
        return ScanResultStatus.fromValue(this.scanResultStatus);
    }

    public final String scanResultStatusAsString() {
        return this.scanResultStatus;
    }

    public final Long skippedFileCount() {
        return this.skippedFileCount;
    }

    public final Long failedFileCount() {
        return this.failedFileCount;
    }

    public final Long threatFoundFileCount() {
        return this.threatFoundFileCount;
    }

    public final Long totalFileCount() {
        return this.totalFileCount;
    }

    public final Long totalBytes() {
        return this.totalBytes;
    }

    public final Long uniqueThreatCount() {
        return this.uniqueThreatCount;
    }

    public final boolean hasThreats() {
        return this.threats != null && !(this.threats instanceof SdkAutoConstructList);
    }

    public final List<ScanResultThreat> threats() {
        return this.threats;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scanResultStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.skippedFileCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedFileCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.threatFoundFileCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalFileCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueThreatCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreats() ? this.threats() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMalwareScanResultDetails)) {
            return false;
        }
        GetMalwareScanResultDetails other = (GetMalwareScanResultDetails)obj;
        return Objects.equals(this.scanResultStatusAsString(), other.scanResultStatusAsString()) && Objects.equals(this.skippedFileCount(), other.skippedFileCount()) && Objects.equals(this.failedFileCount(), other.failedFileCount()) && Objects.equals(this.threatFoundFileCount(), other.threatFoundFileCount()) && Objects.equals(this.totalFileCount(), other.totalFileCount()) && Objects.equals(this.totalBytes(), other.totalBytes()) && Objects.equals(this.uniqueThreatCount(), other.uniqueThreatCount()) && this.hasThreats() == other.hasThreats() && Objects.equals(this.threats(), other.threats());
    }

    public final String toString() {
        return ToString.builder((String)"GetMalwareScanResultDetails").add("ScanResultStatus", (Object)this.scanResultStatusAsString()).add("SkippedFileCount", (Object)this.skippedFileCount()).add("FailedFileCount", (Object)this.failedFileCount()).add("ThreatFoundFileCount", (Object)this.threatFoundFileCount()).add("TotalFileCount", (Object)this.totalFileCount()).add("TotalBytes", (Object)this.totalBytes()).add("UniqueThreatCount", (Object)this.uniqueThreatCount()).add("Threats", this.hasThreats() ? this.threats() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScanResultStatus": {
                return Optional.ofNullable(clazz.cast(this.scanResultStatusAsString()));
            }
            case "SkippedFileCount": {
                return Optional.ofNullable(clazz.cast(this.skippedFileCount()));
            }
            case "FailedFileCount": {
                return Optional.ofNullable(clazz.cast(this.failedFileCount()));
            }
            case "ThreatFoundFileCount": {
                return Optional.ofNullable(clazz.cast(this.threatFoundFileCount()));
            }
            case "TotalFileCount": {
                return Optional.ofNullable(clazz.cast(this.totalFileCount()));
            }
            case "TotalBytes": {
                return Optional.ofNullable(clazz.cast(this.totalBytes()));
            }
            case "UniqueThreatCount": {
                return Optional.ofNullable(clazz.cast(this.uniqueThreatCount()));
            }
            case "Threats": {
                return Optional.ofNullable(clazz.cast(this.threats()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("scanResultStatus", SCAN_RESULT_STATUS_FIELD);
        map.put("skippedFileCount", SKIPPED_FILE_COUNT_FIELD);
        map.put("failedFileCount", FAILED_FILE_COUNT_FIELD);
        map.put("threatFoundFileCount", THREAT_FOUND_FILE_COUNT_FIELD);
        map.put("totalFileCount", TOTAL_FILE_COUNT_FIELD);
        map.put("totalBytes", TOTAL_BYTES_FIELD);
        map.put("uniqueThreatCount", UNIQUE_THREAT_COUNT_FIELD);
        map.put("threats", THREATS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetMalwareScanResultDetails, T> g) {
        return obj -> g.apply((GetMalwareScanResultDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String scanResultStatus;
        private Long skippedFileCount;
        private Long failedFileCount;
        private Long threatFoundFileCount;
        private Long totalFileCount;
        private Long totalBytes;
        private Long uniqueThreatCount;
        private List<ScanResultThreat> threats = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMalwareScanResultDetails model) {
            this.scanResultStatus(model.scanResultStatus);
            this.skippedFileCount(model.skippedFileCount);
            this.failedFileCount(model.failedFileCount);
            this.threatFoundFileCount(model.threatFoundFileCount);
            this.totalFileCount(model.totalFileCount);
            this.totalBytes(model.totalBytes);
            this.uniqueThreatCount(model.uniqueThreatCount);
            this.threats(model.threats);
        }

        public final String getScanResultStatus() {
            return this.scanResultStatus;
        }

        public final void setScanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
        }

        @Override
        public final Builder scanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
            return this;
        }

        @Override
        public final Builder scanResultStatus(ScanResultStatus scanResultStatus) {
            this.scanResultStatus(scanResultStatus == null ? null : scanResultStatus.toString());
            return this;
        }

        public final Long getSkippedFileCount() {
            return this.skippedFileCount;
        }

        public final void setSkippedFileCount(Long skippedFileCount) {
            this.skippedFileCount = skippedFileCount;
        }

        @Override
        public final Builder skippedFileCount(Long skippedFileCount) {
            this.skippedFileCount = skippedFileCount;
            return this;
        }

        public final Long getFailedFileCount() {
            return this.failedFileCount;
        }

        public final void setFailedFileCount(Long failedFileCount) {
            this.failedFileCount = failedFileCount;
        }

        @Override
        public final Builder failedFileCount(Long failedFileCount) {
            this.failedFileCount = failedFileCount;
            return this;
        }

        public final Long getThreatFoundFileCount() {
            return this.threatFoundFileCount;
        }

        public final void setThreatFoundFileCount(Long threatFoundFileCount) {
            this.threatFoundFileCount = threatFoundFileCount;
        }

        @Override
        public final Builder threatFoundFileCount(Long threatFoundFileCount) {
            this.threatFoundFileCount = threatFoundFileCount;
            return this;
        }

        public final Long getTotalFileCount() {
            return this.totalFileCount;
        }

        public final void setTotalFileCount(Long totalFileCount) {
            this.totalFileCount = totalFileCount;
        }

        @Override
        public final Builder totalFileCount(Long totalFileCount) {
            this.totalFileCount = totalFileCount;
            return this;
        }

        public final Long getTotalBytes() {
            return this.totalBytes;
        }

        public final void setTotalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
        }

        @Override
        public final Builder totalBytes(Long totalBytes) {
            this.totalBytes = totalBytes;
            return this;
        }

        public final Long getUniqueThreatCount() {
            return this.uniqueThreatCount;
        }

        public final void setUniqueThreatCount(Long uniqueThreatCount) {
            this.uniqueThreatCount = uniqueThreatCount;
        }

        @Override
        public final Builder uniqueThreatCount(Long uniqueThreatCount) {
            this.uniqueThreatCount = uniqueThreatCount;
            return this;
        }

        public final List<ScanResultThreat.Builder> getThreats() {
            List<ScanResultThreat.Builder> result = ScanResultThreatsCopier.copyToBuilder(this.threats);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreats(Collection<ScanResultThreat.BuilderImpl> threats) {
            this.threats = ScanResultThreatsCopier.copyFromBuilder(threats);
        }

        @Override
        public final Builder threats(Collection<ScanResultThreat> threats) {
            this.threats = ScanResultThreatsCopier.copy(threats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threats(ScanResultThreat ... threats) {
            this.threats(Arrays.asList(threats));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threats(Consumer<ScanResultThreat.Builder> ... threats) {
            this.threats(Stream.of(threats).map(c -> (ScanResultThreat)((ScanResultThreat.Builder)ScanResultThreat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GetMalwareScanResultDetails build() {
            return new GetMalwareScanResultDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GetMalwareScanResultDetails> {
        public Builder scanResultStatus(String var1);

        public Builder scanResultStatus(ScanResultStatus var1);

        public Builder skippedFileCount(Long var1);

        public Builder failedFileCount(Long var1);

        public Builder threatFoundFileCount(Long var1);

        public Builder totalFileCount(Long var1);

        public Builder totalBytes(Long var1);

        public Builder uniqueThreatCount(Long var1);

        public Builder threats(Collection<ScanResultThreat> var1);

        public Builder threats(ScanResultThreat ... var1);

        public Builder threats(Consumer<ScanResultThreat.Builder> ... var1);
    }
}

