/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KubernetesResourcesTypes {
    PODS("PODS"),
    JOBS("JOBS"),
    CRONJOBS("CRONJOBS"),
    DEPLOYMENTS("DEPLOYMENTS"),
    DAEMONSETS("DAEMONSETS"),
    STATEFULSETS("STATEFULSETS"),
    REPLICASETS("REPLICASETS"),
    REPLICATIONCONTROLLERS("REPLICATIONCONTROLLERS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KubernetesResourcesTypes> VALUE_MAP;
    private final String value;

    private KubernetesResourcesTypes(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KubernetesResourcesTypes fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KubernetesResourcesTypes> knownValues() {
        EnumSet<KubernetesResourcesTypes> knownValues = EnumSet.allOf(KubernetesResourcesTypes.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KubernetesResourcesTypes.class, KubernetesResourcesTypes::toString);
    }
}

