/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MalwareProtectionScanType {
    BACKUP_INITIATED("BACKUP_INITIATED"),
    ON_DEMAND("ON_DEMAND"),
    GUARDDUTY_INITIATED("GUARDDUTY_INITIATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MalwareProtectionScanType> VALUE_MAP;
    private final String value;

    private MalwareProtectionScanType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MalwareProtectionScanType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MalwareProtectionScanType> knownValues() {
        EnumSet<MalwareProtectionScanType> knownValues = EnumSet.allOf(MalwareProtectionScanType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MalwareProtectionScanType.class, MalwareProtectionScanType::toString);
    }
}

