/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionFindingsScanConfiguration;
import software.amazon.awssdk.services.guardduty.model.MalwareProtectionScanType;
import software.amazon.awssdk.services.guardduty.model.ScanCategory;
import software.amazon.awssdk.services.guardduty.model.Threat;
import software.amazon.awssdk.services.guardduty.model.ThreatsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MalwareScanDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MalwareScanDetails> {
    private static final SdkField<List<Threat>> THREATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Threats").getter(MalwareScanDetails.getter(MalwareScanDetails::threats)).setter(MalwareScanDetails.setter(Builder::threats)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threats").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Threat::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanId").getter(MalwareScanDetails.getter(MalwareScanDetails::scanId)).setter(MalwareScanDetails.setter(Builder::scanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanId").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(MalwareScanDetails.getter(MalwareScanDetails::scanTypeAsString)).setter(MalwareScanDetails.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanType").build()}).build();
    private static final SdkField<String> SCAN_CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanCategory").getter(MalwareScanDetails.getter(MalwareScanDetails::scanCategoryAsString)).setter(MalwareScanDetails.setter(Builder::scanCategory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanCategory").build()}).build();
    private static final SdkField<MalwareProtectionFindingsScanConfiguration> SCAN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScanConfiguration").getter(MalwareScanDetails.getter(MalwareScanDetails::scanConfiguration)).setter(MalwareScanDetails.setter(Builder::scanConfiguration)).constructor(MalwareProtectionFindingsScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfiguration").build()}).build();
    private static final SdkField<Integer> UNIQUE_THREAT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UniqueThreatCount").getter(MalwareScanDetails.getter(MalwareScanDetails::uniqueThreatCount)).setter(MalwareScanDetails.setter(Builder::uniqueThreatCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uniqueThreatCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THREATS_FIELD, SCAN_ID_FIELD, SCAN_TYPE_FIELD, SCAN_CATEGORY_FIELD, SCAN_CONFIGURATION_FIELD, UNIQUE_THREAT_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MalwareScanDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Threat> threats;
    private final String scanId;
    private final String scanType;
    private final String scanCategory;
    private final MalwareProtectionFindingsScanConfiguration scanConfiguration;
    private final Integer uniqueThreatCount;

    private MalwareScanDetails(BuilderImpl builder) {
        this.threats = builder.threats;
        this.scanId = builder.scanId;
        this.scanType = builder.scanType;
        this.scanCategory = builder.scanCategory;
        this.scanConfiguration = builder.scanConfiguration;
        this.uniqueThreatCount = builder.uniqueThreatCount;
    }

    public final boolean hasThreats() {
        return this.threats != null && !(this.threats instanceof SdkAutoConstructList);
    }

    public final List<Threat> threats() {
        return this.threats;
    }

    public final String scanId() {
        return this.scanId;
    }

    public final MalwareProtectionScanType scanType() {
        return MalwareProtectionScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public final ScanCategory scanCategory() {
        return ScanCategory.fromValue(this.scanCategory);
    }

    public final String scanCategoryAsString() {
        return this.scanCategory;
    }

    public final MalwareProtectionFindingsScanConfiguration scanConfiguration() {
        return this.scanConfiguration;
    }

    public final Integer uniqueThreatCount() {
        return this.uniqueThreatCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreats() ? this.threats() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanCategoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.uniqueThreatCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MalwareScanDetails)) {
            return false;
        }
        MalwareScanDetails other = (MalwareScanDetails)obj;
        return this.hasThreats() == other.hasThreats() && Objects.equals(this.threats(), other.threats()) && Objects.equals(this.scanId(), other.scanId()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString()) && Objects.equals(this.scanCategoryAsString(), other.scanCategoryAsString()) && Objects.equals(this.scanConfiguration(), other.scanConfiguration()) && Objects.equals(this.uniqueThreatCount(), other.uniqueThreatCount());
    }

    public final String toString() {
        return ToString.builder((String)"MalwareScanDetails").add("Threats", this.hasThreats() ? this.threats() : null).add("ScanId", (Object)this.scanId()).add("ScanType", (Object)this.scanTypeAsString()).add("ScanCategory", (Object)this.scanCategoryAsString()).add("ScanConfiguration", (Object)this.scanConfiguration()).add("UniqueThreatCount", (Object)this.uniqueThreatCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Threats": {
                return Optional.ofNullable(clazz.cast(this.threats()));
            }
            case "ScanId": {
                return Optional.ofNullable(clazz.cast(this.scanId()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
            case "ScanCategory": {
                return Optional.ofNullable(clazz.cast(this.scanCategoryAsString()));
            }
            case "ScanConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scanConfiguration()));
            }
            case "UniqueThreatCount": {
                return Optional.ofNullable(clazz.cast(this.uniqueThreatCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("threats", THREATS_FIELD);
        map.put("scanId", SCAN_ID_FIELD);
        map.put("scanType", SCAN_TYPE_FIELD);
        map.put("scanCategory", SCAN_CATEGORY_FIELD);
        map.put("scanConfiguration", SCAN_CONFIGURATION_FIELD);
        map.put("uniqueThreatCount", UNIQUE_THREAT_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MalwareScanDetails, T> g) {
        return obj -> g.apply((MalwareScanDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Threat> threats = DefaultSdkAutoConstructList.getInstance();
        private String scanId;
        private String scanType;
        private String scanCategory;
        private MalwareProtectionFindingsScanConfiguration scanConfiguration;
        private Integer uniqueThreatCount;

        private BuilderImpl() {
        }

        private BuilderImpl(MalwareScanDetails model) {
            this.threats(model.threats);
            this.scanId(model.scanId);
            this.scanType(model.scanType);
            this.scanCategory(model.scanCategory);
            this.scanConfiguration(model.scanConfiguration);
            this.uniqueThreatCount(model.uniqueThreatCount);
        }

        public final List<Threat.Builder> getThreats() {
            List<Threat.Builder> result = ThreatsCopier.copyToBuilder(this.threats);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreats(Collection<Threat.BuilderImpl> threats) {
            this.threats = ThreatsCopier.copyFromBuilder(threats);
        }

        @Override
        public final Builder threats(Collection<Threat> threats) {
            this.threats = ThreatsCopier.copy(threats);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threats(Threat ... threats) {
            this.threats(Arrays.asList(threats));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threats(Consumer<Threat.Builder> ... threats) {
            this.threats(Stream.of(threats).map(c -> (Threat)((Threat.Builder)Threat.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScanId() {
            return this.scanId;
        }

        public final void setScanId(String scanId) {
            this.scanId = scanId;
        }

        @Override
        public final Builder scanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(MalwareProtectionScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public final String getScanCategory() {
            return this.scanCategory;
        }

        public final void setScanCategory(String scanCategory) {
            this.scanCategory = scanCategory;
        }

        @Override
        public final Builder scanCategory(String scanCategory) {
            this.scanCategory = scanCategory;
            return this;
        }

        @Override
        public final Builder scanCategory(ScanCategory scanCategory) {
            this.scanCategory(scanCategory == null ? null : scanCategory.toString());
            return this;
        }

        public final MalwareProtectionFindingsScanConfiguration.Builder getScanConfiguration() {
            return this.scanConfiguration != null ? this.scanConfiguration.toBuilder() : null;
        }

        public final void setScanConfiguration(MalwareProtectionFindingsScanConfiguration.BuilderImpl scanConfiguration) {
            this.scanConfiguration = scanConfiguration != null ? scanConfiguration.build() : null;
        }

        @Override
        public final Builder scanConfiguration(MalwareProtectionFindingsScanConfiguration scanConfiguration) {
            this.scanConfiguration = scanConfiguration;
            return this;
        }

        public final Integer getUniqueThreatCount() {
            return this.uniqueThreatCount;
        }

        public final void setUniqueThreatCount(Integer uniqueThreatCount) {
            this.uniqueThreatCount = uniqueThreatCount;
        }

        @Override
        public final Builder uniqueThreatCount(Integer uniqueThreatCount) {
            this.uniqueThreatCount = uniqueThreatCount;
            return this;
        }

        public MalwareScanDetails build() {
            return new MalwareScanDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MalwareScanDetails> {
        public Builder threats(Collection<Threat> var1);

        public Builder threats(Threat ... var1);

        public Builder threats(Consumer<Threat.Builder> ... var1);

        public Builder scanId(String var1);

        public Builder scanType(String var1);

        public Builder scanType(MalwareProtectionScanType var1);

        public Builder scanCategory(String var1);

        public Builder scanCategory(ScanCategory var1);

        public Builder scanConfiguration(MalwareProtectionFindingsScanConfiguration var1);

        default public Builder scanConfiguration(Consumer<MalwareProtectionFindingsScanConfiguration.Builder> scanConfiguration) {
            return this.scanConfiguration((MalwareProtectionFindingsScanConfiguration)((MalwareProtectionFindingsScanConfiguration.Builder)MalwareProtectionFindingsScanConfiguration.builder().applyMutation(scanConfiguration)).build());
        }

        public Builder uniqueThreatCount(Integer var1);
    }
}

