/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.AccessKey;
import software.amazon.awssdk.services.guardduty.model.AutoscalingAutoScalingGroup;
import software.amazon.awssdk.services.guardduty.model.CloudformationStack;
import software.amazon.awssdk.services.guardduty.model.ContainerFindingResource;
import software.amazon.awssdk.services.guardduty.model.Ec2Image;
import software.amazon.awssdk.services.guardduty.model.Ec2Instance;
import software.amazon.awssdk.services.guardduty.model.Ec2LaunchTemplate;
import software.amazon.awssdk.services.guardduty.model.Ec2NetworkInterface;
import software.amazon.awssdk.services.guardduty.model.Ec2Vpc;
import software.amazon.awssdk.services.guardduty.model.EcsCluster;
import software.amazon.awssdk.services.guardduty.model.EcsTask;
import software.amazon.awssdk.services.guardduty.model.EksCluster;
import software.amazon.awssdk.services.guardduty.model.IamInstanceProfileV2;
import software.amazon.awssdk.services.guardduty.model.KubernetesWorkload;
import software.amazon.awssdk.services.guardduty.model.S3Bucket;
import software.amazon.awssdk.services.guardduty.model.S3Object;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceData> {
    private static final SdkField<S3Bucket> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Bucket").getter(ResourceData.getter(ResourceData::s3Bucket)).setter(ResourceData.setter(Builder::s3Bucket)).constructor(S3Bucket::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<Ec2Instance> EC2_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ec2Instance").getter(ResourceData.getter(ResourceData::ec2Instance)).setter(ResourceData.setter(Builder::ec2Instance)).constructor(Ec2Instance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Instance").build()}).build();
    private static final SdkField<AccessKey> ACCESS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessKey").getter(ResourceData.getter(ResourceData::accessKey)).setter(ResourceData.setter(Builder::accessKey)).constructor(AccessKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessKey").build()}).build();
    private static final SdkField<Ec2NetworkInterface> EC2_NETWORK_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ec2NetworkInterface").getter(ResourceData.getter(ResourceData::ec2NetworkInterface)).setter(ResourceData.setter(Builder::ec2NetworkInterface)).constructor(Ec2NetworkInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2NetworkInterface").build()}).build();
    private static final SdkField<S3Object> S3_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("S3Object").getter(ResourceData.getter(ResourceData::s3Object)).setter(ResourceData.setter(Builder::s3Object)).constructor(S3Object::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Object").build()}).build();
    private static final SdkField<EksCluster> EKS_CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EksCluster").getter(ResourceData.getter(ResourceData::eksCluster)).setter(ResourceData.setter(Builder::eksCluster)).constructor(EksCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksCluster").build()}).build();
    private static final SdkField<KubernetesWorkload> KUBERNETES_WORKLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KubernetesWorkload").getter(ResourceData.getter(ResourceData::kubernetesWorkload)).setter(ResourceData.setter(Builder::kubernetesWorkload)).constructor(KubernetesWorkload::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kubernetesWorkload").build()}).build();
    private static final SdkField<ContainerFindingResource> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Container").getter(ResourceData.getter(ResourceData::container)).setter(ResourceData.setter(Builder::container)).constructor(ContainerFindingResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()}).build();
    private static final SdkField<EcsCluster> ECS_CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EcsCluster").getter(ResourceData.getter(ResourceData::ecsCluster)).setter(ResourceData.setter(Builder::ecsCluster)).constructor(EcsCluster::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsCluster").build()}).build();
    private static final SdkField<EcsTask> ECS_TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EcsTask").getter(ResourceData.getter(ResourceData::ecsTask)).setter(ResourceData.setter(Builder::ecsTask)).constructor(EcsTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsTask").build()}).build();
    private static final SdkField<IamInstanceProfileV2> IAM_INSTANCE_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IamInstanceProfile").getter(ResourceData.getter(ResourceData::iamInstanceProfile)).setter(ResourceData.setter(Builder::iamInstanceProfile)).constructor(IamInstanceProfileV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamInstanceProfile").build()}).build();
    private static final SdkField<AutoscalingAutoScalingGroup> AUTOSCALING_AUTO_SCALING_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoscalingAutoScalingGroup").getter(ResourceData.getter(ResourceData::autoscalingAutoScalingGroup)).setter(ResourceData.setter(Builder::autoscalingAutoScalingGroup)).constructor(AutoscalingAutoScalingGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoscalingAutoScalingGroup").build()}).build();
    private static final SdkField<Ec2LaunchTemplate> EC2_LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ec2LaunchTemplate").getter(ResourceData.getter(ResourceData::ec2LaunchTemplate)).setter(ResourceData.setter(Builder::ec2LaunchTemplate)).constructor(Ec2LaunchTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2LaunchTemplate").build()}).build();
    private static final SdkField<Ec2Vpc> EC2_VPC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ec2Vpc").getter(ResourceData.getter(ResourceData::ec2Vpc)).setter(ResourceData.setter(Builder::ec2Vpc)).constructor(Ec2Vpc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Vpc").build()}).build();
    private static final SdkField<Ec2Image> EC2_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ec2Image").getter(ResourceData.getter(ResourceData::ec2Image)).setter(ResourceData.setter(Builder::ec2Image)).constructor(Ec2Image::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2Image").build()}).build();
    private static final SdkField<CloudformationStack> CLOUDFORMATION_STACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudformationStack").getter(ResourceData.getter(ResourceData::cloudformationStack)).setter(ResourceData.setter(Builder::cloudformationStack)).constructor(CloudformationStack::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudformationStack").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_BUCKET_FIELD, EC2_INSTANCE_FIELD, ACCESS_KEY_FIELD, EC2_NETWORK_INTERFACE_FIELD, S3_OBJECT_FIELD, EKS_CLUSTER_FIELD, KUBERNETES_WORKLOAD_FIELD, CONTAINER_FIELD, ECS_CLUSTER_FIELD, ECS_TASK_FIELD, IAM_INSTANCE_PROFILE_FIELD, AUTOSCALING_AUTO_SCALING_GROUP_FIELD, EC2_LAUNCH_TEMPLATE_FIELD, EC2_VPC_FIELD, EC2_IMAGE_FIELD, CLOUDFORMATION_STACK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3Bucket s3Bucket;
    private final Ec2Instance ec2Instance;
    private final AccessKey accessKey;
    private final Ec2NetworkInterface ec2NetworkInterface;
    private final S3Object s3Object;
    private final EksCluster eksCluster;
    private final KubernetesWorkload kubernetesWorkload;
    private final ContainerFindingResource container;
    private final EcsCluster ecsCluster;
    private final EcsTask ecsTask;
    private final IamInstanceProfileV2 iamInstanceProfile;
    private final AutoscalingAutoScalingGroup autoscalingAutoScalingGroup;
    private final Ec2LaunchTemplate ec2LaunchTemplate;
    private final Ec2Vpc ec2Vpc;
    private final Ec2Image ec2Image;
    private final CloudformationStack cloudformationStack;

    private ResourceData(BuilderImpl builder) {
        this.s3Bucket = builder.s3Bucket;
        this.ec2Instance = builder.ec2Instance;
        this.accessKey = builder.accessKey;
        this.ec2NetworkInterface = builder.ec2NetworkInterface;
        this.s3Object = builder.s3Object;
        this.eksCluster = builder.eksCluster;
        this.kubernetesWorkload = builder.kubernetesWorkload;
        this.container = builder.container;
        this.ecsCluster = builder.ecsCluster;
        this.ecsTask = builder.ecsTask;
        this.iamInstanceProfile = builder.iamInstanceProfile;
        this.autoscalingAutoScalingGroup = builder.autoscalingAutoScalingGroup;
        this.ec2LaunchTemplate = builder.ec2LaunchTemplate;
        this.ec2Vpc = builder.ec2Vpc;
        this.ec2Image = builder.ec2Image;
        this.cloudformationStack = builder.cloudformationStack;
    }

    public final S3Bucket s3Bucket() {
        return this.s3Bucket;
    }

    public final Ec2Instance ec2Instance() {
        return this.ec2Instance;
    }

    public final AccessKey accessKey() {
        return this.accessKey;
    }

    public final Ec2NetworkInterface ec2NetworkInterface() {
        return this.ec2NetworkInterface;
    }

    public final S3Object s3Object() {
        return this.s3Object;
    }

    public final EksCluster eksCluster() {
        return this.eksCluster;
    }

    public final KubernetesWorkload kubernetesWorkload() {
        return this.kubernetesWorkload;
    }

    public final ContainerFindingResource container() {
        return this.container;
    }

    public final EcsCluster ecsCluster() {
        return this.ecsCluster;
    }

    public final EcsTask ecsTask() {
        return this.ecsTask;
    }

    public final IamInstanceProfileV2 iamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public final AutoscalingAutoScalingGroup autoscalingAutoScalingGroup() {
        return this.autoscalingAutoScalingGroup;
    }

    public final Ec2LaunchTemplate ec2LaunchTemplate() {
        return this.ec2LaunchTemplate;
    }

    public final Ec2Vpc ec2Vpc() {
        return this.ec2Vpc;
    }

    public final Ec2Image ec2Image() {
        return this.ec2Image;
    }

    public final CloudformationStack cloudformationStack() {
        return this.cloudformationStack;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2Instance());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2NetworkInterface());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Object());
        hashCode = 31 * hashCode + Objects.hashCode(this.eksCluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.kubernetesWorkload());
        hashCode = 31 * hashCode + Objects.hashCode(this.container());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsCluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsTask());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamInstanceProfile());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoscalingAutoScalingGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2LaunchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2Vpc());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2Image());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudformationStack());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceData)) {
            return false;
        }
        ResourceData other = (ResourceData)obj;
        return Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.ec2Instance(), other.ec2Instance()) && Objects.equals(this.accessKey(), other.accessKey()) && Objects.equals(this.ec2NetworkInterface(), other.ec2NetworkInterface()) && Objects.equals(this.s3Object(), other.s3Object()) && Objects.equals(this.eksCluster(), other.eksCluster()) && Objects.equals(this.kubernetesWorkload(), other.kubernetesWorkload()) && Objects.equals(this.container(), other.container()) && Objects.equals(this.ecsCluster(), other.ecsCluster()) && Objects.equals(this.ecsTask(), other.ecsTask()) && Objects.equals(this.iamInstanceProfile(), other.iamInstanceProfile()) && Objects.equals(this.autoscalingAutoScalingGroup(), other.autoscalingAutoScalingGroup()) && Objects.equals(this.ec2LaunchTemplate(), other.ec2LaunchTemplate()) && Objects.equals(this.ec2Vpc(), other.ec2Vpc()) && Objects.equals(this.ec2Image(), other.ec2Image()) && Objects.equals(this.cloudformationStack(), other.cloudformationStack());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceData").add("S3Bucket", (Object)this.s3Bucket()).add("Ec2Instance", (Object)this.ec2Instance()).add("AccessKey", (Object)this.accessKey()).add("Ec2NetworkInterface", (Object)this.ec2NetworkInterface()).add("S3Object", (Object)this.s3Object()).add("EksCluster", (Object)this.eksCluster()).add("KubernetesWorkload", (Object)this.kubernetesWorkload()).add("Container", (Object)this.container()).add("EcsCluster", (Object)this.ecsCluster()).add("EcsTask", (Object)this.ecsTask()).add("IamInstanceProfile", (Object)this.iamInstanceProfile()).add("AutoscalingAutoScalingGroup", (Object)this.autoscalingAutoScalingGroup()).add("Ec2LaunchTemplate", (Object)this.ec2LaunchTemplate()).add("Ec2Vpc", (Object)this.ec2Vpc()).add("Ec2Image", (Object)this.ec2Image()).add("CloudformationStack", (Object)this.cloudformationStack()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "Ec2Instance": {
                return Optional.ofNullable(clazz.cast(this.ec2Instance()));
            }
            case "AccessKey": {
                return Optional.ofNullable(clazz.cast(this.accessKey()));
            }
            case "Ec2NetworkInterface": {
                return Optional.ofNullable(clazz.cast(this.ec2NetworkInterface()));
            }
            case "S3Object": {
                return Optional.ofNullable(clazz.cast(this.s3Object()));
            }
            case "EksCluster": {
                return Optional.ofNullable(clazz.cast(this.eksCluster()));
            }
            case "KubernetesWorkload": {
                return Optional.ofNullable(clazz.cast(this.kubernetesWorkload()));
            }
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.container()));
            }
            case "EcsCluster": {
                return Optional.ofNullable(clazz.cast(this.ecsCluster()));
            }
            case "EcsTask": {
                return Optional.ofNullable(clazz.cast(this.ecsTask()));
            }
            case "IamInstanceProfile": {
                return Optional.ofNullable(clazz.cast(this.iamInstanceProfile()));
            }
            case "AutoscalingAutoScalingGroup": {
                return Optional.ofNullable(clazz.cast(this.autoscalingAutoScalingGroup()));
            }
            case "Ec2LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.ec2LaunchTemplate()));
            }
            case "Ec2Vpc": {
                return Optional.ofNullable(clazz.cast(this.ec2Vpc()));
            }
            case "Ec2Image": {
                return Optional.ofNullable(clazz.cast(this.ec2Image()));
            }
            case "CloudformationStack": {
                return Optional.ofNullable(clazz.cast(this.cloudformationStack()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("s3Bucket", S3_BUCKET_FIELD);
        map.put("ec2Instance", EC2_INSTANCE_FIELD);
        map.put("accessKey", ACCESS_KEY_FIELD);
        map.put("ec2NetworkInterface", EC2_NETWORK_INTERFACE_FIELD);
        map.put("s3Object", S3_OBJECT_FIELD);
        map.put("eksCluster", EKS_CLUSTER_FIELD);
        map.put("kubernetesWorkload", KUBERNETES_WORKLOAD_FIELD);
        map.put("container", CONTAINER_FIELD);
        map.put("ecsCluster", ECS_CLUSTER_FIELD);
        map.put("ecsTask", ECS_TASK_FIELD);
        map.put("iamInstanceProfile", IAM_INSTANCE_PROFILE_FIELD);
        map.put("autoscalingAutoScalingGroup", AUTOSCALING_AUTO_SCALING_GROUP_FIELD);
        map.put("ec2LaunchTemplate", EC2_LAUNCH_TEMPLATE_FIELD);
        map.put("ec2Vpc", EC2_VPC_FIELD);
        map.put("ec2Image", EC2_IMAGE_FIELD);
        map.put("cloudformationStack", CLOUDFORMATION_STACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceData, T> g) {
        return obj -> g.apply((ResourceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3Bucket s3Bucket;
        private Ec2Instance ec2Instance;
        private AccessKey accessKey;
        private Ec2NetworkInterface ec2NetworkInterface;
        private S3Object s3Object;
        private EksCluster eksCluster;
        private KubernetesWorkload kubernetesWorkload;
        private ContainerFindingResource container;
        private EcsCluster ecsCluster;
        private EcsTask ecsTask;
        private IamInstanceProfileV2 iamInstanceProfile;
        private AutoscalingAutoScalingGroup autoscalingAutoScalingGroup;
        private Ec2LaunchTemplate ec2LaunchTemplate;
        private Ec2Vpc ec2Vpc;
        private Ec2Image ec2Image;
        private CloudformationStack cloudformationStack;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceData model) {
            this.s3Bucket(model.s3Bucket);
            this.ec2Instance(model.ec2Instance);
            this.accessKey(model.accessKey);
            this.ec2NetworkInterface(model.ec2NetworkInterface);
            this.s3Object(model.s3Object);
            this.eksCluster(model.eksCluster);
            this.kubernetesWorkload(model.kubernetesWorkload);
            this.container(model.container);
            this.ecsCluster(model.ecsCluster);
            this.ecsTask(model.ecsTask);
            this.iamInstanceProfile(model.iamInstanceProfile);
            this.autoscalingAutoScalingGroup(model.autoscalingAutoScalingGroup);
            this.ec2LaunchTemplate(model.ec2LaunchTemplate);
            this.ec2Vpc(model.ec2Vpc);
            this.ec2Image(model.ec2Image);
            this.cloudformationStack(model.cloudformationStack);
        }

        public final S3Bucket.Builder getS3Bucket() {
            return this.s3Bucket != null ? this.s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3Bucket.BuilderImpl s3Bucket) {
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
        }

        @Override
        public final Builder s3Bucket(S3Bucket s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final Ec2Instance.Builder getEc2Instance() {
            return this.ec2Instance != null ? this.ec2Instance.toBuilder() : null;
        }

        public final void setEc2Instance(Ec2Instance.BuilderImpl ec2Instance) {
            this.ec2Instance = ec2Instance != null ? ec2Instance.build() : null;
        }

        @Override
        public final Builder ec2Instance(Ec2Instance ec2Instance) {
            this.ec2Instance = ec2Instance;
            return this;
        }

        public final AccessKey.Builder getAccessKey() {
            return this.accessKey != null ? this.accessKey.toBuilder() : null;
        }

        public final void setAccessKey(AccessKey.BuilderImpl accessKey) {
            this.accessKey = accessKey != null ? accessKey.build() : null;
        }

        @Override
        public final Builder accessKey(AccessKey accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public final Ec2NetworkInterface.Builder getEc2NetworkInterface() {
            return this.ec2NetworkInterface != null ? this.ec2NetworkInterface.toBuilder() : null;
        }

        public final void setEc2NetworkInterface(Ec2NetworkInterface.BuilderImpl ec2NetworkInterface) {
            this.ec2NetworkInterface = ec2NetworkInterface != null ? ec2NetworkInterface.build() : null;
        }

        @Override
        public final Builder ec2NetworkInterface(Ec2NetworkInterface ec2NetworkInterface) {
            this.ec2NetworkInterface = ec2NetworkInterface;
            return this;
        }

        public final S3Object.Builder getS3Object() {
            return this.s3Object != null ? this.s3Object.toBuilder() : null;
        }

        public final void setS3Object(S3Object.BuilderImpl s3Object) {
            this.s3Object = s3Object != null ? s3Object.build() : null;
        }

        @Override
        public final Builder s3Object(S3Object s3Object) {
            this.s3Object = s3Object;
            return this;
        }

        public final EksCluster.Builder getEksCluster() {
            return this.eksCluster != null ? this.eksCluster.toBuilder() : null;
        }

        public final void setEksCluster(EksCluster.BuilderImpl eksCluster) {
            this.eksCluster = eksCluster != null ? eksCluster.build() : null;
        }

        @Override
        public final Builder eksCluster(EksCluster eksCluster) {
            this.eksCluster = eksCluster;
            return this;
        }

        public final KubernetesWorkload.Builder getKubernetesWorkload() {
            return this.kubernetesWorkload != null ? this.kubernetesWorkload.toBuilder() : null;
        }

        public final void setKubernetesWorkload(KubernetesWorkload.BuilderImpl kubernetesWorkload) {
            this.kubernetesWorkload = kubernetesWorkload != null ? kubernetesWorkload.build() : null;
        }

        @Override
        public final Builder kubernetesWorkload(KubernetesWorkload kubernetesWorkload) {
            this.kubernetesWorkload = kubernetesWorkload;
            return this;
        }

        public final ContainerFindingResource.Builder getContainer() {
            return this.container != null ? this.container.toBuilder() : null;
        }

        public final void setContainer(ContainerFindingResource.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(ContainerFindingResource container) {
            this.container = container;
            return this;
        }

        public final EcsCluster.Builder getEcsCluster() {
            return this.ecsCluster != null ? this.ecsCluster.toBuilder() : null;
        }

        public final void setEcsCluster(EcsCluster.BuilderImpl ecsCluster) {
            this.ecsCluster = ecsCluster != null ? ecsCluster.build() : null;
        }

        @Override
        public final Builder ecsCluster(EcsCluster ecsCluster) {
            this.ecsCluster = ecsCluster;
            return this;
        }

        public final EcsTask.Builder getEcsTask() {
            return this.ecsTask != null ? this.ecsTask.toBuilder() : null;
        }

        public final void setEcsTask(EcsTask.BuilderImpl ecsTask) {
            this.ecsTask = ecsTask != null ? ecsTask.build() : null;
        }

        @Override
        public final Builder ecsTask(EcsTask ecsTask) {
            this.ecsTask = ecsTask;
            return this;
        }

        public final IamInstanceProfileV2.Builder getIamInstanceProfile() {
            return this.iamInstanceProfile != null ? this.iamInstanceProfile.toBuilder() : null;
        }

        public final void setIamInstanceProfile(IamInstanceProfileV2.BuilderImpl iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile != null ? iamInstanceProfile.build() : null;
        }

        @Override
        public final Builder iamInstanceProfile(IamInstanceProfileV2 iamInstanceProfile) {
            this.iamInstanceProfile = iamInstanceProfile;
            return this;
        }

        public final AutoscalingAutoScalingGroup.Builder getAutoscalingAutoScalingGroup() {
            return this.autoscalingAutoScalingGroup != null ? this.autoscalingAutoScalingGroup.toBuilder() : null;
        }

        public final void setAutoscalingAutoScalingGroup(AutoscalingAutoScalingGroup.BuilderImpl autoscalingAutoScalingGroup) {
            this.autoscalingAutoScalingGroup = autoscalingAutoScalingGroup != null ? autoscalingAutoScalingGroup.build() : null;
        }

        @Override
        public final Builder autoscalingAutoScalingGroup(AutoscalingAutoScalingGroup autoscalingAutoScalingGroup) {
            this.autoscalingAutoScalingGroup = autoscalingAutoScalingGroup;
            return this;
        }

        public final Ec2LaunchTemplate.Builder getEc2LaunchTemplate() {
            return this.ec2LaunchTemplate != null ? this.ec2LaunchTemplate.toBuilder() : null;
        }

        public final void setEc2LaunchTemplate(Ec2LaunchTemplate.BuilderImpl ec2LaunchTemplate) {
            this.ec2LaunchTemplate = ec2LaunchTemplate != null ? ec2LaunchTemplate.build() : null;
        }

        @Override
        public final Builder ec2LaunchTemplate(Ec2LaunchTemplate ec2LaunchTemplate) {
            this.ec2LaunchTemplate = ec2LaunchTemplate;
            return this;
        }

        public final Ec2Vpc.Builder getEc2Vpc() {
            return this.ec2Vpc != null ? this.ec2Vpc.toBuilder() : null;
        }

        public final void setEc2Vpc(Ec2Vpc.BuilderImpl ec2Vpc) {
            this.ec2Vpc = ec2Vpc != null ? ec2Vpc.build() : null;
        }

        @Override
        public final Builder ec2Vpc(Ec2Vpc ec2Vpc) {
            this.ec2Vpc = ec2Vpc;
            return this;
        }

        public final Ec2Image.Builder getEc2Image() {
            return this.ec2Image != null ? this.ec2Image.toBuilder() : null;
        }

        public final void setEc2Image(Ec2Image.BuilderImpl ec2Image) {
            this.ec2Image = ec2Image != null ? ec2Image.build() : null;
        }

        @Override
        public final Builder ec2Image(Ec2Image ec2Image) {
            this.ec2Image = ec2Image;
            return this;
        }

        public final CloudformationStack.Builder getCloudformationStack() {
            return this.cloudformationStack != null ? this.cloudformationStack.toBuilder() : null;
        }

        public final void setCloudformationStack(CloudformationStack.BuilderImpl cloudformationStack) {
            this.cloudformationStack = cloudformationStack != null ? cloudformationStack.build() : null;
        }

        @Override
        public final Builder cloudformationStack(CloudformationStack cloudformationStack) {
            this.cloudformationStack = cloudformationStack;
            return this;
        }

        public ResourceData build() {
            return new ResourceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceData> {
        public Builder s3Bucket(S3Bucket var1);

        default public Builder s3Bucket(Consumer<S3Bucket.Builder> s3Bucket) {
            return this.s3Bucket((S3Bucket)((S3Bucket.Builder)S3Bucket.builder().applyMutation(s3Bucket)).build());
        }

        public Builder ec2Instance(Ec2Instance var1);

        default public Builder ec2Instance(Consumer<Ec2Instance.Builder> ec2Instance) {
            return this.ec2Instance((Ec2Instance)((Ec2Instance.Builder)Ec2Instance.builder().applyMutation(ec2Instance)).build());
        }

        public Builder accessKey(AccessKey var1);

        default public Builder accessKey(Consumer<AccessKey.Builder> accessKey) {
            return this.accessKey((AccessKey)((AccessKey.Builder)AccessKey.builder().applyMutation(accessKey)).build());
        }

        public Builder ec2NetworkInterface(Ec2NetworkInterface var1);

        default public Builder ec2NetworkInterface(Consumer<Ec2NetworkInterface.Builder> ec2NetworkInterface) {
            return this.ec2NetworkInterface((Ec2NetworkInterface)((Ec2NetworkInterface.Builder)Ec2NetworkInterface.builder().applyMutation(ec2NetworkInterface)).build());
        }

        public Builder s3Object(S3Object var1);

        default public Builder s3Object(Consumer<S3Object.Builder> s3Object) {
            return this.s3Object((S3Object)((S3Object.Builder)S3Object.builder().applyMutation(s3Object)).build());
        }

        public Builder eksCluster(EksCluster var1);

        default public Builder eksCluster(Consumer<EksCluster.Builder> eksCluster) {
            return this.eksCluster((EksCluster)((EksCluster.Builder)EksCluster.builder().applyMutation(eksCluster)).build());
        }

        public Builder kubernetesWorkload(KubernetesWorkload var1);

        default public Builder kubernetesWorkload(Consumer<KubernetesWorkload.Builder> kubernetesWorkload) {
            return this.kubernetesWorkload((KubernetesWorkload)((KubernetesWorkload.Builder)KubernetesWorkload.builder().applyMutation(kubernetesWorkload)).build());
        }

        public Builder container(ContainerFindingResource var1);

        default public Builder container(Consumer<ContainerFindingResource.Builder> container) {
            return this.container((ContainerFindingResource)((ContainerFindingResource.Builder)ContainerFindingResource.builder().applyMutation(container)).build());
        }

        public Builder ecsCluster(EcsCluster var1);

        default public Builder ecsCluster(Consumer<EcsCluster.Builder> ecsCluster) {
            return this.ecsCluster((EcsCluster)((EcsCluster.Builder)EcsCluster.builder().applyMutation(ecsCluster)).build());
        }

        public Builder ecsTask(EcsTask var1);

        default public Builder ecsTask(Consumer<EcsTask.Builder> ecsTask) {
            return this.ecsTask((EcsTask)((EcsTask.Builder)EcsTask.builder().applyMutation(ecsTask)).build());
        }

        public Builder iamInstanceProfile(IamInstanceProfileV2 var1);

        default public Builder iamInstanceProfile(Consumer<IamInstanceProfileV2.Builder> iamInstanceProfile) {
            return this.iamInstanceProfile((IamInstanceProfileV2)((IamInstanceProfileV2.Builder)IamInstanceProfileV2.builder().applyMutation(iamInstanceProfile)).build());
        }

        public Builder autoscalingAutoScalingGroup(AutoscalingAutoScalingGroup var1);

        default public Builder autoscalingAutoScalingGroup(Consumer<AutoscalingAutoScalingGroup.Builder> autoscalingAutoScalingGroup) {
            return this.autoscalingAutoScalingGroup((AutoscalingAutoScalingGroup)((AutoscalingAutoScalingGroup.Builder)AutoscalingAutoScalingGroup.builder().applyMutation(autoscalingAutoScalingGroup)).build());
        }

        public Builder ec2LaunchTemplate(Ec2LaunchTemplate var1);

        default public Builder ec2LaunchTemplate(Consumer<Ec2LaunchTemplate.Builder> ec2LaunchTemplate) {
            return this.ec2LaunchTemplate((Ec2LaunchTemplate)((Ec2LaunchTemplate.Builder)Ec2LaunchTemplate.builder().applyMutation(ec2LaunchTemplate)).build());
        }

        public Builder ec2Vpc(Ec2Vpc var1);

        default public Builder ec2Vpc(Consumer<Ec2Vpc.Builder> ec2Vpc) {
            return this.ec2Vpc((Ec2Vpc)((Ec2Vpc.Builder)Ec2Vpc.builder().applyMutation(ec2Vpc)).build());
        }

        public Builder ec2Image(Ec2Image var1);

        default public Builder ec2Image(Consumer<Ec2Image.Builder> ec2Image) {
            return this.ec2Image((Ec2Image)((Ec2Image.Builder)Ec2Image.builder().applyMutation(ec2Image)).build());
        }

        public Builder cloudformationStack(CloudformationStack var1);

        default public Builder cloudformationStack(Consumer<CloudformationStack.Builder> cloudformationStack) {
            return this.cloudformationStack((CloudformationStack)((CloudformationStack.Builder)CloudformationStack.builder().applyMutation(cloudformationStack)).build());
        }
    }
}

