/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.DetectionSource;
import software.amazon.awssdk.services.guardduty.model.ItemDetails;
import software.amazon.awssdk.services.guardduty.model.ItemDetailsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScanResultThreat
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScanResultThreat> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ScanResultThreat.getter(ScanResultThreat::name)).setter(ScanResultThreat.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(ScanResultThreat.getter(ScanResultThreat::sourceAsString)).setter(ScanResultThreat.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Count").getter(ScanResultThreat.getter(ScanResultThreat::count)).setter(ScanResultThreat.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<String> HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Hash").getter(ScanResultThreat.getter(ScanResultThreat::hash)).setter(ScanResultThreat.setter(Builder::hash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hash").build()}).build();
    private static final SdkField<List<ItemDetails>> ITEM_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ItemDetails").getter(ScanResultThreat.getter(ScanResultThreat::itemDetails)).setter(ScanResultThreat.setter(Builder::itemDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ItemDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SOURCE_FIELD, COUNT_FIELD, HASH_FIELD, ITEM_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScanResultThreat.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String source;
    private final Long count;
    private final String hash;
    private final List<ItemDetails> itemDetails;

    private ScanResultThreat(BuilderImpl builder) {
        this.name = builder.name;
        this.source = builder.source;
        this.count = builder.count;
        this.hash = builder.hash;
        this.itemDetails = builder.itemDetails;
    }

    public final String name() {
        return this.name;
    }

    public final DetectionSource source() {
        return DetectionSource.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final Long count() {
        return this.count;
    }

    public final String hash() {
        return this.hash;
    }

    public final boolean hasItemDetails() {
        return this.itemDetails != null && !(this.itemDetails instanceof SdkAutoConstructList);
    }

    public final List<ItemDetails> itemDetails() {
        return this.itemDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hash());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemDetails() ? this.itemDetails() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanResultThreat)) {
            return false;
        }
        ScanResultThreat other = (ScanResultThreat)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && Objects.equals(this.count(), other.count()) && Objects.equals(this.hash(), other.hash()) && this.hasItemDetails() == other.hasItemDetails() && Objects.equals(this.itemDetails(), other.itemDetails());
    }

    public final String toString() {
        return ToString.builder((String)"ScanResultThreat").add("Name", (Object)this.name()).add("Source", (Object)this.sourceAsString()).add("Count", (Object)this.count()).add("Hash", (Object)this.hash()).add("ItemDetails", this.hasItemDetails() ? this.itemDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "Count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "Hash": {
                return Optional.ofNullable(clazz.cast(this.hash()));
            }
            case "ItemDetails": {
                return Optional.ofNullable(clazz.cast(this.itemDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("count", COUNT_FIELD);
        map.put("hash", HASH_FIELD);
        map.put("itemDetails", ITEM_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanResultThreat, T> g) {
        return obj -> g.apply((ScanResultThreat)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String source;
        private Long count;
        private String hash;
        private List<ItemDetails> itemDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ScanResultThreat model) {
            this.name(model.name);
            this.source(model.source);
            this.count(model.count);
            this.hash(model.hash);
            this.itemDetails(model.itemDetails);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(DetectionSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final Long getCount() {
            return this.count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final String getHash() {
            return this.hash;
        }

        public final void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public final List<ItemDetails.Builder> getItemDetails() {
            List<ItemDetails.Builder> result = ItemDetailsListCopier.copyToBuilder(this.itemDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItemDetails(Collection<ItemDetails.BuilderImpl> itemDetails) {
            this.itemDetails = ItemDetailsListCopier.copyFromBuilder(itemDetails);
        }

        @Override
        public final Builder itemDetails(Collection<ItemDetails> itemDetails) {
            this.itemDetails = ItemDetailsListCopier.copy(itemDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemDetails(ItemDetails ... itemDetails) {
            this.itemDetails(Arrays.asList(itemDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder itemDetails(Consumer<ItemDetails.Builder> ... itemDetails) {
            this.itemDetails(Stream.of(itemDetails).map(c -> (ItemDetails)((ItemDetails.Builder)ItemDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ScanResultThreat build() {
            return new ScanResultThreat(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScanResultThreat> {
        public Builder name(String var1);

        public Builder source(String var1);

        public Builder source(DetectionSource var1);

        public Builder count(Long var1);

        public Builder hash(String var1);

        public Builder itemDetails(Collection<ItemDetails> var1);

        public Builder itemDetails(ItemDetails ... var1);

        public Builder itemDetails(Consumer<ItemDetails.Builder> ... var1);
    }
}

