/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.StartMalwareScanConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMalwareScanRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, StartMalwareScanRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(StartMalwareScanRequest.getter(StartMalwareScanRequest::resourceArn)).setter(StartMalwareScanRequest.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartMalwareScanRequest.getter(StartMalwareScanRequest::clientToken)).setter(StartMalwareScanRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<StartMalwareScanConfiguration> SCAN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScanConfiguration").getter(StartMalwareScanRequest.getter(StartMalwareScanRequest::scanConfiguration)).setter(StartMalwareScanRequest.setter(Builder::scanConfiguration)).constructor(StartMalwareScanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, CLIENT_TOKEN_FIELD, SCAN_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartMalwareScanRequest.memberNameToFieldInitializer();
    private final String resourceArn;
    private final String clientToken;
    private final StartMalwareScanConfiguration scanConfiguration;

    private StartMalwareScanRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.clientToken = builder.clientToken;
        this.scanConfiguration = builder.scanConfiguration;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final StartMalwareScanConfiguration scanConfiguration() {
        return this.scanConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMalwareScanRequest)) {
            return false;
        }
        StartMalwareScanRequest other = (StartMalwareScanRequest)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.scanConfiguration(), other.scanConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"StartMalwareScanRequest").add("ResourceArn", (Object)this.resourceArn()).add("ClientToken", (Object)this.clientToken()).add("ScanConfiguration", (Object)this.scanConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "ScanConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scanConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("scanConfiguration", SCAN_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartMalwareScanRequest, T> g) {
        return obj -> g.apply((StartMalwareScanRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String resourceArn;
        private String clientToken;
        private StartMalwareScanConfiguration scanConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMalwareScanRequest model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.clientToken(model.clientToken);
            this.scanConfiguration(model.scanConfiguration);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final StartMalwareScanConfiguration.Builder getScanConfiguration() {
            return this.scanConfiguration != null ? this.scanConfiguration.toBuilder() : null;
        }

        public final void setScanConfiguration(StartMalwareScanConfiguration.BuilderImpl scanConfiguration) {
            this.scanConfiguration = scanConfiguration != null ? scanConfiguration.build() : null;
        }

        @Override
        public final Builder scanConfiguration(StartMalwareScanConfiguration scanConfiguration) {
            this.scanConfiguration = scanConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMalwareScanRequest build() {
            return new StartMalwareScanRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMalwareScanRequest> {
        public Builder resourceArn(String var1);

        public Builder clientToken(String var1);

        public Builder scanConfiguration(StartMalwareScanConfiguration var1);

        default public Builder scanConfiguration(Consumer<StartMalwareScanConfiguration.Builder> scanConfiguration) {
            return this.scanConfiguration((StartMalwareScanConfiguration)((StartMalwareScanConfiguration.Builder)StartMalwareScanConfiguration.builder().applyMutation(scanConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

