/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.guardduty.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.guardduty.model.AutoEnableMembers;
import software.amazon.awssdk.services.guardduty.model.GuardDutyRequest;
import software.amazon.awssdk.services.guardduty.model.OrganizationDataSourceConfigurations;
import software.amazon.awssdk.services.guardduty.model.OrganizationFeatureConfiguration;
import software.amazon.awssdk.services.guardduty.model.OrganizationFeaturesConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateOrganizationConfigurationRequest
extends GuardDutyRequest
implements ToCopyableBuilder<Builder, UpdateOrganizationConfigurationRequest> {
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetectorId").getter(UpdateOrganizationConfigurationRequest.getter(UpdateOrganizationConfigurationRequest::detectorId)).setter(UpdateOrganizationConfigurationRequest.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("detectorId").build()}).build();
    private static final SdkField<Boolean> AUTO_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoEnable").getter(UpdateOrganizationConfigurationRequest.getter(UpdateOrganizationConfigurationRequest::autoEnable)).setter(UpdateOrganizationConfigurationRequest.setter(Builder::autoEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnable").build()}).build();
    private static final SdkField<OrganizationDataSourceConfigurations> DATA_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataSources").getter(UpdateOrganizationConfigurationRequest.getter(UpdateOrganizationConfigurationRequest::dataSources)).setter(UpdateOrganizationConfigurationRequest.setter(Builder::dataSources)).constructor(OrganizationDataSourceConfigurations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build()}).build();
    private static final SdkField<List<OrganizationFeatureConfiguration>> FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Features").getter(UpdateOrganizationConfigurationRequest.getter(UpdateOrganizationConfigurationRequest::features)).setter(UpdateOrganizationConfigurationRequest.setter(Builder::features)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("features").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrganizationFeatureConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoEnableOrganizationMembers").getter(UpdateOrganizationConfigurationRequest.getter(UpdateOrganizationConfigurationRequest::autoEnableOrganizationMembersAsString)).setter(UpdateOrganizationConfigurationRequest.setter(Builder::autoEnableOrganizationMembers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoEnableOrganizationMembers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTOR_ID_FIELD, AUTO_ENABLE_FIELD, DATA_SOURCES_FIELD, FEATURES_FIELD, AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateOrganizationConfigurationRequest.memberNameToFieldInitializer();
    private final String detectorId;
    private final Boolean autoEnable;
    private final OrganizationDataSourceConfigurations dataSources;
    private final List<OrganizationFeatureConfiguration> features;
    private final String autoEnableOrganizationMembers;

    private UpdateOrganizationConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.detectorId = builder.detectorId;
        this.autoEnable = builder.autoEnable;
        this.dataSources = builder.dataSources;
        this.features = builder.features;
        this.autoEnableOrganizationMembers = builder.autoEnableOrganizationMembers;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    @Deprecated
    public final Boolean autoEnable() {
        return this.autoEnable;
    }

    @Deprecated
    public final OrganizationDataSourceConfigurations dataSources() {
        return this.dataSources;
    }

    public final boolean hasFeatures() {
        return this.features != null && !(this.features instanceof SdkAutoConstructList);
    }

    public final List<OrganizationFeatureConfiguration> features() {
        return this.features;
    }

    public final AutoEnableMembers autoEnableOrganizationMembers() {
        return AutoEnableMembers.fromValue(this.autoEnableOrganizationMembers);
    }

    public final String autoEnableOrganizationMembersAsString() {
        return this.autoEnableOrganizationMembers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnable());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatures() ? this.features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoEnableOrganizationMembersAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOrganizationConfigurationRequest)) {
            return false;
        }
        UpdateOrganizationConfigurationRequest other = (UpdateOrganizationConfigurationRequest)((Object)obj);
        return Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.autoEnable(), other.autoEnable()) && Objects.equals(this.dataSources(), other.dataSources()) && this.hasFeatures() == other.hasFeatures() && Objects.equals(this.features(), other.features()) && Objects.equals(this.autoEnableOrganizationMembersAsString(), other.autoEnableOrganizationMembersAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateOrganizationConfigurationRequest").add("DetectorId", (Object)this.detectorId()).add("AutoEnable", (Object)this.autoEnable()).add("DataSources", (Object)this.dataSources()).add("Features", this.hasFeatures() ? this.features() : null).add("AutoEnableOrganizationMembers", (Object)this.autoEnableOrganizationMembersAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DetectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "AutoEnable": {
                return Optional.ofNullable(clazz.cast(this.autoEnable()));
            }
            case "DataSources": {
                return Optional.ofNullable(clazz.cast(this.dataSources()));
            }
            case "Features": {
                return Optional.ofNullable(clazz.cast(this.features()));
            }
            case "AutoEnableOrganizationMembers": {
                return Optional.ofNullable(clazz.cast(this.autoEnableOrganizationMembersAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("detectorId", DETECTOR_ID_FIELD);
        map.put("autoEnable", AUTO_ENABLE_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("features", FEATURES_FIELD);
        map.put("autoEnableOrganizationMembers", AUTO_ENABLE_ORGANIZATION_MEMBERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateOrganizationConfigurationRequest, T> g) {
        return obj -> g.apply((UpdateOrganizationConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GuardDutyRequest.BuilderImpl
    implements Builder {
        private String detectorId;
        private Boolean autoEnable;
        private OrganizationDataSourceConfigurations dataSources;
        private List<OrganizationFeatureConfiguration> features = DefaultSdkAutoConstructList.getInstance();
        private String autoEnableOrganizationMembers;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOrganizationConfigurationRequest model) {
            super(model);
            this.detectorId(model.detectorId);
            this.autoEnable(model.autoEnable);
            this.dataSources(model.dataSources);
            this.features(model.features);
            this.autoEnableOrganizationMembers(model.autoEnableOrganizationMembers);
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        @Deprecated
        public final Boolean getAutoEnable() {
            return this.autoEnable;
        }

        @Deprecated
        public final void setAutoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
        }

        @Override
        @Deprecated
        public final Builder autoEnable(Boolean autoEnable) {
            this.autoEnable = autoEnable;
            return this;
        }

        @Deprecated
        public final OrganizationDataSourceConfigurations.Builder getDataSources() {
            return this.dataSources != null ? this.dataSources.toBuilder() : null;
        }

        @Deprecated
        public final void setDataSources(OrganizationDataSourceConfigurations.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        @Deprecated
        public final Builder dataSources(OrganizationDataSourceConfigurations dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<OrganizationFeatureConfiguration.Builder> getFeatures() {
            List<OrganizationFeatureConfiguration.Builder> result = OrganizationFeaturesConfigurationsCopier.copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<OrganizationFeatureConfiguration.BuilderImpl> features) {
            this.features = OrganizationFeaturesConfigurationsCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<OrganizationFeatureConfiguration> features) {
            this.features = OrganizationFeaturesConfigurationsCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(OrganizationFeatureConfiguration ... features) {
            this.features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<OrganizationFeatureConfiguration.Builder> ... features) {
            this.features(Stream.of(features).map(c -> (OrganizationFeatureConfiguration)((OrganizationFeatureConfiguration.Builder)OrganizationFeatureConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAutoEnableOrganizationMembers() {
            return this.autoEnableOrganizationMembers;
        }

        public final void setAutoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(String autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers = autoEnableOrganizationMembers;
            return this;
        }

        @Override
        public final Builder autoEnableOrganizationMembers(AutoEnableMembers autoEnableOrganizationMembers) {
            this.autoEnableOrganizationMembers(autoEnableOrganizationMembers == null ? null : autoEnableOrganizationMembers.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOrganizationConfigurationRequest build() {
            return new UpdateOrganizationConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends GuardDutyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateOrganizationConfigurationRequest> {
        public Builder detectorId(String var1);

        @Deprecated
        public Builder autoEnable(Boolean var1);

        @Deprecated
        public Builder dataSources(OrganizationDataSourceConfigurations var1);

        @Deprecated
        default public Builder dataSources(Consumer<OrganizationDataSourceConfigurations.Builder> dataSources) {
            return this.dataSources((OrganizationDataSourceConfigurations)((OrganizationDataSourceConfigurations.Builder)OrganizationDataSourceConfigurations.builder().applyMutation(dataSources)).build());
        }

        public Builder features(Collection<OrganizationFeatureConfiguration> var1);

        public Builder features(OrganizationFeatureConfiguration ... var1);

        public Builder features(Consumer<OrganizationFeatureConfiguration.Builder> ... var1);

        public Builder autoEnableOrganizationMembers(String var1);

        public Builder autoEnableOrganizationMembers(AutoEnableMembers var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

