/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventAccountFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventAccountFilter> {
    private static final SdkField<String> EVENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventArn").getter(EventAccountFilter.getter(EventAccountFilter::eventArn)).setter(EventAccountFilter.setter(Builder::eventArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventArn").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(EventAccountFilter.getter(EventAccountFilter::awsAccountId)).setter(EventAccountFilter.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ARN_FIELD, AWS_ACCOUNT_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventArn;
    private final String awsAccountId;

    private EventAccountFilter(BuilderImpl builder) {
        this.eventArn = builder.eventArn;
        this.awsAccountId = builder.awsAccountId;
    }

    public final String eventArn() {
        return this.eventArn;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventAccountFilter)) {
            return false;
        }
        EventAccountFilter other = (EventAccountFilter)obj;
        return Objects.equals(this.eventArn(), other.eventArn()) && Objects.equals(this.awsAccountId(), other.awsAccountId());
    }

    public final String toString() {
        return ToString.builder((String)"EventAccountFilter").add("EventArn", (Object)this.eventArn()).add("AwsAccountId", (Object)this.awsAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventArn": {
                return Optional.ofNullable(clazz.cast(this.eventArn()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EventAccountFilter, T> g) {
        return obj -> g.apply((EventAccountFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventArn;
        private String awsAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(EventAccountFilter model) {
            this.eventArn(model.eventArn);
            this.awsAccountId(model.awsAccountId);
        }

        public final String getEventArn() {
            return this.eventArn;
        }

        public final void setEventArn(String eventArn) {
            this.eventArn = eventArn;
        }

        @Override
        public final Builder eventArn(String eventArn) {
            this.eventArn = eventArn;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public EventAccountFilter build() {
            return new EventAccountFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventAccountFilter> {
        public Builder eventArn(String var1);

        public Builder awsAccountId(String var1);
    }
}

