/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.health.model.EntityStatusCode;
import software.amazon.awssdk.services.health.model._entityStatusesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AccountEntityAggregate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AccountEntityAggregate> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(AccountEntityAggregate.getter(AccountEntityAggregate::accountId)).setter(AccountEntityAggregate.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Integer> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("count").getter(AccountEntityAggregate.getter(AccountEntityAggregate::count)).setter(AccountEntityAggregate.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<Map<String, Integer>> STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("statuses").getter(AccountEntityAggregate.getter(AccountEntityAggregate::statusesAsStrings)).setter(AccountEntityAggregate.setter(Builder::statusesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statuses").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, COUNT_FIELD, STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AccountEntityAggregate.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Integer count;
    private final Map<String, Integer> statuses;

    private AccountEntityAggregate(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.count = builder.count;
        this.statuses = builder.statuses;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Integer count() {
        return this.count;
    }

    public final Map<EntityStatusCode, Integer> statuses() {
        return _entityStatusesCopier.copyStringToEnum(this.statuses);
    }

    public final boolean hasStatuses() {
        return this.statuses != null && !(this.statuses instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> statusesAsStrings() {
        return this.statuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatuses() ? this.statusesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountEntityAggregate)) {
            return false;
        }
        AccountEntityAggregate other = (AccountEntityAggregate)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.count(), other.count()) && this.hasStatuses() == other.hasStatuses() && Objects.equals(this.statusesAsStrings(), other.statusesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"AccountEntityAggregate").add("AccountId", (Object)this.accountId()).add("Count", (Object)this.count()).add("Statuses", this.hasStatuses() ? this.statusesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "statuses": {
                return Optional.ofNullable(clazz.cast(this.statusesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("count", COUNT_FIELD);
        map.put("statuses", STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountEntityAggregate, T> g) {
        return obj -> g.apply((AccountEntityAggregate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Integer count;
        private Map<String, Integer> statuses = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AccountEntityAggregate model) {
            this.accountId(model.accountId);
            this.count(model.count);
            this.statusesWithStrings(model.statuses);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Integer getCount() {
            return this.count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Map<String, Integer> getStatuses() {
            if (this.statuses instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.statuses;
        }

        public final void setStatuses(Map<String, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copy(statuses);
        }

        @Override
        public final Builder statusesWithStrings(Map<String, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copy(statuses);
            return this;
        }

        @Override
        public final Builder statuses(Map<EntityStatusCode, Integer> statuses) {
            this.statuses = _entityStatusesCopier.copyEnumToString(statuses);
            return this;
        }

        public AccountEntityAggregate build() {
            return new AccountEntityAggregate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AccountEntityAggregate> {
        public Builder accountId(String var1);

        public Builder count(Integer var1);

        public Builder statusesWithStrings(Map<String, Integer> var1);

        public Builder statuses(Map<EntityStatusCode, Integer> var1);
    }
}

