/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.health.model.EventTypeActionability;
import software.amazon.awssdk.services.health.model.EventTypeActionabilityListCopier;
import software.amazon.awssdk.services.health.model.EventTypeCategory;
import software.amazon.awssdk.services.health.model.EventTypeCategoryListCopier;
import software.amazon.awssdk.services.health.model.EventTypeCodeListCopier;
import software.amazon.awssdk.services.health.model.EventTypePersona;
import software.amazon.awssdk.services.health.model.EventTypePersonaListCopier;
import software.amazon.awssdk.services.health.model._serviceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventTypeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventTypeFilter> {
    private static final SdkField<List<String>> EVENT_TYPE_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventTypeCodes").getter(EventTypeFilter.getter(EventTypeFilter::eventTypeCodes)).setter(EventTypeFilter.setter(Builder::eventTypeCodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("services").getter(EventTypeFilter.getter(EventTypeFilter::services)).setter(EventTypeFilter.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EVENT_TYPE_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventTypeCategories").getter(EventTypeFilter.getter(EventTypeFilter::eventTypeCategoriesAsStrings)).setter(EventTypeFilter.setter(Builder::eventTypeCategoriesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeCategories").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ACTIONABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionabilities").getter(EventTypeFilter.getter(EventTypeFilter::actionabilitiesAsStrings)).setter(EventTypeFilter.setter(Builder::actionabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PERSONAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("personas").getter(EventTypeFilter.getter(EventTypeFilter::personasAsStrings)).setter(EventTypeFilter.setter(Builder::personasWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("personas").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_CODES_FIELD, SERVICES_FIELD, EVENT_TYPE_CATEGORIES_FIELD, ACTIONABILITIES_FIELD, PERSONAS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventTypeFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> eventTypeCodes;
    private final List<String> services;
    private final List<String> eventTypeCategories;
    private final List<String> actionabilities;
    private final List<String> personas;

    private EventTypeFilter(BuilderImpl builder) {
        this.eventTypeCodes = builder.eventTypeCodes;
        this.services = builder.services;
        this.eventTypeCategories = builder.eventTypeCategories;
        this.actionabilities = builder.actionabilities;
        this.personas = builder.personas;
    }

    public final boolean hasEventTypeCodes() {
        return this.eventTypeCodes != null && !(this.eventTypeCodes instanceof SdkAutoConstructList);
    }

    public final List<String> eventTypeCodes() {
        return this.eventTypeCodes;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<String> services() {
        return this.services;
    }

    public final List<EventTypeCategory> eventTypeCategories() {
        return EventTypeCategoryListCopier.copyStringToEnum(this.eventTypeCategories);
    }

    public final boolean hasEventTypeCategories() {
        return this.eventTypeCategories != null && !(this.eventTypeCategories instanceof SdkAutoConstructList);
    }

    public final List<String> eventTypeCategoriesAsStrings() {
        return this.eventTypeCategories;
    }

    public final List<EventTypeActionability> actionabilities() {
        return EventTypeActionabilityListCopier.copyStringToEnum(this.actionabilities);
    }

    public final boolean hasActionabilities() {
        return this.actionabilities != null && !(this.actionabilities instanceof SdkAutoConstructList);
    }

    public final List<String> actionabilitiesAsStrings() {
        return this.actionabilities;
    }

    public final List<EventTypePersona> personas() {
        return EventTypePersonaListCopier.copyStringToEnum(this.personas);
    }

    public final boolean hasPersonas() {
        return this.personas != null && !(this.personas instanceof SdkAutoConstructList);
    }

    public final List<String> personasAsStrings() {
        return this.personas;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTypeCodes() ? this.eventTypeCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventTypeCategories() ? this.eventTypeCategoriesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionabilities() ? this.actionabilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPersonas() ? this.personasAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTypeFilter)) {
            return false;
        }
        EventTypeFilter other = (EventTypeFilter)obj;
        return this.hasEventTypeCodes() == other.hasEventTypeCodes() && Objects.equals(this.eventTypeCodes(), other.eventTypeCodes()) && this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services()) && this.hasEventTypeCategories() == other.hasEventTypeCategories() && Objects.equals(this.eventTypeCategoriesAsStrings(), other.eventTypeCategoriesAsStrings()) && this.hasActionabilities() == other.hasActionabilities() && Objects.equals(this.actionabilitiesAsStrings(), other.actionabilitiesAsStrings()) && this.hasPersonas() == other.hasPersonas() && Objects.equals(this.personasAsStrings(), other.personasAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"EventTypeFilter").add("EventTypeCodes", this.hasEventTypeCodes() ? this.eventTypeCodes() : null).add("Services", this.hasServices() ? this.services() : null).add("EventTypeCategories", this.hasEventTypeCategories() ? this.eventTypeCategoriesAsStrings() : null).add("Actionabilities", this.hasActionabilities() ? this.actionabilitiesAsStrings() : null).add("Personas", this.hasPersonas() ? this.personasAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventTypeCodes": {
                return Optional.ofNullable(clazz.cast(this.eventTypeCodes()));
            }
            case "services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
            case "eventTypeCategories": {
                return Optional.ofNullable(clazz.cast(this.eventTypeCategoriesAsStrings()));
            }
            case "actionabilities": {
                return Optional.ofNullable(clazz.cast(this.actionabilitiesAsStrings()));
            }
            case "personas": {
                return Optional.ofNullable(clazz.cast(this.personasAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("eventTypeCodes", EVENT_TYPE_CODES_FIELD);
        map.put("services", SERVICES_FIELD);
        map.put("eventTypeCategories", EVENT_TYPE_CATEGORIES_FIELD);
        map.put("actionabilities", ACTIONABILITIES_FIELD);
        map.put("personas", PERSONAS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventTypeFilter, T> g) {
        return obj -> g.apply((EventTypeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> eventTypeCodes = DefaultSdkAutoConstructList.getInstance();
        private List<String> services = DefaultSdkAutoConstructList.getInstance();
        private List<String> eventTypeCategories = DefaultSdkAutoConstructList.getInstance();
        private List<String> actionabilities = DefaultSdkAutoConstructList.getInstance();
        private List<String> personas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EventTypeFilter model) {
            this.eventTypeCodes(model.eventTypeCodes);
            this.services(model.services);
            this.eventTypeCategoriesWithStrings(model.eventTypeCategories);
            this.actionabilitiesWithStrings(model.actionabilities);
            this.personasWithStrings(model.personas);
        }

        public final Collection<String> getEventTypeCodes() {
            if (this.eventTypeCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventTypeCodes;
        }

        public final void setEventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = EventTypeCodeListCopier.copy(eventTypeCodes);
        }

        @Override
        public final Builder eventTypeCodes(Collection<String> eventTypeCodes) {
            this.eventTypeCodes = EventTypeCodeListCopier.copy(eventTypeCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCodes(String ... eventTypeCodes) {
            this.eventTypeCodes(Arrays.asList(eventTypeCodes));
            return this;
        }

        public final Collection<String> getServices() {
            if (this.services instanceof SdkAutoConstructList) {
                return null;
            }
            return this.services;
        }

        public final void setServices(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
        }

        @Override
        public final Builder services(Collection<String> services) {
            this.services = _serviceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(String ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        public final Collection<String> getEventTypeCategories() {
            if (this.eventTypeCategories instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eventTypeCategories;
        }

        public final void setEventTypeCategories(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copy(eventTypeCategories);
        }

        @Override
        public final Builder eventTypeCategoriesWithStrings(Collection<String> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copy(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategoriesWithStrings(String ... eventTypeCategories) {
            this.eventTypeCategoriesWithStrings(Arrays.asList(eventTypeCategories));
            return this;
        }

        @Override
        public final Builder eventTypeCategories(Collection<EventTypeCategory> eventTypeCategories) {
            this.eventTypeCategories = EventTypeCategoryListCopier.copyEnumToString(eventTypeCategories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventTypeCategories(EventTypeCategory ... eventTypeCategories) {
            this.eventTypeCategories(Arrays.asList(eventTypeCategories));
            return this;
        }

        public final Collection<String> getActionabilities() {
            if (this.actionabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actionabilities;
        }

        public final void setActionabilities(Collection<String> actionabilities) {
            this.actionabilities = EventTypeActionabilityListCopier.copy(actionabilities);
        }

        @Override
        public final Builder actionabilitiesWithStrings(Collection<String> actionabilities) {
            this.actionabilities = EventTypeActionabilityListCopier.copy(actionabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionabilitiesWithStrings(String ... actionabilities) {
            this.actionabilitiesWithStrings(Arrays.asList(actionabilities));
            return this;
        }

        @Override
        public final Builder actionabilities(Collection<EventTypeActionability> actionabilities) {
            this.actionabilities = EventTypeActionabilityListCopier.copyEnumToString(actionabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionabilities(EventTypeActionability ... actionabilities) {
            this.actionabilities(Arrays.asList(actionabilities));
            return this;
        }

        public final Collection<String> getPersonas() {
            if (this.personas instanceof SdkAutoConstructList) {
                return null;
            }
            return this.personas;
        }

        public final void setPersonas(Collection<String> personas) {
            this.personas = EventTypePersonaListCopier.copy(personas);
        }

        @Override
        public final Builder personasWithStrings(Collection<String> personas) {
            this.personas = EventTypePersonaListCopier.copy(personas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personasWithStrings(String ... personas) {
            this.personasWithStrings(Arrays.asList(personas));
            return this;
        }

        @Override
        public final Builder personas(Collection<EventTypePersona> personas) {
            this.personas = EventTypePersonaListCopier.copyEnumToString(personas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder personas(EventTypePersona ... personas) {
            this.personas(Arrays.asList(personas));
            return this;
        }

        public EventTypeFilter build() {
            return new EventTypeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventTypeFilter> {
        public Builder eventTypeCodes(Collection<String> var1);

        public Builder eventTypeCodes(String ... var1);

        public Builder services(Collection<String> var1);

        public Builder services(String ... var1);

        public Builder eventTypeCategoriesWithStrings(Collection<String> var1);

        public Builder eventTypeCategoriesWithStrings(String ... var1);

        public Builder eventTypeCategories(Collection<EventTypeCategory> var1);

        public Builder eventTypeCategories(EventTypeCategory ... var1);

        public Builder actionabilitiesWithStrings(Collection<String> var1);

        public Builder actionabilitiesWithStrings(String ... var1);

        public Builder actionabilities(Collection<EventTypeActionability> var1);

        public Builder actionabilities(EventTypeActionability ... var1);

        public Builder personasWithStrings(Collection<String> var1);

        public Builder personasWithStrings(String ... var1);

        public Builder personas(Collection<EventTypePersona> var1);

        public Builder personas(EventTypePersona ... var1);
    }
}

