/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.health.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.health.HealthAsyncClient;
import software.amazon.awssdk.services.health.internal.UserAgentUtils;
import software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationRequest;
import software.amazon.awssdk.services.health.model.DescribeEventsForOrganizationResponse;
import software.amazon.awssdk.services.health.model.OrganizationEvent;

public class DescribeEventsForOrganizationPublisher
implements SdkPublisher<DescribeEventsForOrganizationResponse> {
    private final HealthAsyncClient client;
    private final DescribeEventsForOrganizationRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEventsForOrganizationPublisher(HealthAsyncClient client, DescribeEventsForOrganizationRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEventsForOrganizationPublisher(HealthAsyncClient client, DescribeEventsForOrganizationRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEventsForOrganizationResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEventsForOrganizationResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrganizationEvent> events() {
        Function<DescribeEventsForOrganizationResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEventsForOrganizationResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEventsForOrganizationResponseFetcher
    implements AsyncPageFetcher<DescribeEventsForOrganizationResponse> {
        private DescribeEventsForOrganizationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventsForOrganizationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEventsForOrganizationResponse> nextPage(DescribeEventsForOrganizationResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventsForOrganizationPublisher.this.client.describeEventsForOrganization(DescribeEventsForOrganizationPublisher.this.firstRequest);
            }
            return DescribeEventsForOrganizationPublisher.this.client.describeEventsForOrganization((DescribeEventsForOrganizationRequest)((Object)DescribeEventsForOrganizationPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

