/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.healthlake.DefaultHealthLakeAsyncClient;
import software.amazon.awssdk.services.healthlake.DefaultHealthLakeBaseClientBuilder;
import software.amazon.awssdk.services.healthlake.HealthLakeAsyncClient;
import software.amazon.awssdk.services.healthlake.HealthLakeAsyncClientBuilder;
import software.amazon.awssdk.services.healthlake.HealthLakeServiceClientConfiguration;
import software.amazon.awssdk.services.healthlake.endpoints.HealthLakeEndpointProvider;

@SdkInternalApi
final class DefaultHealthLakeAsyncClientBuilder
extends DefaultHealthLakeBaseClientBuilder<HealthLakeAsyncClientBuilder, HealthLakeAsyncClient>
implements HealthLakeAsyncClientBuilder {
    DefaultHealthLakeAsyncClientBuilder() {
    }

    @Override
    public DefaultHealthLakeAsyncClientBuilder endpointProvider(HealthLakeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final HealthLakeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultHealthLakeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        HealthLakeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultHealthLakeAsyncClient client = new DefaultHealthLakeAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private HealthLakeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return HealthLakeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

