/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ErrorCategory {
    RETRYABLE_ERROR("RETRYABLE_ERROR"),
    NON_RETRYABLE_ERROR("NON_RETRYABLE_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorCategory> VALUE_MAP;
    private final String value;

    private ErrorCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ErrorCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ErrorCategory> knownValues() {
        EnumSet<ErrorCategory> knownValues = EnumSet.allOf(ErrorCategory.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ErrorCategory.class, ErrorCategory::toString);
    }
}

