/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.healthlake.model.AuthorizationStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IdentityProviderConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IdentityProviderConfiguration> {
    private static final SdkField<String> AUTHORIZATION_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AuthorizationStrategy").getter(IdentityProviderConfiguration.getter(IdentityProviderConfiguration::authorizationStrategyAsString)).setter(IdentityProviderConfiguration.setter(Builder::authorizationStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizationStrategy").build()}).build();
    private static final SdkField<Boolean> FINE_GRAINED_AUTHORIZATION_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("FineGrainedAuthorizationEnabled").getter(IdentityProviderConfiguration.getter(IdentityProviderConfiguration::fineGrainedAuthorizationEnabled)).setter(IdentityProviderConfiguration.setter(Builder::fineGrainedAuthorizationEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FineGrainedAuthorizationEnabled").build()}).build();
    private static final SdkField<String> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metadata").getter(IdentityProviderConfiguration.getter(IdentityProviderConfiguration::metadata)).setter(IdentityProviderConfiguration.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<String> IDP_LAMBDA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdpLambdaArn").getter(IdentityProviderConfiguration.getter(IdentityProviderConfiguration::idpLambdaArn)).setter(IdentityProviderConfiguration.setter(Builder::idpLambdaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdpLambdaArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_STRATEGY_FIELD, FINE_GRAINED_AUTHORIZATION_ENABLED_FIELD, METADATA_FIELD, IDP_LAMBDA_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authorizationStrategy;
    private final Boolean fineGrainedAuthorizationEnabled;
    private final String metadata;
    private final String idpLambdaArn;

    private IdentityProviderConfiguration(BuilderImpl builder) {
        this.authorizationStrategy = builder.authorizationStrategy;
        this.fineGrainedAuthorizationEnabled = builder.fineGrainedAuthorizationEnabled;
        this.metadata = builder.metadata;
        this.idpLambdaArn = builder.idpLambdaArn;
    }

    public final AuthorizationStrategy authorizationStrategy() {
        return AuthorizationStrategy.fromValue(this.authorizationStrategy);
    }

    public final String authorizationStrategyAsString() {
        return this.authorizationStrategy;
    }

    public final Boolean fineGrainedAuthorizationEnabled() {
        return this.fineGrainedAuthorizationEnabled;
    }

    public final String metadata() {
        return this.metadata;
    }

    public final String idpLambdaArn() {
        return this.idpLambdaArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fineGrainedAuthorizationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.idpLambdaArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderConfiguration)) {
            return false;
        }
        IdentityProviderConfiguration other = (IdentityProviderConfiguration)obj;
        return Objects.equals(this.authorizationStrategyAsString(), other.authorizationStrategyAsString()) && Objects.equals(this.fineGrainedAuthorizationEnabled(), other.fineGrainedAuthorizationEnabled()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.idpLambdaArn(), other.idpLambdaArn());
    }

    public final String toString() {
        return ToString.builder((String)"IdentityProviderConfiguration").add("AuthorizationStrategy", (Object)this.authorizationStrategyAsString()).add("FineGrainedAuthorizationEnabled", (Object)this.fineGrainedAuthorizationEnabled()).add("Metadata", (Object)this.metadata()).add("IdpLambdaArn", (Object)this.idpLambdaArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizationStrategy": {
                return Optional.ofNullable(clazz.cast(this.authorizationStrategyAsString()));
            }
            case "FineGrainedAuthorizationEnabled": {
                return Optional.ofNullable(clazz.cast(this.fineGrainedAuthorizationEnabled()));
            }
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "IdpLambdaArn": {
                return Optional.ofNullable(clazz.cast(this.idpLambdaArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderConfiguration, T> g) {
        return obj -> g.apply((IdentityProviderConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizationStrategy;
        private Boolean fineGrainedAuthorizationEnabled;
        private String metadata;
        private String idpLambdaArn;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderConfiguration model) {
            this.authorizationStrategy(model.authorizationStrategy);
            this.fineGrainedAuthorizationEnabled(model.fineGrainedAuthorizationEnabled);
            this.metadata(model.metadata);
            this.idpLambdaArn(model.idpLambdaArn);
        }

        public final String getAuthorizationStrategy() {
            return this.authorizationStrategy;
        }

        public final void setAuthorizationStrategy(String authorizationStrategy) {
            this.authorizationStrategy = authorizationStrategy;
        }

        @Override
        public final Builder authorizationStrategy(String authorizationStrategy) {
            this.authorizationStrategy = authorizationStrategy;
            return this;
        }

        @Override
        public final Builder authorizationStrategy(AuthorizationStrategy authorizationStrategy) {
            this.authorizationStrategy(authorizationStrategy == null ? null : authorizationStrategy.toString());
            return this;
        }

        public final Boolean getFineGrainedAuthorizationEnabled() {
            return this.fineGrainedAuthorizationEnabled;
        }

        public final void setFineGrainedAuthorizationEnabled(Boolean fineGrainedAuthorizationEnabled) {
            this.fineGrainedAuthorizationEnabled = fineGrainedAuthorizationEnabled;
        }

        @Override
        public final Builder fineGrainedAuthorizationEnabled(Boolean fineGrainedAuthorizationEnabled) {
            this.fineGrainedAuthorizationEnabled = fineGrainedAuthorizationEnabled;
            return this;
        }

        public final String getMetadata() {
            return this.metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getIdpLambdaArn() {
            return this.idpLambdaArn;
        }

        public final void setIdpLambdaArn(String idpLambdaArn) {
            this.idpLambdaArn = idpLambdaArn;
        }

        @Override
        public final Builder idpLambdaArn(String idpLambdaArn) {
            this.idpLambdaArn = idpLambdaArn;
            return this;
        }

        public IdentityProviderConfiguration build() {
            return new IdentityProviderConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IdentityProviderConfiguration> {
        public Builder authorizationStrategy(String var1);

        public Builder authorizationStrategy(AuthorizationStrategy var1);

        public Builder fineGrainedAuthorizationEnabled(Boolean var1);

        public Builder metadata(String var1);

        public Builder idpLambdaArn(String var1);
    }
}

