/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.healthlake.HealthLakeClient;
import software.amazon.awssdk.services.healthlake.internal.UserAgentUtils;
import software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsRequest;
import software.amazon.awssdk.services.healthlake.model.ListFhirExportJobsResponse;

public class ListFHIRExportJobsIterable
implements SdkIterable<ListFhirExportJobsResponse> {
    private final HealthLakeClient client;
    private final ListFhirExportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFHIRExportJobsIterable(HealthLakeClient client, ListFhirExportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFhirExportJobsResponseFetcher();
    }

    public Iterator<ListFhirExportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListFhirExportJobsResponseFetcher
    implements SyncPageFetcher<ListFhirExportJobsResponse> {
        private ListFhirExportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListFhirExportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFhirExportJobsResponse nextPage(ListFhirExportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListFHIRExportJobsIterable.this.client.listFHIRExportJobs(ListFHIRExportJobsIterable.this.firstRequest);
            }
            return ListFHIRExportJobsIterable.this.client.listFHIRExportJobs((ListFhirExportJobsRequest)((Object)ListFHIRExportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

