/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.healthlake.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.healthlake.HealthLakeAsyncClient;
import software.amazon.awssdk.services.healthlake.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirDatastoreResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirExportJobResponse;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobRequest;
import software.amazon.awssdk.services.healthlake.model.DescribeFhirImportJobResponse;
import software.amazon.awssdk.services.healthlake.model.HealthLakeRequest;
import software.amazon.awssdk.services.healthlake.waiters.HealthLakeAsyncWaiter;
import software.amazon.awssdk.services.healthlake.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultHealthLakeAsyncWaiter
implements HealthLakeAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final HealthLakeAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeFhirDatastoreResponse> fHIRDatastoreActiveWaiter;
    private final AsyncWaiter<DescribeFhirDatastoreResponse> fHIRDatastoreDeletedWaiter;
    private final AsyncWaiter<DescribeFhirExportJobResponse> fHIRExportJobCompletedWaiter;
    private final AsyncWaiter<DescribeFhirImportJobResponse> fHIRImportJobCompletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultHealthLakeAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (HealthLakeAsyncClient)HealthLakeAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.fHIRDatastoreActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFhirDatastoreResponse.class).acceptors(DefaultHealthLakeAsyncWaiter.fHIRDatastoreActiveWaiterAcceptors())).overrideConfiguration(DefaultHealthLakeAsyncWaiter.fHIRDatastoreActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.fHIRDatastoreDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFhirDatastoreResponse.class).acceptors(DefaultHealthLakeAsyncWaiter.fHIRDatastoreDeletedWaiterAcceptors())).overrideConfiguration(DefaultHealthLakeAsyncWaiter.fHIRDatastoreDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.fHIRExportJobCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFhirExportJobResponse.class).acceptors(DefaultHealthLakeAsyncWaiter.fHIRExportJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultHealthLakeAsyncWaiter.fHIRExportJobCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.fHIRImportJobCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeFhirImportJobResponse.class).acceptors(DefaultHealthLakeAsyncWaiter.fHIRImportJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultHealthLakeAsyncWaiter.fHIRImportJobCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFhirDatastoreResponse>> waitUntilFHIRDatastoreActive(DescribeFhirDatastoreRequest describeFhirDatastoreRequest) {
        return this.fHIRDatastoreActiveWaiter.runAsync(() -> this.client.describeFHIRDatastore(this.applyWaitersUserAgent(describeFhirDatastoreRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFhirDatastoreResponse>> waitUntilFHIRDatastoreActive(DescribeFhirDatastoreRequest describeFhirDatastoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fHIRDatastoreActiveWaiter.runAsync(() -> this.client.describeFHIRDatastore(this.applyWaitersUserAgent(describeFhirDatastoreRequest)), DefaultHealthLakeAsyncWaiter.fHIRDatastoreActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFhirDatastoreResponse>> waitUntilFHIRDatastoreDeleted(DescribeFhirDatastoreRequest describeFhirDatastoreRequest) {
        return this.fHIRDatastoreDeletedWaiter.runAsync(() -> this.client.describeFHIRDatastore(this.applyWaitersUserAgent(describeFhirDatastoreRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFhirDatastoreResponse>> waitUntilFHIRDatastoreDeleted(DescribeFhirDatastoreRequest describeFhirDatastoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fHIRDatastoreDeletedWaiter.runAsync(() -> this.client.describeFHIRDatastore(this.applyWaitersUserAgent(describeFhirDatastoreRequest)), DefaultHealthLakeAsyncWaiter.fHIRDatastoreDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFhirExportJobResponse>> waitUntilFHIRExportJobCompleted(DescribeFhirExportJobRequest describeFhirExportJobRequest) {
        return this.fHIRExportJobCompletedWaiter.runAsync(() -> this.client.describeFHIRExportJob(this.applyWaitersUserAgent(describeFhirExportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFhirExportJobResponse>> waitUntilFHIRExportJobCompleted(DescribeFhirExportJobRequest describeFhirExportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fHIRExportJobCompletedWaiter.runAsync(() -> this.client.describeFHIRExportJob(this.applyWaitersUserAgent(describeFhirExportJobRequest)), DefaultHealthLakeAsyncWaiter.fHIRExportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFhirImportJobResponse>> waitUntilFHIRImportJobCompleted(DescribeFhirImportJobRequest describeFhirImportJobRequest) {
        return this.fHIRImportJobCompletedWaiter.runAsync(() -> this.client.describeFHIRImportJob(this.applyWaitersUserAgent(describeFhirImportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeFhirImportJobResponse>> waitUntilFHIRImportJobCompleted(DescribeFhirImportJobRequest describeFhirImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fHIRImportJobCompletedWaiter.runAsync(() -> this.client.describeFHIRImportJob(this.applyWaitersUserAgent(describeFhirImportJobRequest)), DefaultHealthLakeAsyncWaiter.fHIRImportJobCompletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeFhirDatastoreResponse>> fHIRDatastoreActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFhirDatastoreResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFhirDatastoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("DatastoreProperties").field("DatastoreStatus").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("DatastoreProperties").field("DatastoreStatus").value(), "CREATE_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (DatastoreProperties.DatastoreStatus=CREATE_FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("DatastoreProperties").field("DatastoreStatus").value(), "DELETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (DatastoreProperties.DatastoreStatus=DELETED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFhirDatastoreResponse>> fHIRDatastoreDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFhirDatastoreResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFhirDatastoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("DatastoreProperties").field("DatastoreStatus").value(), "DELETED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFhirExportJobResponse>> fHIRExportJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFhirExportJobResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFhirExportJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportJobProperties").field("JobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportJobProperties").field("JobStatus").value(), "COMPLETED_WITH_ERRORS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportJobProperties").field("JobStatus").value(), "CANCEL_COMPLETED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ExportJobProperties.JobStatus=CANCEL_COMPLETED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportJobProperties").field("JobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ExportJobProperties.JobStatus=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ExportJobProperties").field("JobStatus").value(), "CANCEL_FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ExportJobProperties.JobStatus=CANCEL_FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFhirImportJobResponse>> fHIRImportJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFhirImportJobResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFhirImportJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ImportJobProperties").field("JobStatus").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ImportJobProperties").field("JobStatus").value(), "COMPLETED_WITH_ERRORS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("ImportJobProperties").field("JobStatus").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (ImportJobProperties.JobStatus=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration fHIRDatastoreActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(360);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(60L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration fHIRDatastoreDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(360);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration fHIRExportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(360);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration fHIRImportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(720);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static HealthLakeAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends HealthLakeRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((HealthLakeRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements HealthLakeAsyncWaiter.Builder {
        private HealthLakeAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public HealthLakeAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public HealthLakeAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public HealthLakeAsyncWaiter.Builder client(HealthLakeAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public HealthLakeAsyncWaiter build() {
            return new DefaultHealthLakeAsyncWaiter(this);
        }
    }
}

