/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.honeycode.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpsertTableRowsResponse extends HoneycodeResponse implements
        ToCopyableBuilder<BatchUpsertTableRowsResponse.Builder, BatchUpsertTableRowsResponse> {
    private static final SdkField<Map<String, UpsertRowsResult>> ROWS_FIELD = SdkField
            .<Map<String, UpsertRowsResult>> builder(MarshallingType.MAP)
            .memberName("rows")
            .getter(getter(BatchUpsertTableRowsResponse::rows))
            .setter(setter(Builder::rows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rows").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<UpsertRowsResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpsertRowsResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Long> WORKBOOK_CURSOR_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("workbookCursor").getter(getter(BatchUpsertTableRowsResponse::workbookCursor))
            .setter(setter(Builder::workbookCursor))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workbookCursor").build()).build();

    private static final SdkField<List<FailedBatchItem>> FAILED_BATCH_ITEMS_FIELD = SdkField
            .<List<FailedBatchItem>> builder(MarshallingType.LIST)
            .memberName("failedBatchItems")
            .getter(getter(BatchUpsertTableRowsResponse::failedBatchItems))
            .setter(setter(Builder::failedBatchItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedBatchItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedBatchItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedBatchItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROWS_FIELD,
            WORKBOOK_CURSOR_FIELD, FAILED_BATCH_ITEMS_FIELD));

    private final Map<String, UpsertRowsResult> rows;

    private final Long workbookCursor;

    private final List<FailedBatchItem> failedBatchItems;

    private BatchUpsertTableRowsResponse(BuilderImpl builder) {
        super(builder);
        this.rows = builder.rows;
        this.workbookCursor = builder.workbookCursor;
        this.failedBatchItems = builder.failedBatchItems;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rows property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRows() {
        return rows != null && !(rows instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map with the batch item id as the key and the result of the upsert operation as the value. The result of the
     * upsert operation specifies whether existing rows were updated or a new row was appended, along with the list of
     * row ids that were affected.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRows} method.
     * </p>
     * 
     * @return A map with the batch item id as the key and the result of the upsert operation as the value. The result
     *         of the upsert operation specifies whether existing rows were updated or a new row was appended, along
     *         with the list of row ids that were affected.
     */
    public final Map<String, UpsertRowsResult> rows() {
        return rows;
    }

    /**
     * <p>
     * The updated workbook cursor after updating or appending rows in the table.
     * </p>
     * 
     * @return The updated workbook cursor after updating or appending rows in the table.
     */
    public final Long workbookCursor() {
        return workbookCursor;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailedBatchItems property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailedBatchItems() {
        return failedBatchItems != null && !(failedBatchItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of batch items in the request that could not be updated or appended in the table. Each element in this
     * list contains one item from the request that could not be updated in the table along with the reason why that
     * item could not be updated or appended.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailedBatchItems} method.
     * </p>
     * 
     * @return The list of batch items in the request that could not be updated or appended in the table. Each element
     *         in this list contains one item from the request that could not be updated in the table along with the
     *         reason why that item could not be updated or appended.
     */
    public final List<FailedBatchItem> failedBatchItems() {
        return failedBatchItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRows() ? rows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workbookCursor());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailedBatchItems() ? failedBatchItems() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpsertTableRowsResponse)) {
            return false;
        }
        BatchUpsertTableRowsResponse other = (BatchUpsertTableRowsResponse) obj;
        return hasRows() == other.hasRows() && Objects.equals(rows(), other.rows())
                && Objects.equals(workbookCursor(), other.workbookCursor())
                && hasFailedBatchItems() == other.hasFailedBatchItems()
                && Objects.equals(failedBatchItems(), other.failedBatchItems());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpsertTableRowsResponse").add("Rows", hasRows() ? rows() : null)
                .add("WorkbookCursor", workbookCursor())
                .add("FailedBatchItems", hasFailedBatchItems() ? failedBatchItems() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rows":
            return Optional.ofNullable(clazz.cast(rows()));
        case "workbookCursor":
            return Optional.ofNullable(clazz.cast(workbookCursor()));
        case "failedBatchItems":
            return Optional.ofNullable(clazz.cast(failedBatchItems()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchUpsertTableRowsResponse, T> g) {
        return obj -> g.apply((BatchUpsertTableRowsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends HoneycodeResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchUpsertTableRowsResponse> {
        /**
         * <p>
         * A map with the batch item id as the key and the result of the upsert operation as the value. The result of
         * the upsert operation specifies whether existing rows were updated or a new row was appended, along with the
         * list of row ids that were affected.
         * </p>
         * 
         * @param rows
         *        A map with the batch item id as the key and the result of the upsert operation as the value. The
         *        result of the upsert operation specifies whether existing rows were updated or a new row was appended,
         *        along with the list of row ids that were affected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rows(Map<String, UpsertRowsResult> rows);

        /**
         * <p>
         * The updated workbook cursor after updating or appending rows in the table.
         * </p>
         * 
         * @param workbookCursor
         *        The updated workbook cursor after updating or appending rows in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workbookCursor(Long workbookCursor);

        /**
         * <p>
         * The list of batch items in the request that could not be updated or appended in the table. Each element in
         * this list contains one item from the request that could not be updated in the table along with the reason why
         * that item could not be updated or appended.
         * </p>
         * 
         * @param failedBatchItems
         *        The list of batch items in the request that could not be updated or appended in the table. Each
         *        element in this list contains one item from the request that could not be updated in the table along
         *        with the reason why that item could not be updated or appended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedBatchItems(Collection<FailedBatchItem> failedBatchItems);

        /**
         * <p>
         * The list of batch items in the request that could not be updated or appended in the table. Each element in
         * this list contains one item from the request that could not be updated in the table along with the reason why
         * that item could not be updated or appended.
         * </p>
         * 
         * @param failedBatchItems
         *        The list of batch items in the request that could not be updated or appended in the table. Each
         *        element in this list contains one item from the request that could not be updated in the table along
         *        with the reason why that item could not be updated or appended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedBatchItems(FailedBatchItem... failedBatchItems);

        /**
         * <p>
         * The list of batch items in the request that could not be updated or appended in the table. Each element in
         * this list contains one item from the request that could not be updated in the table along with the reason why
         * that item could not be updated or appended.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.honeycode.model.FailedBatchItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.honeycode.model.FailedBatchItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.honeycode.model.FailedBatchItem.Builder#build()} is called immediately
         * and its result is passed to {@link #failedBatchItems(List<FailedBatchItem>)}.
         * 
         * @param failedBatchItems
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.honeycode.model.FailedBatchItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failedBatchItems(java.util.Collection<FailedBatchItem>)
         */
        Builder failedBatchItems(Consumer<FailedBatchItem.Builder>... failedBatchItems);
    }

    static final class BuilderImpl extends HoneycodeResponse.BuilderImpl implements Builder {
        private Map<String, UpsertRowsResult> rows = DefaultSdkAutoConstructMap.getInstance();

        private Long workbookCursor;

        private List<FailedBatchItem> failedBatchItems = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpsertTableRowsResponse model) {
            super(model);
            rows(model.rows);
            workbookCursor(model.workbookCursor);
            failedBatchItems(model.failedBatchItems);
        }

        public final Map<String, UpsertRowsResult.Builder> getRows() {
            Map<String, UpsertRowsResult.Builder> result = UpsertRowsResultMapCopier.copyToBuilder(this.rows);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRows(Map<String, UpsertRowsResult.BuilderImpl> rows) {
            this.rows = UpsertRowsResultMapCopier.copyFromBuilder(rows);
        }

        @Override
        public final Builder rows(Map<String, UpsertRowsResult> rows) {
            this.rows = UpsertRowsResultMapCopier.copy(rows);
            return this;
        }

        public final Long getWorkbookCursor() {
            return workbookCursor;
        }

        public final void setWorkbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
        }

        @Override
        public final Builder workbookCursor(Long workbookCursor) {
            this.workbookCursor = workbookCursor;
            return this;
        }

        public final List<FailedBatchItem.Builder> getFailedBatchItems() {
            List<FailedBatchItem.Builder> result = FailedBatchItemsCopier.copyToBuilder(this.failedBatchItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedBatchItems(Collection<FailedBatchItem.BuilderImpl> failedBatchItems) {
            this.failedBatchItems = FailedBatchItemsCopier.copyFromBuilder(failedBatchItems);
        }

        @Override
        public final Builder failedBatchItems(Collection<FailedBatchItem> failedBatchItems) {
            this.failedBatchItems = FailedBatchItemsCopier.copy(failedBatchItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatchItems(FailedBatchItem... failedBatchItems) {
            failedBatchItems(Arrays.asList(failedBatchItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedBatchItems(Consumer<FailedBatchItem.Builder>... failedBatchItems) {
            failedBatchItems(Stream.of(failedBatchItems).map(c -> FailedBatchItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpsertTableRowsResponse build() {
            return new BatchUpsertTableRowsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
